/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.Parser;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.ClassUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class AbstractParser
implements Parser {
    protected final Logger log;
    protected static final Logger klog = Logger.getLogger(AbstractParser.class);
    protected final Comment fComment;
    private Class fRepClass;
    private String fRepClassName;
    private File _importFile;
    private Object _importObjName;
    private PrintWriter _exportPw;
    private boolean fSilentMode;

    protected AbstractParser(Class repClass) {
        if (repClass == null) {
            throw new IllegalArgumentException("Parameter repClass cannot be null");
        }
        this.log = Logger.getLogger(AbstractParser.class);
        this.fComment = new Comment();
        this.fRepClass = repClass;
        this.fRepClassName = ClassUtils.shorten(this.fRepClass);
    }

    public void export(PersistentObject pob, OutputStream os) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public List parse(String objname, File file) throws Exception {
        this._importFile = file;
        this._importObjName = objname;
        return this.parse(objname, new FileInputStream(file));
    }

    @Override
    public void setSilentMode(boolean silent) {
        this.fSilentMode = silent;
    }

    protected boolean isSilentMode() {
        return this.fSilentMode;
    }

    protected static List unmodlist(PersistentObject pob) {
        ArrayList<PersistentObject> list = new ArrayList<PersistentObject>(1);
        list.add(pob);
        return Collections.unmodifiableList(list);
    }

    protected static List unmodlist(PersistentObject[] pobs) {
        ArrayList<PersistentObject> list = new ArrayList<PersistentObject>(pobs.length);
        for (int i = 0; i < pobs.length; ++i) {
            list.add(pobs[i]);
        }
        return Collections.unmodifiableList(list);
    }

    protected String nextLine(BufferedReader bin) throws IOException {
        return this.nextLine(bin, true);
    }

    protected String nextLine(BufferedReader bin, boolean autoAdd2Comment) throws IOException {
        String currLine = bin.readLine();
        if (currLine == null) {
            return null;
        }
        currLine = currLine.trim();
        while (currLine != null && (currLine.length() == 0 || currLine.startsWith("#"))) {
            if (currLine.startsWith("#") && autoAdd2Comment) {
                this.fComment.add(currLine);
            }
            if ((currLine = bin.readLine()) == null) continue;
            currLine = currLine.trim();
        }
        return currLine;
    }

    protected String nextNonEmptyLine(BufferedReader bin) throws IOException {
        String currLine = bin.readLine();
        if (currLine == null) {
            return null;
        }
        currLine = currLine.trim();
        while (currLine != null && currLine.length() == 0) {
            currLine = bin.readLine();
            if (currLine == null) continue;
            currLine = currLine.trim();
        }
        return currLine;
    }

    protected String nextLineTrimless(BufferedReader bin) throws IOException {
        String currLine = bin.readLine();
        if (currLine == null) {
            return null;
        }
        while (currLine != null && (currLine.length() == 0 || currLine.startsWith("#"))) {
            if (currLine.startsWith("#")) {
                this.fComment.add(currLine);
            }
            currLine = bin.readLine();
        }
        return currLine;
    }

    protected boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        String s = obj.toString();
        if ((s = s.trim()).length() == 0) {
            return true;
        }
        return "NULL".equalsIgnoreCase(s.trim());
    }

    protected boolean isNa(String s) {
        return "na".equalsIgnoreCase(s.trim());
    }

    protected boolean isNullorNa(String s) {
        if (this.isNull(s)) {
            return true;
        }
        return this.isNa(s);
    }

    protected PrintWriter startExport(PersistentObject pob, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        return this.startExport(pob, new FileOutputStream(file), file.getName());
    }

    protected PrintWriter startExport(PersistentObject pob, OutputStream os, String toName) throws IOException {
        if (pob == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("Parameter os cannot be null");
        }
        if (!this.fSilentMode) {
            this.log.debug((Object)("Exporting: " + pob.getName() + " to: " + toName + " " + pob.getClass()));
        }
        this._exportPw = new PrintWriter(os);
        return this._exportPw;
    }

    protected void doneExport() {
        if (this._exportPw != null) {
            this._exportPw.flush();
            this._exportPw.close();
        }
    }

    protected void startImport(String sourcepath) {
        if (!this.fSilentMode) {
            this.log.info((Object)("Begun importing: " + this.fRepClassName + " from: " + sourcepath));
        }
    }

    protected void doneImport() {
    }

    protected static List string2stringsV2(String s, int expectedLen) throws IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        String delim = "\t";
        StringTokenizer tok = new StringTokenizer(s, delim, true);
        ArrayList<String> ret = new ArrayList<String>();
        String prev = null;
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            String curr = tok.nextToken();
            if (cnt == 0) {
                ret.add(curr.trim());
            } else if (curr.equals(delim)) {
                if (prev.equals(delim)) {
                    ret.add("");
                }
            } else {
                ret.add(curr.trim());
            }
            prev = curr;
            ++cnt;
        }
        if (ret.size() == expectedLen) {
            return ret;
        }
        if (ret.size() < expectedLen) {
            for (int i = ret.size(); i < expectedLen; ++i) {
                ret.add("");
            }
            return ret;
        }
        ArrayList real_ret = new ArrayList();
        for (int i = 0; i < ret.size(); ++i) {
            if (i < expectedLen) {
                real_ret.add(ret.get(i));
                continue;
            }
            Object obj = ret.get(i);
            if (obj == null || obj.toString().trim().length() == 0) continue;
            real_ret.add(obj);
        }
        return real_ret;
    }

    protected static int indexOf(String s, List list, boolean barfIfMising) throws ParserException {
        int index = list.indexOf(s);
        if (index == -1 && barfIfMising) {
            throw new ParserException("Column not found: " + s);
        }
        return index;
    }

    protected class Comment {
        private List fLines;
        private Map fKeyValues;

        protected Comment() {
        }

        protected void add(String s) {
            if (s == null || s.length() == 0) {
                return;
            }
            if ((s = s.substring(1, s.length())).length() == 0) {
                return;
            }
            if (s.indexOf(61) != -1) {
                String[] fields;
                if (this.fKeyValues == null) {
                    this.fKeyValues = new HashMap();
                }
                if ((fields = ParseUtils.string2strings(s, "= ", true)).length != 1) {
                    if (fields.length == 2) {
                        this.fKeyValues.put(fields[0].toUpperCase(), fields[1]);
                    } else {
                        AbstractParser.this.log.warn((Object)("Bad comment KEY=VALUE field: Got more tokens than expected: " + fields.length));
                    }
                }
            } else {
                if (this.fLines == null) {
                    this.fLines = new ArrayList();
                }
                this.fLines.add(s);
            }
        }

        public String toString() {
            if (this.fLines == null && this.fKeyValues == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            if (this.fLines != null && !this.fLines.isEmpty()) {
                for (int i = 0; i < this.fLines.size(); ++i) {
                    buf.append(this.fLines.get(i).toString()).append('\n');
                }
            }
            if (this.fKeyValues != null && !this.fKeyValues.isEmpty()) {
                buf.append(this.fKeyValues.toString());
            }
            return buf.toString();
        }
    }
}

