/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.FDistribution;
import java.util.Collection;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class TFA
extends AbstractAlgorithm {
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    public static final int HAS_EMPTY_CELL = 21;
    public static final int ALL_CELLS_HAVE_ONE_SAMPLE = 22;
    public static final int SOME_CELLS_HAVE_ONE_SAMPLE = 23;
    public static final int BALANCED_WITH_REPLICATION = 24;
    public static final int UNBALANCED_WITH_REPLICATION = 25;
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    boolean hierarchical_tree;
    int method_linkage;
    boolean calculate_genes;
    boolean calculate_experiments;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private int[] numFactorLevels;
    private int[] factorAAssignments;
    private int[] factorBAssignments;
    private boolean allCellsHaveOneSample;
    private boolean isBalancedDesign;
    private boolean usePerms;
    private int adjustmentMethod;
    private float alpha;
    private int numPerms;
    double[] origFactorAPValues;
    double[] origFactorBPValues;
    double[] origInteractionPValues;
    double[] factorAFValues;
    double[] factorBFValues;
    double[] interactionFValues;
    double[] factorADfValues;
    double[] factorBDfValues;
    double[] interactionDfValues;
    double[] errorDfValues;
    double[] adjFactorAPValues;
    double[] adjFactorBPValues;
    double[] adjInteractionPValues;
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        Object object;
        int n2;
        Object object2;
        Object object3;
        int n3;
        Object object4;
        int n4;
        int n5;
        this.numFactorLevels = algorithmData.getIntArray("numFactorLevels");
        this.factorAAssignments = algorithmData.getIntArray("factorAAssignments");
        this.factorBAssignments = algorithmData.getIntArray("factorBAssignments");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.hierarchical_tree = algorithmParameters.getBoolean("hierarchical-tree", false);
        this.method_linkage = algorithmParameters.getInt("method-linkage", 0);
        this.calculate_genes = algorithmParameters.getBoolean("calculate-genes", false);
        this.calculate_experiments = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.allCellsHaveOneSample = algorithmParameters.getBoolean("allCellsHaveOneSample", false);
        this.isBalancedDesign = algorithmParameters.getBoolean("isBalancedDesign", false);
        this.usePerms = algorithmParameters.getBoolean("usePerms", true);
        this.adjustmentMethod = algorithmParameters.getInt("adjustmentMethod", 4);
        this.alpha = algorithmParameters.getFloat("alpha", 0.01f);
        this.numPerms = algorithmParameters.getInt("numPerms", 1000);
        this.origFactorAPValues = new double[this.numGenes];
        this.origFactorBPValues = new double[this.numGenes];
        this.origInteractionPValues = new double[this.numGenes];
        this.adjFactorAPValues = new double[this.numGenes];
        this.adjFactorBPValues = new double[this.numGenes];
        this.adjInteractionPValues = new double[this.numGenes];
        this.factorAFValues = new double[this.numGenes];
        this.factorBFValues = new double[this.numGenes];
        this.interactionFValues = new double[this.numGenes];
        this.factorADfValues = new double[this.numGenes];
        this.factorBDfValues = new double[this.numGenes];
        this.interactionDfValues = new double[this.numGenes];
        this.errorDfValues = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            this.origFactorAPValues[i] = 0.0;
            this.origFactorBPValues[i] = 0.0;
            this.origInteractionPValues[i] = 0.0;
        }
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        int n6 = 0;
        boolean[] blArray = new boolean[this.numGenes];
        for (n5 = 0; n5 < blArray.length; ++n5) {
            blArray[n5] = false;
        }
        for (n5 = 0; n5 < this.numGenes; ++n5) {
            boolean bl = false;
            for (n4 = 0; n4 < this.numExps; ++n4) {
                if (this.factorAAssignments[n4] == 0 || this.factorBAssignments[n4] == 0 || !Float.isNaN(this.expMatrix.A[n5][n4])) continue;
                bl = true;
                break;
            }
            if (bl) {
                blArray[n5] = true;
                continue;
            }
            ++n6;
        }
        for (n5 = 0; n5 < this.numGenes; ++n5) {
            Object object5;
            Object object6;
            Vector[][] vectorArray;
            if (this.stop) {
                throw new AbortException();
            }
            algorithmEvent.setIntValue(n5);
            algorithmEvent.setDescription("Calculating unadjusted p-values: Current gene = " + (n5 + 1));
            this.fireValueChanged(algorithmEvent);
            Vector[][] vectorArray2 = this.getCurrentGeneFactorValues(n5);
            n4 = this.getCurrGeneFactorCondition(vectorArray2);
            if (n4 == 21) {
                this.origFactorAPValues[n5] = Double.NaN;
                this.origFactorBPValues[n5] = Double.NaN;
                this.origInteractionPValues[n5] = Double.NaN;
                this.adjFactorAPValues[n5] = Double.NaN;
                this.adjFactorBPValues[n5] = Double.NaN;
                this.adjInteractionPValues[n5] = Double.NaN;
                this.factorAFValues[n5] = Double.NaN;
                this.factorBFValues[n5] = Double.NaN;
                this.interactionFValues[n5] = Double.NaN;
                this.factorADfValues[n5] = Double.NaN;
                this.factorBDfValues[n5] = Double.NaN;
                this.interactionDfValues[n5] = Double.NaN;
                this.errorDfValues[n5] = Double.NaN;
                continue;
            }
            if (n4 == 23) {
                this.origFactorAPValues[n5] = Double.NaN;
                this.origFactorBPValues[n5] = Double.NaN;
                this.origInteractionPValues[n5] = Double.NaN;
                this.adjFactorAPValues[n5] = Double.NaN;
                this.adjFactorBPValues[n5] = Double.NaN;
                this.adjInteractionPValues[n5] = Double.NaN;
                this.factorAFValues[n5] = Double.NaN;
                this.factorBFValues[n5] = Double.NaN;
                this.interactionFValues[n5] = Double.NaN;
                this.factorADfValues[n5] = Double.NaN;
                this.factorBDfValues[n5] = Double.NaN;
                this.interactionDfValues[n5] = Double.NaN;
                this.errorDfValues[n5] = Double.NaN;
                continue;
            }
            if (n4 == 24) {
                object4 = this.getBalancedFValuesAndDfs(vectorArray2);
                this.factorAFValues[n5] = (double)object4[0];
                this.factorBFValues[n5] = (double)object4[1];
                this.interactionFValues[n5] = (double)object4[2];
                this.factorADfValues[n5] = (double)object4[3];
                this.factorBDfValues[n5] = (double)object4[4];
                this.interactionDfValues[n5] = (double)object4[5];
                this.errorDfValues[n5] = (double)object4[6];
                if (!this.usePerms) {
                    this.origFactorAPValues[n5] = this.getPValueFromFDist(this.factorAFValues[n5], (int)this.factorADfValues[n5], (int)this.errorDfValues[n5]);
                    this.origFactorBPValues[n5] = this.getPValueFromFDist(this.factorBFValues[n5], (int)this.factorBDfValues[n5], (int)this.errorDfValues[n5]);
                    this.origInteractionPValues[n5] = this.getPValueFromFDist(this.interactionFValues[n5], (int)this.interactionDfValues[n5], (int)this.errorDfValues[n5]);
                    continue;
                }
                if (!blArray[n5]) continue;
                for (n3 = 0; n3 < this.numPerms; ++n3) {
                    vectorArray = this.getCurrentGenePermutedFactorValues(n5);
                    object3 = this.getBalancedFValuesAndDfs(vectorArray);
                    object6 = object3[0];
                    object5 = object3[1];
                    object2 = object3[2];
                    if (object6 >= this.factorAFValues[n5]) {
                        this.origFactorAPValues[n5] = this.origFactorAPValues[n5] + 1.0;
                    }
                    if (object5 >= this.factorBFValues[n5]) {
                        this.origFactorBPValues[n5] = this.origFactorBPValues[n5] + 1.0;
                    }
                    if (!(object2 >= this.interactionFValues[n5])) continue;
                    this.origInteractionPValues[n5] = this.origInteractionPValues[n5] + 1.0;
                }
                continue;
            }
            if (n4 == 25) {
                object4 = this.getUnbalancedFValuesAndDfs(vectorArray2);
                this.factorAFValues[n5] = (double)object4[0];
                this.factorBFValues[n5] = (double)object4[1];
                this.interactionFValues[n5] = (double)object4[2];
                this.factorADfValues[n5] = (double)object4[3];
                this.factorBDfValues[n5] = (double)object4[4];
                this.interactionDfValues[n5] = (double)object4[5];
                this.errorDfValues[n5] = (double)object4[6];
                if (!this.usePerms) {
                    this.origFactorAPValues[n5] = this.getPValueFromFDist(this.factorAFValues[n5], (int)this.factorADfValues[n5], (int)this.errorDfValues[n5]);
                    this.origFactorBPValues[n5] = this.getPValueFromFDist(this.factorBFValues[n5], (int)this.factorBDfValues[n5], (int)this.errorDfValues[n5]);
                    this.origInteractionPValues[n5] = this.getPValueFromFDist(this.interactionFValues[n5], (int)this.interactionDfValues[n5], (int)this.errorDfValues[n5]);
                    continue;
                }
                if (!blArray[n5]) continue;
                for (n3 = 0; n3 < this.numPerms; ++n3) {
                    vectorArray = this.getCurrentGenePermutedFactorValues(n5);
                    object3 = this.getUnbalancedFValuesAndDfs(vectorArray);
                    object6 = object3[0];
                    object5 = object3[1];
                    object2 = object3[2];
                    if (object6 >= this.factorAFValues[n5]) {
                        this.origFactorAPValues[n5] = this.origFactorAPValues[n5] + 1.0;
                    }
                    if (object5 >= this.factorBFValues[n5]) {
                        this.origFactorBPValues[n5] = this.origFactorBPValues[n5] + 1.0;
                    }
                    if (!(object2 >= this.interactionFValues[n5])) continue;
                    this.origInteractionPValues[n5] = this.origInteractionPValues[n5] + 1.0;
                }
                continue;
            }
            if (n4 != 22) continue;
            object4 = this.getBalancedMainEffectsFValuesAndDfs(vectorArray2);
            this.factorAFValues[n5] = (double)object4[0];
            this.factorBFValues[n5] = (double)object4[1];
            this.interactionFValues[n5] = Double.NaN;
            this.factorADfValues[n5] = (double)object4[2];
            this.factorBDfValues[n5] = (double)object4[3];
            this.interactionDfValues[n5] = Double.NaN;
            this.errorDfValues[n5] = (double)object4[4];
            this.origInteractionPValues[n5] = Double.NaN;
            if (!this.usePerms) {
                this.origFactorAPValues[n5] = this.getPValueFromFDist(this.factorAFValues[n5], (int)this.factorADfValues[n5], (int)this.errorDfValues[n5]);
                this.origFactorBPValues[n5] = this.getPValueFromFDist(this.factorBFValues[n5], (int)this.factorBDfValues[n5], (int)this.errorDfValues[n5]);
                continue;
            }
            if (!blArray[n5]) continue;
            for (n3 = 0; n3 < this.numPerms; ++n3) {
                vectorArray = this.getCurrentGenePermutedFactorValues(n5);
                object3 = this.getBalancedMainEffectsFValuesAndDfs(vectorArray);
                object6 = object3[0];
                object5 = object3[1];
                if (object6 >= this.factorAFValues[n5]) {
                    this.origFactorAPValues[n5] = this.origFactorAPValues[n5] + 1.0;
                }
                if (!(object5 >= this.factorBFValues[n5])) continue;
                this.origFactorBPValues[n5] = this.origFactorBPValues[n5] + 1.0;
            }
        }
        if (this.usePerms && n6 > 0) {
            int n7;
            n5 = -1;
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                n5 = i;
                break;
            }
            Vector[][] vectorArray = this.getCurrentGeneFactorValues(n5);
            n4 = this.getCurrGeneFactorCondition(vectorArray);
            object4 = new Vector();
            for (n3 = 0; n3 < this.numExps; ++n3) {
                if (this.factorAAssignments[n3] == 0 || this.factorBAssignments[n3] == 0) continue;
                ((Vector)object4).add(new Integer(n3));
            }
            int[] nArray = new int[((Vector)object4).size()];
            for (n7 = 0; n7 < nArray.length; ++n7) {
                nArray[n7] = (Integer)((Vector)object4).get(n7);
            }
            algorithmEvent = new AlgorithmEvent(this, 1, this.numPerms);
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setId(2);
            for (n7 = 0; n7 < this.numPerms; ++n7) {
                double d;
                double d2;
                Vector[][] vectorArray3;
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(n7);
                algorithmEvent.setDescription("Calculating unadjusted p-values for some genes: Current permutation = " + (n7 + 1));
                this.fireValueChanged(algorithmEvent);
                object3 = this.getPermutedValues(this.numExps, nArray);
                FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, (int[])object3);
                if (n4 == 24) {
                    for (n2 = 0; n2 < this.numGenes; ++n2) {
                        if (blArray[n2]) continue;
                        vectorArray3 = this.getCurrentGeneFactorValuesFromPermMatrix(floatMatrix, n2);
                        object = this.getBalancedFValuesAndDfs(vectorArray3);
                        object2 = object[0];
                        d2 = object[1];
                        d = object[2];
                        if (object2 >= this.factorAFValues[n2]) {
                            this.origFactorAPValues[n2] = this.origFactorAPValues[n2] + 1.0;
                        }
                        if (d2 >= this.factorBFValues[n2]) {
                            this.origFactorBPValues[n2] = this.origFactorBPValues[n2] + 1.0;
                        }
                        if (!(d >= this.interactionFValues[n2])) continue;
                        this.origInteractionPValues[n2] = this.origInteractionPValues[n2] + 1.0;
                    }
                    continue;
                }
                if (n4 == 25) {
                    for (n2 = 0; n2 < this.numGenes; ++n2) {
                        if (blArray[n2]) continue;
                        vectorArray3 = this.getCurrentGeneFactorValuesFromPermMatrix(floatMatrix, n2);
                        object = this.getUnbalancedFValuesAndDfs(vectorArray3);
                        object2 = object[0];
                        d2 = object[1];
                        d = object[2];
                        if (object2 >= this.factorAFValues[n2]) {
                            this.origFactorAPValues[n2] = this.origFactorAPValues[n2] + 1.0;
                        }
                        if (d2 >= this.factorBFValues[n2]) {
                            this.origFactorBPValues[n2] = this.origFactorBPValues[n2] + 1.0;
                        }
                        if (!(d >= this.interactionFValues[n2])) continue;
                        this.origInteractionPValues[n2] = this.origInteractionPValues[n2] + 1.0;
                    }
                    continue;
                }
                if (n4 != 22) continue;
                for (n2 = 0; n2 < this.numGenes; ++n2) {
                    if (blArray[n2]) continue;
                    vectorArray3 = this.getCurrentGeneFactorValuesFromPermMatrix(floatMatrix, n2);
                    object = this.getBalancedMainEffectsFValuesAndDfs(vectorArray3);
                    object2 = object[0];
                    d2 = object[1];
                    if (object2 >= this.factorAFValues[n2]) {
                        this.origFactorAPValues[n2] = this.origFactorAPValues[n2] + 1.0;
                    }
                    if (!(d2 >= this.factorBFValues[n2])) continue;
                    this.origFactorBPValues[n2] = this.origFactorBPValues[n2] + 1.0;
                }
            }
        }
        if (this.usePerms) {
            for (n5 = 0; n5 < this.numGenes; ++n5) {
                this.origFactorAPValues[n5] = this.origFactorAPValues[n5] / (double)this.numPerms;
                this.origFactorBPValues[n5] = this.origFactorBPValues[n5] / (double)this.numPerms;
                this.origInteractionPValues[n5] = this.origInteractionPValues[n5] / (double)this.numPerms;
            }
        }
        for (n5 = 0; n5 < this.numGenes; ++n5) {
            if (Double.isNaN(this.factorAFValues[n5])) {
                this.origFactorAPValues[n5] = Double.NaN;
            }
            if (Double.isNaN(this.factorBFValues[n5])) {
                this.origFactorBPValues[n5] = Double.NaN;
            }
            if (!Double.isNaN(this.interactionFValues[n5])) continue;
            this.origInteractionPValues[n5] = Double.NaN;
        }
        if (this.adjustmentMethod == 4) {
            for (n5 = 0; n5 < this.numGenes; ++n5) {
                this.adjFactorAPValues[n5] = this.origFactorAPValues[n5];
                this.adjFactorBPValues[n5] = this.origFactorBPValues[n5];
                this.adjInteractionPValues[n5] = this.origInteractionPValues[n5];
            }
        }
        Vector<Object> vector = new Vector<Object>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector vector3 = new Vector();
        object4 = new Vector();
        Vector vector4 = new Vector();
        Vector<Integer> vector5 = new Vector<Integer>();
        object3 = new Vector();
        Vector vector6 = new Vector();
        for (n2 = 0; n2 < this.numGenes; ++n2) {
            if ((float)this.adjFactorAPValues[n2] <= this.alpha) {
                vector2.add(new Integer(n2));
            }
            if ((float)this.adjFactorBPValues[n2] <= this.alpha) {
                ((Vector)object4).add(new Integer(n2));
            }
            if (!((float)this.adjInteractionPValues[n2] <= this.alpha)) continue;
            vector5.add(new Integer(n2));
        }
        Vector<Integer> vector7 = new Vector<Integer>();
        for (int i = 0; i < this.numGenes; ++i) {
            vector7.add(new Integer(i));
        }
        vector3 = (Vector)vector7.clone();
        vector3.removeAll(vector2);
        vector4 = (Vector)vector7.clone();
        vector4.removeAll((Collection<?>)object4);
        object3 = (Vector)vector7.clone();
        ((Vector)object3).removeAll(vector5);
        vector6 = (Vector)vector7.clone();
        vector6.removeAll(vector2);
        vector6.removeAll((Collection<?>)object4);
        vector6.removeAll(vector5);
        vector.add(vector2);
        vector.add(object4);
        vector.add(vector5);
        vector.add(vector3);
        vector.add(vector4);
        vector.add(object3);
        vector.add(vector6);
        this.k = vector.size();
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, 1);
        object = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix7 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix8 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix9 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix10 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix11 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix12 = new FloatMatrix(this.numGenes, 1);
        for (n = 0; n < this.numGenes; ++n) {
            floatMatrix.A[n][0] = (float)this.factorAFValues[n];
            object.A[n][0] = (float)this.factorBFValues[n];
            floatMatrix2.A[n][0] = (float)this.interactionFValues[n];
            floatMatrix3.A[n][0] = (float)this.factorADfValues[n];
            floatMatrix4.A[n][0] = (float)this.factorBDfValues[n];
            floatMatrix5.A[n][0] = (float)this.interactionDfValues[n];
            floatMatrix6.A[n][0] = (float)this.errorDfValues[n];
            floatMatrix7.A[n][0] = (float)this.origFactorAPValues[n];
            floatMatrix8.A[n][0] = (float)this.origFactorBPValues[n];
            floatMatrix9.A[n][0] = (float)this.origInteractionPValues[n];
            floatMatrix10.A[n][0] = (float)this.adjFactorAPValues[n];
            floatMatrix11.A[n][0] = (float)this.adjFactorBPValues[n];
            floatMatrix12.A[n][0] = (float)this.adjInteractionPValues[n];
        }
        this.clusters = new Vector[this.k];
        for (n = 0; n < this.k; ++n) {
            this.clusters[n] = (Vector)vector.get(n);
        }
        FloatMatrix floatMatrix13 = this.getMeans(this.clusters);
        FloatMatrix floatMatrix14 = this.getVariances(this.clusters, floatMatrix13);
        algorithmEvent = null;
        if (this.hierarchical_tree) {
            algorithmEvent = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!this.hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, this.method_linkage, this.calculate_genes, this.calculate_experiments));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix13);
        algorithmData2.addMatrix("clusters_variances", floatMatrix14);
        algorithmData2.addMatrix("factorAFValuesMatrix", floatMatrix);
        algorithmData2.addMatrix("factorBFValuesMatrix", (FloatMatrix)object);
        algorithmData2.addMatrix("interactionFValuesMatrix", floatMatrix2);
        algorithmData2.addMatrix("factorADfValuesMatrix", floatMatrix3);
        algorithmData2.addMatrix("factorBDfValuesMatrix", floatMatrix4);
        algorithmData2.addMatrix("interactionDfValuesMatrix", floatMatrix5);
        algorithmData2.addMatrix("errorDfValuesMatrix", floatMatrix6);
        algorithmData2.addMatrix("origFactorAPValuesMatrix", floatMatrix7);
        algorithmData2.addMatrix("origFactorBPValuesMatrix", floatMatrix8);
        algorithmData2.addMatrix("origInteractionPValuesMatrix", floatMatrix9);
        algorithmData2.addMatrix("adjFactorAPValuesMatrix", floatMatrix10);
        algorithmData2.addMatrix("adjFactorBPValuesMatrix", floatMatrix11);
        algorithmData2.addMatrix("adjInteractionPValuesMatrix", floatMatrix12);
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.getSubExperiment(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numExps);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numExps);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get((Integer)vector.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get((Integer)vector.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private double getPValueFromFDist(double d, int n, int n2) {
        FDistribution fDistribution = new FDistribution((double)n, (double)n2);
        double d2 = fDistribution.cumulative(d);
        double d3 = 1.0 - d2;
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        return d3;
    }

    private double[] getUnbalancedFValuesAndDfs(Vector[][] vectorArray) {
        int n;
        int n2;
        double[][] dArray = this.getCellSums(vectorArray);
        double[][] dArray2 = new double[vectorArray.length][vectorArray[0].length];
        for (int i = 0; i < vectorArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].length; ++j) {
                dArray2[i][j] = dArray[i][j] / (double)vectorArray[i][j].size();
            }
        }
        double d = 0.0;
        int n3 = 0;
        for (int i = 0; i < vectorArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].length; ++j) {
                d += 1.0 / (double)vectorArray[i][j].size();
                n3 += vectorArray[i][j].size() - 1;
            }
        }
        double d2 = (double)(this.numFactorLevels[0] * this.numFactorLevels[1]) / d;
        double[][] dArray3 = new double[vectorArray.length][vectorArray[0].length];
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (n = 0; n < vectorArray[n2].length; ++n) {
                dArray3[n2][n] = dArray2[n2][n] * d2;
            }
        }
        n2 = this.numFactorLevels[0] - 1;
        n = this.numFactorLevels[1] - 1;
        int n4 = n2 * n;
        double d3 = this.getTUnbalanced(dArray3, d2);
        double d4 = this.getAUnbalanced(dArray3, d2);
        double d5 = this.getBUnbalanced(dArray3, d2);
        double d6 = this.getABUnbalanced(dArray3, d2);
        double d7 = (d4 - d3) / (double)n2;
        double d8 = (d5 - d3) / (double)n;
        double d9 = (d6 - d4 - d5 + d3) / (double)n4;
        double d10 = 0.0;
        for (int i = 0; i < vectorArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].length; ++j) {
                Vector vector = vectorArray[i][j];
                d10 += this.getSumSquaredDiffs(vector);
            }
        }
        double d11 = d10 / (double)n3;
        double d12 = d7 / d11;
        double d13 = d8 / d11;
        double d14 = d9 / d11;
        double[] dArray4 = new double[]{d12, d13, d14, n2, n, n4, n3};
        return dArray4;
    }

    private double[] getBalancedFValuesAndDfs(Vector[][] vectorArray) {
        double[][] dArray = this.getCellSums(vectorArray);
        int n = vectorArray[0][0].size();
        int n2 = this.numFactorLevels[0] - 1;
        int n3 = this.numFactorLevels[1] - 1;
        int n4 = n2 * n3;
        int n5 = this.numFactorLevels[0] * this.numFactorLevels[1] * (n - 1);
        double d = this.getYBalanced(vectorArray);
        double d2 = this.getABBalanced(vectorArray, dArray);
        double d3 = this.getTBalanced(vectorArray, dArray);
        double d4 = this.getABalanced(vectorArray, dArray);
        double d5 = this.getBBalanced(vectorArray, dArray);
        double d6 = (d4 - d3) / (double)n2;
        double d7 = (d5 - d3) / (double)n3;
        double d8 = (d2 - d4 - d5 + d3) / (double)n4;
        double d9 = (d - d2) / (double)n5;
        double d10 = d6 / d9;
        double d11 = d7 / d9;
        double d12 = d8 / d9;
        double[] dArray2 = new double[]{d10, d11, d12, n2, n3, n4, n5};
        return dArray2;
    }

    private double[] getBalancedMainEffectsFValuesAndDfs(Vector[][] vectorArray) {
        double[][] dArray = this.getCellSums(vectorArray);
        int n = this.numFactorLevels[0] - 1;
        int n2 = this.numFactorLevels[1] - 1;
        int n3 = n * n2;
        double d = this.getYBalanced(vectorArray);
        double d2 = this.getABBalanced(vectorArray, dArray);
        double d3 = this.getTBalanced(vectorArray, dArray);
        double d4 = this.getABalanced(vectorArray, dArray);
        double d5 = this.getBBalanced(vectorArray, dArray);
        double d6 = (d4 - d3) / (double)n;
        double d7 = (d5 - d3) / (double)n2;
        double d8 = (d2 - d4 - d5 + d3) / (double)n3;
        double d9 = d6 / d8;
        double d10 = d7 / d8;
        double[] dArray2 = new double[]{d9, d10, n, n2, n3};
        return dArray2;
    }

    private double getYBalanced(Vector[][] vectorArray) {
        double d = 0.0;
        for (int i = 0; i < vectorArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].length; ++j) {
                for (int k = 0; k < vectorArray[i][j].size(); ++k) {
                    double d2 = ((Float)vectorArray[i][j].get(k)).doubleValue();
                    d += d2 * d2;
                }
            }
        }
        return d;
    }

    private double getABUnbalanced(double[][] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d2 += dArray[i][j] * dArray[i][j];
            }
        }
        double d3 = d2 / d;
        return d3;
    }

    private double getABBalanced(Vector[][] vectorArray, double[][] dArray) {
        int n;
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray[n].length; ++i) {
                d += dArray[n][i] * dArray[n][i];
            }
        }
        n = vectorArray[0][0].size();
        double d2 = d / (double)n;
        return d2;
    }

    private double getAUnbalanced(double[][] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < dArray[i].length; ++j) {
                d3 += dArray[i][j];
            }
            d2 += d3 * d3;
        }
        double d4 = d2 / ((double)this.numFactorLevels[1] * d);
        return d4;
    }

    private double getABalanced(Vector[][] vectorArray, double[][] dArray) {
        double d;
        int n;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d = 0.0;
            for (int i = 0; i < dArray[n].length; ++i) {
                d += dArray[n][i];
            }
            d2 += d * d;
        }
        n = vectorArray[0][0].size();
        d = d2 / (double)(this.numFactorLevels[1] * n);
        return d;
    }

    private double getBUnbalanced(double[][] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray[0].length; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d3 += dArray[j][i];
            }
            d2 += d3 * d3;
        }
        double d4 = d2 / ((double)this.numFactorLevels[0] * d);
        return d4;
    }

    private double getBBalanced(Vector[][] vectorArray, double[][] dArray) {
        double d;
        int n;
        double d2 = 0.0;
        for (n = 0; n < dArray[0].length; ++n) {
            d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i][n];
            }
            d2 += d * d;
        }
        n = vectorArray[0][0].size();
        d = d2 / (double)(this.numFactorLevels[0] * n);
        return d;
    }

    private double getTBalanced(Vector[][] vectorArray, double[][] dArray) {
        int n;
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray[n].length; ++i) {
                d += dArray[n][i];
            }
        }
        n = vectorArray[0][0].size();
        double d2 = d * d / (double)(this.numFactorLevels[0] * this.numFactorLevels[1] * n);
        return d2;
    }

    private double getTUnbalanced(double[][] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d2 += dArray[i][j];
            }
        }
        double d3 = d2 * d2 / ((double)(this.numFactorLevels[0] * this.numFactorLevels[1]) * d);
        return d3;
    }

    private double[][] getCellSums(Vector[][] vectorArray) {
        double[][] dArray = new double[vectorArray.length][vectorArray[0].length];
        for (int i = 0; i < vectorArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].length; ++j) {
                dArray[i][j] = this.getSum(vectorArray[i][j]);
            }
        }
        return dArray;
    }

    private double[][] getCellMeans(Vector[][] vectorArray) {
        int n;
        int n2;
        double[][] dArray = new double[vectorArray.length][vectorArray[0].length];
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (n = 0; n < vectorArray[n2].length; ++n) {
                dArray[n2][n] = this.getSum(vectorArray[n2][n]);
            }
        }
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (n = 0; n < vectorArray[n2].length; ++n) {
                dArray[n2][n] = dArray[n2][n] / (double)vectorArray[n2][n].size();
            }
        }
        return dArray;
    }

    private double getSum(Vector vector) {
        double d = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            d += ((Float)vector.get(i)).doubleValue();
        }
        return d;
    }

    private double getSumSquares(Vector vector) {
        double d = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            d += ((Float)vector.get(i)).doubleValue() * ((Float)vector.get(i)).doubleValue();
        }
        return d;
    }

    private double getSumSquaredDiffs(Vector vector) {
        return this.getSumSquares(vector) - this.getSum(vector) * this.getSum(vector) / (double)vector.size();
    }

    private int[] getPermutedValues(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[n];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i;
        }
        int[] nArray3 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        for (n2 = nArray3.length; n2 > 1; --n2) {
            Random random = new Random();
            int n3 = random.nextInt(n2 - 1);
            int n4 = nArray3[n3];
            nArray3[n3] = nArray3[n2 - 1];
            nArray3[n2 - 1] = n4;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[nArray[n2]] = nArray3[n2];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray2;
    }

    private FloatMatrix getPermutedMatrix(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][nArray[j]];
            }
        }
        return floatMatrix2;
    }

    private Vector[][] getCurrentGenePermutedFactorValues(int n) {
        int n2;
        Vector[][] vectorArray = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.factorAAssignments[i] == 0 || this.factorBAssignments[i] == 0 || Float.isNaN(this.expMatrix.A[n][i])) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        int[] nArray2 = this.getPermutedValues(this.numExps, nArray);
        int[] nArray3 = this.getPermutedValues(this.numExps, nArray);
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray3.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray4[n2] = this.factorAAssignments[nArray2[n2]];
            nArray5[n2] = this.factorBAssignments[nArray3[n2]];
        }
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (int i = 0; i < vectorArray[n2].length; ++i) {
                vectorArray[n2][i] = new Vector();
            }
        }
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            if (nArray4[n2] == 0 || nArray5[n2] == 0 || Float.isNaN(this.expMatrix.A[n][n2])) continue;
            vectorArray[nArray4[n2] - 1][nArray5[n2] - 1].add(new Float(this.expMatrix.A[n][n2]));
        }
        return vectorArray;
    }

    private Vector[][] getCurrentGeneFactorValues(int n) {
        int n2;
        Vector[][] vectorArray = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (int i = 0; i < vectorArray[n2].length; ++i) {
                vectorArray[n2][i] = new Vector();
            }
        }
        for (n2 = 0; n2 < this.factorAAssignments.length; ++n2) {
            if (this.factorAAssignments[n2] == 0 || this.factorBAssignments[n2] == 0 || Float.isNaN(this.expMatrix.A[n][n2])) continue;
            vectorArray[this.factorAAssignments[n2] - 1][this.factorBAssignments[n2] - 1].add(new Float(this.expMatrix.A[n][n2]));
        }
        return vectorArray;
    }

    private Vector[][] getCurrentGeneFactorValuesFromPermMatrix(FloatMatrix floatMatrix, int n) {
        int n2;
        Vector[][] vectorArray = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (int i = 0; i < vectorArray[n2].length; ++i) {
                vectorArray[n2][i] = new Vector();
            }
        }
        for (n2 = 0; n2 < this.factorAAssignments.length; ++n2) {
            if (this.factorAAssignments[n2] == 0 || this.factorBAssignments[n2] == 0 || Float.isNaN(floatMatrix.A[n][n2])) continue;
            vectorArray[this.factorAAssignments[n2] - 1][this.factorBAssignments[n2] - 1].add(new Float(floatMatrix.A[n][n2]));
        }
        return vectorArray;
    }

    private int getCurrGeneFactorCondition(Vector[][] vectorArray) {
        int n;
        int n2;
        int[] nArray = new int[vectorArray.length * vectorArray[0].length];
        int n3 = 0;
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (n = 0; n < vectorArray[n2].length; ++n) {
                nArray[n3] = vectorArray[n2][n].size();
                ++n3;
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] != 0) continue;
            return 21;
        }
        if (nArray[0] == 1) {
            n2 = 1;
            for (n = 1; n < nArray.length; ++n) {
                if (nArray[n] == 1) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0) {
                return 22;
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] != 1) continue;
            return 23;
        }
        n2 = nArray[0];
        n = 1;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == n2) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            return 24;
        }
        return 25;
    }
}

