/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TByteHashSet;
import gnu.trove.TByteIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TByteHashSetDecorator
extends AbstractSet
implements Set,
Cloneable {
    protected TByteHashSet _set;

    public TByteHashSetDecorator(TByteHashSet set) {
        this._set = set;
    }

    public Object clone() {
        try {
            TByteHashSetDecorator copy = (TByteHashSetDecorator)super.clone();
            copy._set = (TByteHashSet)this._set.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean add(Object value) {
        return this._set.add(this.unwrap(value));
    }

    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Byte) {
                    byte v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TByteIterator it;
            {
                this.it = TByteHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TByteHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Byte wrap(byte k) {
        return new Byte(k);
    }

    protected byte unwrap(Object value) {
        return (Byte)value;
    }
}

