/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.mail;

import java.io.Closeable;
import java.io.IOException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import org.ujmp.core.Matrix;
import org.ujmp.core.listmatrix.AbstractListMatrix;
import org.ujmp.mail.ImapUtil;
import org.ujmp.mail.MessageMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesMatrix
extends AbstractListMatrix<Matrix>
implements Closeable {
    private static final long serialVersionUID = -8489199262755536077L;
    private final Folder folder;

    public MessagesMatrix(Folder folder) throws Exception {
        this.folder = folder;
    }

    public MessagesMatrix(String url, String user, String password, String folderName) throws Exception {
        ImapUtil util = new ImapUtil(url, user, password);
        this.folder = util.getFolder(folderName);
    }

    @Override
    public Matrix get(int index) {
        try {
            if (!this.folder.isOpen()) {
                this.folder.open(1);
            }
            return new MessageMatrix(this.folder.getMessage(index + 1));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        try {
            return this.folder.getMessageCount();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.folder.close(false);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addToList(Matrix t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToList(int index, Matrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix removeFromList(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFromList(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix setToList(int index, Matrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearList() {
        throw new UnsupportedOperationException();
    }
}

