/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.ujmp.core.Coordinates;
import org.ujmp.core.util.MathUtil;

public abstract class GUIUtil {
    public static Object getObject(String message, Object ... objects) {
        return objects[JOptionPane.showOptionDialog(null, message, message, 0, 3, null, objects, null)];
    }

    public static double getDouble(String message, double min, double max, Double initialValue) {
        double i = Double.NaN;
        while (MathUtil.isNaNOrInfinite(i)) {
            String s = JOptionPane.showInputDialog(message + " (" + min + " to " + max + ")", (Object)initialValue);
            try {
                i = Double.parseDouble(s);
            }
            catch (Exception e) {}
        }
        return i;
    }

    public static int getInt(String message, int min, int max) {
        return GUIUtil.getInt(message, min, max, null);
    }

    public static int getInt(String message, int min, int max, Integer initialValue) {
        Integer i = null;
        while (i == null) {
            String s = JOptionPane.showInputDialog(message + " (" + min + " to " + max + ")", (Object)initialValue);
            try {
                i = Integer.parseInt(s);
            }
            catch (Exception e) {}
        }
        return i;
    }

    public static double getDouble(String message, double min, double max) {
        return GUIUtil.getDouble(message, min, max, null);
    }

    public static String getString(String message) {
        return JOptionPane.showInputDialog(message);
    }

    public static String getPassword(String message) {
        JPasswordField passwordField = new JPasswordField();
        JOptionPane.showConfirmDialog(null, passwordField, message, 2, -1);
        return new String(passwordField.getPassword());
    }

    public static boolean getBoolean(String message) {
        int i = JOptionPane.showConfirmDialog(null, message, message, 0);
        return 0 == i;
    }

    public static long[] getSize(String message) {
        long[] size = null;
        while (size == null) {
            String s = GUIUtil.getString(message);
            try {
                size = Coordinates.parseString(s);
            }
            catch (Exception exception) {}
        }
        return size;
    }
}

