/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreeModel;
import org.ujmp.core.Matrix;
import org.ujmp.core.graphmatrix.GraphMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.treematrix.TreeMatrix;
import org.ujmp.core.util.GnuPlot;
import org.ujmp.core.util.Matlab;
import org.ujmp.core.util.Octave;
import org.ujmp.core.util.R;
import org.ujmp.gui.DefaultMatrixGUIObject;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.graph.GraphPanel;
import org.ujmp.gui.panels.AbstractPanel;
import org.ujmp.gui.panels.BufferedPanel;
import org.ujmp.gui.panels.GnuPlotPanel;
import org.ujmp.gui.panels.MatlabPanel;
import org.ujmp.gui.panels.MatrixEditorPanel;
import org.ujmp.gui.panels.MatrixHeatmapPanel;
import org.ujmp.gui.panels.MatrixTreePanel;
import org.ujmp.gui.panels.MatrixTreemapPanel;
import org.ujmp.gui.panels.OctavePanel;
import org.ujmp.gui.panels.RPanel;
import org.ujmp.gui.plot.MatrixPlot;

public class MatrixPanel
extends AbstractPanel {
    private static final long serialVersionUID = 3912987239953510584L;

    public MatrixPanel(MatrixGUIObject m) {
        super(m);
        JPanel panel;
        Constructor<?> con;
        Class<?> c;
        if (!(m instanceof DefaultMatrixGUIObject)) {
            m = new DefaultMatrixGUIObject(m.getMatrix());
        }
        JSplitPane splitPane1 = new JSplitPane();
        JSplitPane splitPane2 = new JSplitPane(0);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setMinimumSize(new Dimension(10, 10));
        MapMatrix<String, Object> metaData = m.getMatrix().getMetaData();
        if (metaData != null) {
            splitPane2.setTopComponent(new MatrixEditorPanel("Meta Data", (MatrixGUIObject)m.getMatrix().getMetaData().getGUIObject()));
        }
        tabbedPane.add("Heatmap", new MatrixHeatmapPanel(m, false));
        tabbedPane.add("Plot", new BufferedPanel(new MatrixPlot(m, true)));
        if (m.getMatrix() instanceof GraphMatrix && m.getColumnCount() < 1000) {
            tabbedPane.add("Graph", new GraphPanel(m));
            tabbedPane.setSelectedIndex(tabbedPane.getComponentCount() - 1);
        }
        if (m.getMatrix() instanceof GraphMatrix && ((GraphMatrix)m.getMatrix()).getNodeCount() < 1000) {
            try {
                Class<?> graphPanelClass = Class.forName("org.ujmp.jung.JungVisualizationViewer");
                Constructor<?> graphPanelConstructor = graphPanelClass.getConstructor(GraphMatrix.class);
                JPanel graphPanel = (JPanel)graphPanelConstructor.newInstance(m.getMatrix());
                tabbedPane.add("JUNG Graph", graphPanel);
                tabbedPane.setSelectedIndex(tabbedPane.getComponentCount() - 1);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getMatrix() instanceof TreeModel) {
            tabbedPane.add("Tree", new MatrixTreePanel(m));
        }
        if (m.getMatrix() instanceof TreeMatrix) {
            tabbedPane.add("Treemap", new MatrixTreemapPanel((TreeMatrix)m.getMatrix()));
        }
        if (m.getRowCount() > 1) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotLinePanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Line Plot", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getRowCount() > 1 && m.getColumnCount() > 1) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotXYPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("XY Plot", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getRowCount() > 1 && m.getColumnCount() > 1) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotScatterPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Scatter Plot", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getRowCount() > 1 && m.getColumnCount() > 1) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotBarPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Bar Plot", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getRowCount() > 1 && m.getColumnCount() > 1) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotHistogramPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Histogram", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getRowCount() > 1 && m.getColumnCount() > 1) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotStaircasePanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Staircase Plot", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getRowCount() > 1 && m.getColumnCount() > 1) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotGridPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Grid Plot", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (m.getColumnCount() >= 3) {
            try {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotBar3DPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Bar Plot 3D", panel);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            if (m.getColumnCount() >= 3) {
                c = Class.forName("org.ujmp.jmathplot.JMathPlotScatter3DPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Scatter Plot 3D", panel);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (m.getColumnCount() >= 3) {
                Class.forName("org.math.plot.PlotPanel");
                c = Class.forName("org.ujmp.jmathplot.JMathPlotLine3DPanel");
                con = c.getConstructor(Matrix.class);
                panel = (JPanel)con.newInstance(m.getMatrix());
                tabbedPane.add("Line Plot 3D", panel);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (GnuPlot.isAvailable()) {
            GnuPlotPanel gnuPlotPanel = new GnuPlotPanel(m);
            tabbedPane.add("GnuPlot", gnuPlotPanel);
        }
        if (Matlab.isAvailable()) {
            MatlabPanel matlabPanel = new MatlabPanel(m);
            tabbedPane.add("Matlab", matlabPanel);
        }
        if (Octave.isAvailable()) {
            OctavePanel octavePanel = new OctavePanel(m);
            tabbedPane.add("Octave", octavePanel);
        }
        if (R.isAvailable()) {
            RPanel rPanel = new RPanel(m);
            tabbedPane.add("R", rPanel);
        }
        splitPane2.setBottomComponent(tabbedPane);
        splitPane1.setLeftComponent(splitPane2);
        splitPane1.setRightComponent(new MatrixEditorPanel(m));
        this.add((Component)splitPane1, "Center");
        splitPane1.setDividerLocation(600);
        splitPane2.setDividerLocation(200);
    }
}

