/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.exporter;

import java.io.IOException;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.export.exporter.AbstractMatrixWriterExporter;
import org.ujmp.core.export.format.MatrixLatexExportFormat;
import org.ujmp.core.util.UJMPFormat;

public class DefaultMatrixWriterLatexExporter
extends AbstractMatrixWriterExporter
implements MatrixLatexExportFormat {
    public DefaultMatrixWriterLatexExporter(Matrix matrix, Writer writer) {
        super(matrix, writer);
    }

    public void asLatex() throws IOException {
        String EOL = System.getProperty("line.separator");
        Writer writer = this.getWriter();
        Matrix matrix = this.getMatrix();
        long rowCount = matrix.getRowCount();
        long colCount = matrix.getColumnCount();
        writer.write("\\begin{table}[!ht]" + EOL);
        writer.write("\\centering" + EOL);
        if (matrix.getLabelObject() != null) {
            writer.write("\\caption{" + UJMPFormat.getSingleLineInstance().format(matrix.getLabelObject()) + "}" + EOL);
        }
        StringBuilder buf = new StringBuilder();
        for (long i = matrix.getColumnCount() - 1L; i != -1L; --i) {
            buf.append('c');
        }
        String alignment = buf.toString();
        writer.write("\\begin{tabular}{" + alignment + "}" + EOL);
        writer.write("\\toprule" + EOL);
        int row = 0;
        while ((long)row < rowCount) {
            int col = 0;
            while ((long)col < colCount) {
                writer.write(UJMPFormat.getSingleLineInstance().format(matrix.getAsObject(row, col)));
                if ((long)col < colCount - 1L) {
                    writer.write(" & ");
                }
                ++col;
            }
            writer.write(" \\\\" + EOL);
            ++row;
        }
        writer.write("\\bottomrule" + EOL);
        writer.write("\\end{tabular}" + EOL);
        writer.write("\\end{table}" + EOL);
    }
}

