/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface QR<T> {
    public static final int THRESHOLD = 100;
    public static final QR<Matrix> MATRIX = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.solve(source, b);
                }
                return MATRIXSMALLSINGLETHREADED.solve(source, b);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.solve(source, b);
            }
            return MATRIXSMALLMULTITHREADED.solve(source, b);
        }
    };
    public static final QR<Matrix> MATRIXLARGESINGLETHREADED = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            QR<Matrix> qr = null;
            if (UJMPSettings.getInstance().isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.getInstance().isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.getInstance().isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            QR<Matrix> qr = null;
            if (UJMPSettings.getInstance().isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.getInstance().isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.getInstance().isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.solve(source, b);
        }
    };
    public static final QR<Matrix> MATRIXLARGEMULTITHREADED = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            QR<Matrix> qr = null;
            if (UJMPSettings.getInstance().isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.getInstance().isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.getInstance().isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            QR<Matrix> qr = null;
            if (UJMPSettings.getInstance().isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.getInstance().isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.getInstance().isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.solve(source, b);
        }
    };
    public static final QR<Matrix> INSTANCE = MATRIX;
    public static final QR<Matrix> UJMP = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            if (source.getRowCount() >= source.getColumnCount()) {
                QRMatrix qr = new QRMatrix(source);
                return new Matrix[]{qr.getQ(), qr.getR()};
            }
            throw new RuntimeException("only matrices m>=n are allowed");
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            if (source.getRowCount() >= source.getColumnCount()) {
                QRMatrix qr = new QRMatrix(source);
                return qr.solve(b);
            }
            throw new RuntimeException("only matrices m>=n are allowed");
        }
    };
    public static final QR<Matrix> MATRIXSMALLMULTITHREADED = UJMP;
    public static final QR<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;

    public T[] calc(T var1);

    public T solve(T var1, T var2);

    public static class QRMatrix {
        public static final long serialVersionUID = 2137461328307048867L;
        private final double[][] QR;
        private final int m;
        private final int n;
        private final double[] Rdiag;

        public QRMatrix(Matrix A) {
            this.QR = A.toDoubleArray();
            this.m = (int)A.getRowCount();
            this.n = (int)A.getColumnCount();
            this.Rdiag = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                int i;
                double nrm = 0.0;
                for (i = k; i < this.m; ++i) {
                    nrm = MathUtil.hypot(nrm, this.QR[i][k]);
                }
                if (nrm != 0.0) {
                    if (this.QR[k][k] < 0.0) {
                        nrm = -nrm;
                    }
                    for (i = k; i < this.m; ++i) {
                        double[] dArray = this.QR[i];
                        int n = k;
                        dArray[n] = dArray[n] / nrm;
                    }
                    double[] dArray = this.QR[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                    for (int j = k + 1; j < this.n; ++j) {
                        int i2;
                        double s = 0.0;
                        for (i2 = k; i2 < this.m; ++i2) {
                            s += this.QR[i2][k] * this.QR[i2][j];
                        }
                        s = -s / this.QR[k][k];
                        for (i2 = k; i2 < this.m; ++i2) {
                            double[] dArray2 = this.QR[i2];
                            int n2 = j;
                            dArray2[n2] = dArray2[n2] + s * this.QR[i2][k];
                        }
                    }
                }
                this.Rdiag[k] = -nrm;
            }
        }

        public final boolean isFullRank() {
            for (int j = 0; j < this.n; ++j) {
                if (this.Rdiag[j] != 0.0) continue;
                return false;
            }
            return true;
        }

        public final DenseDoubleMatrix2D getH() {
            double[][] H = new double[this.m][this.n];
            for (int i = 0; i < this.m; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    if (i < j) continue;
                    H[i][j] = this.QR[i][j];
                }
            }
            return Matrix.Factory.linkToArray(H);
        }

        public final DenseDoubleMatrix2D getR() {
            double[][] R2 = new double[this.n][this.n];
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    R2[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0);
                }
            }
            return Matrix.Factory.linkToArray(R2);
        }

        public final DenseDoubleMatrix2D getQ() {
            double[][] Q = new double[this.m][this.n];
            for (int k = this.n - 1; k >= 0; --k) {
                for (int i = 0; i < this.m; ++i) {
                    Q[i][k] = 0.0;
                }
                Q[k][k] = 1.0;
                for (int j = k; j < this.n; ++j) {
                    int i;
                    if (this.QR[k][k] == 0.0) continue;
                    double s = 0.0;
                    for (i = k; i < this.m; ++i) {
                        s += this.QR[i][k] * Q[i][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i = k; i < this.m; ++i) {
                        double[] dArray = Q[i];
                        int n = j;
                        dArray[n] = dArray[n] + s * this.QR[i][k];
                    }
                }
            }
            return Matrix.Factory.linkToArray(Q);
        }

        public final Matrix solve(Matrix B) {
            int j;
            int k;
            if (B.getRowCount() != (long)this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isFullRank()) {
                throw new RuntimeException("Matrix is rank deficient.");
            }
            int nx = (int)B.getColumnCount();
            double[][] X = B.toDoubleArray();
            for (k = 0; k < this.n; ++k) {
                for (j = 0; j < nx; ++j) {
                    int i;
                    double s = 0.0;
                    for (i = k; i < this.m; ++i) {
                        s += this.QR[i][k] * X[i][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i = k; i < this.m; ++i) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] + s * this.QR[i][k];
                    }
                }
            }
            for (k = this.n - 1; k >= 0; --k) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[k];
                    int n = j++;
                    dArray[n] = dArray[n] / this.Rdiag[k];
                }
                for (int i = 0; i < k; ++i) {
                    for (int j2 = 0; j2 < nx; ++j2) {
                        double[] dArray = X[i];
                        int n = j2;
                        dArray[n] = dArray[n] - X[k][j2] * this.QR[i][k];
                    }
                }
            }
            return Matrix.Factory.linkToArray(X).subMatrix(Calculation.Ret.NEW, 0L, 0L, this.n - 1, nx - 1);
        }
    }
}

