/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigdecimalmatrix.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import org.ujmp.core.bigdecimalmatrix.stub.AbstractDenseBigDecimalMatrix2D;

public class ArrayDenseBigDecimalMatrix2D
extends AbstractDenseBigDecimalMatrix2D {
    private static final long serialVersionUID = 5701752483223767209L;
    private final BigDecimal[][] values;

    public ArrayDenseBigDecimalMatrix2D(BigDecimal[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseBigDecimalMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new BigDecimal[rows][columns];
        int r = this.values.length;
        while (--r != -1) {
            Arrays.fill(this.values[r], BigDecimal.ZERO);
        }
    }

    public ArrayDenseBigDecimalMatrix2D(BigDecimal ... v) {
        super((long)v.length, 1L);
        this.values = new BigDecimal[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public BigDecimal getBigDecimal(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setBigDecimal(BigDecimal value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public BigDecimal getBigDecimal(int row, int column) {
        return this.values[row][column];
    }

    public void setBigDecimal(BigDecimal value, int row, int column) {
        this.values[row][column] = value;
    }
}

