/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GStringsInputFieldPlusChooser;
import org.apache.commons.lang3.StringUtils;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;

public class StringMultiInputParam
extends AbstractParam {
    private GStringsInputFieldPlusChooser fChooser;
    private static final String DEFAULT_PARSE_WS_DELIMS = "\t\n";
    private static final String PARSE_DELIMS = ",\t\n";
    private String alternateDelimiter = null;
    private String parseDelims = ",\t\n";

    public StringMultiInputParam(String name, String desc, boolean reqd) {
        this(name, desc, new String[0], reqd);
    }

    public StringMultiInputParam(String name, String desc, String[] def_and_hints, boolean reqd) {
        super(name, String.class, desc, def_and_hints, reqd);
    }

    public void setAlternateDelimiter(String alternateDelimiter) {
        if (StringUtils.length((CharSequence)alternateDelimiter) > 1) {
            throw new IllegalArgumentException("Illegal alternate delimiter '" + alternateDelimiter + "'; must be a single character only.");
        }
        this.alternateDelimiter = alternateDelimiter;
        this.parseDelims = StringUtils.isBlank((CharSequence)alternateDelimiter) ? PARSE_DELIMS : alternateDelimiter + DEFAULT_PARSE_WS_DELIMS;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(value);
        } else if (value instanceof String[]) {
            super.setValue(value);
        } else if (value instanceof String) {
            super.setValue(value);
        } else {
            throw new IllegalArgumentException("Invalid type, only String[] and comma (or alternate) delim parsable String accepted. Specified: " + value + " class: " + value.getClass());
        }
    }

    @Override
    public boolean isSpecified() {
        boolean is = super.isSpecified();
        if (!is) {
            return is;
        }
        Object val = super.getValue();
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            return val.toString().length() > 0;
        }
        if (val instanceof String[]) {
            return ((String[])val).length > 0;
        }
        throw new IllegalArgumentException("Invalid type, only String[] and comma (or alternate) delim parsable String accepted. Specified: " + val + " class: " + val.getClass());
    }

    private String[] _parse(String s) {
        return ParseUtils.string2strings(s, this.parseDelims, false);
    }

    public void setValue(String[] values) {
        super.setValue(values);
    }

    @Override
    public Object getValue() {
        Object val = super.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        if (val instanceof String[]) {
            return val;
        }
        return this._parse(val.toString());
    }

    public String[] getStrings() {
        return (String[])this.getValue();
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        Object[] ss = (String[])val;
        return this.format(ss);
    }

    private String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String sep = this.alternateDelimiter == null ? "," : this.alternateDelimiter;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            buf.append(vals[i].toString().trim());
            if (i == vals.length - 1) continue;
            buf.append(sep);
        }
        return buf.toString();
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            String text = this.getValueStringRepresentation(false);
            if (text == null) {
                text = this.format((String[])this.getDefault());
            }
            if (text == null) {
                text = "";
            }
            this.fChooser = new GStringsInputFieldPlusChooser(text);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    @Override
    public boolean isFileBased() {
        return false;
    }
}

