/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.modules;

import edu.mit.broad.genome.Conf;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.genepattern.modules.AbstractModule;
import xtools.api.AbstractTool;
import xtools.munge.CollapseDataset;

public class CollapseDatasetWrapper
extends AbstractModule {
    private static final Logger klog = Logger.getLogger(CollapseDatasetWrapper.class);

    private static Options setupCliOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)"expressionDataset");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"res"));
        OptionBuilder.withArgName((String)"chipPlatform");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"chip"));
        OptionBuilder.withArgName((String)"collapseMode");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"mode"));
        OptionBuilder.withArgName((String)"omitFeaturesWithNoSymbolMatch");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"include_only_symbols"));
        OptionBuilder.withArgName((String)"outFile");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"out"));
        OptionBuilder.withArgName((String)"reportLabel");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"rpt_label"));
        OptionBuilder.withArgName((String)"devMode");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"dev_mode"));
        OptionBuilder.withArgName((String)"gpModuleMode");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"run_as_genepattern"));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean success = false;
        CollapseDataset tool = null;
        File tmp_working = null;
        File cwd = null;
        try {
            Options opts = CollapseDatasetWrapper.setupCliOptions();
            PosixParser parser = new PosixParser();
            CommandLine cl = parser.parse(opts, args);
            boolean paramProcessingError = false;
            Properties paramProps = new Properties();
            boolean gpMode = StringUtils.equalsIgnoreCase((CharSequence)cl.getOptionValue("run_as_genepattern"), (CharSequence)"true");
            if (gpMode) {
                System.setProperty("debug", "false");
                System.setProperty("mkdir", "false");
                String outOption = cl.getOptionValue("out");
                if (StringUtils.isNotBlank((CharSequence)outOption)) {
                    klog.warn((Object)"-out parameter ignored; only valid wih -run_as_genepattern false.");
                }
                cwd = new File(System.getProperty("user.dir"));
                tmp_working = new File(".tmp_gsea");
                tmp_working.mkdirs();
            } else {
                CollapseDatasetWrapper.setOptionValueAsParam("out", cl, paramProps, klog);
            }
            boolean devMode = StringUtils.equalsIgnoreCase((CharSequence)cl.getOptionValue("dev_mode"), (CharSequence)"true");
            if (devMode) {
                System.setProperty("MAKE_GSEA_UPDATE_CHECK", "false");
            } else {
                System.setProperty("MAKE_GSEA_UPDATE_CHECK", "true");
                System.setProperty("UPDATE_CHECK_EXTRA_PROJECT_INFO", "GP_MODULES");
            }
            String expressionDataFileName = cl.getOptionValue("res");
            if (StringUtils.isNotBlank((CharSequence)expressionDataFileName)) {
                if (gpMode) {
                    expressionDataFileName = CollapseDatasetWrapper.copyFileWithoutBadChars(expressionDataFileName, tmp_working);
                }
                paramProcessingError |= expressionDataFileName == null;
            } else {
                String paramName = gpMode ? "expression.dataset" : "-res";
                klog.error((Object)("Required parameter '" + paramName + "' not found."));
                paramProcessingError = true;
            }
            String chipPlatformFileName = cl.getOptionValue("chip");
            if (StringUtils.isNotBlank((CharSequence)chipPlatformFileName)) {
                if (gpMode) {
                    chipPlatformFileName = CollapseDatasetWrapper.copyFileWithoutBadChars(chipPlatformFileName, tmp_working);
                }
                paramProcessingError |= chipPlatformFileName == null;
            } else {
                String paramName = gpMode ? "chip.platform.file" : "-chip";
                klog.error((Object)("Required parameter '" + paramName + "' not found"));
                paramProcessingError = true;
            }
            String rptLabel = cl.getOptionValue("rpt_label");
            if (StringUtils.isBlank((CharSequence)rptLabel)) {
                rptLabel = "my_analysis";
            }
            if (paramProcessingError) {
                throw new Exception("There were one or more errors with the job parameters.  Please check log output for details.");
            }
            klog.info((Object)"Parameters passing to CollapseDataset.main:");
            CollapseDatasetWrapper.setParam("res", expressionDataFileName, paramProps, klog);
            CollapseDatasetWrapper.setParam("chip", chipPlatformFileName, paramProps, klog);
            CollapseDatasetWrapper.setParam("rpt_label", rptLabel, paramProps, klog);
            CollapseDatasetWrapper.setParam("gui", "false", paramProps, klog);
            if (gpMode) {
                CollapseDatasetWrapper.setParam("out", cwd.getPath(), paramProps, klog);
            }
            CollapseDatasetWrapper.setOptionValueAsParam("include_only_symbols", cl, paramProps, klog);
            CollapseDatasetWrapper.setOptionValueAsParam("mode", cl, paramProps, klog);
            tool = new CollapseDataset(paramProps);
            success = AbstractTool.module_main(tool);
        }
        catch (Throwable throwable) {
            try {
                if (cwd != null && tmp_working != null) {
                    klog.info((Object)"clean");
                    CollapseDatasetWrapper.cleanUpAnalysisDirs(cwd, tmp_working);
                }
                Conf.exitSystem(!success);
            }
            catch (Throwable throwable2) {
                Conf.exitSystem(!success);
                throw throwable2;
            }
            throw throwable;
        }
        try {
            if (cwd != null && tmp_working != null) {
                klog.info((Object)"clean");
                CollapseDatasetWrapper.cleanUpAnalysisDirs(cwd, tmp_working);
            }
            Conf.exitSystem(!success);
        }
        catch (Throwable throwable) {
            Conf.exitSystem(!success);
            throw throwable;
        }
    }
}

