/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.xbench.core.api.VdbManager;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.File;
import org.apache.log4j.Logger;

public class VdbManagerImpl
implements VdbManager {
    private String fBuildDate;
    private static final Logger klog = Logger.getLogger(VdbManagerImpl.class);

    public VdbManagerImpl(String buildDate) {
        this.fBuildDate = buildDate;
    }

    @Override
    public File getRuntimeHomeDir() {
        return XPreferencesFactory.kAppRuntimeHomeDir;
    }

    @Override
    public File getTmpDir() {
        return VdbManagerImpl._mkdir(new File(this.getRuntimeHomeDir(), "tmp"));
    }

    @Override
    public File getReportsCacheDir() {
        return VdbManagerImpl._mkdir(new File(this.getRuntimeHomeDir(), "reports_cache_" + this.fBuildDate));
    }

    @Override
    public File getDefaultOutputDir() {
        File pwd = SystemUtils.getPwd();
        String dn = NamingConventions.createNiceEnglishDate_for_dirs();
        return VdbManagerImpl._mkdir(new File(pwd, dn));
    }

    private static File _mkdir(File dir) {
        if (!dir.exists()) {
            boolean made = dir.mkdir();
            if (!made) {
                klog.fatal((Object)("Could not make dir: " + dir));
            } else {
                klog.info((Object)("Made Vdb dir JIT: " + dir));
            }
        }
        return dir;
    }
}

