/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.misc_actions;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import javax.swing.Icon;

public class LoadAction
extends FileObjectAction {
    private Object fFileOrObject;
    private static final Icon RELOAD_ICON = JarResources.getIcon("Refresh16_2.gif");

    public LoadAction() {
        super("ForceReloadAction", "Force data reload", "Reload data from source file overwriting the cache", RELOAD_ICON);
    }

    @Override
    public void setFile(File file) {
        this.fFileOrObject = file;
    }

    @Override
    public void setObject(Object obj) {
        this.fFileOrObject = obj;
    }

    @Override
    public Widget getWidget() {
        Widget widget = null;
        try {
            if (this.fFileOrObject != null) {
                File sourceFile = this.fFileOrObject instanceof File ? (File)this.fFileOrObject : ParserFactory.getCache().getSourceFile(this.fFileOrObject);
                PersistentObject pob = ParserFactory.read(sourceFile, false);
                if (pob != null) {
                    Application.getWindowManager().showMessage("<html><body><b>Successfully reloaded: " + pob.getName() + "</b><br>From file: " + sourceFile + "</body></html>");
                } else {
                    this.log.info((Object)"Cancelled data import!!");
                }
            } else {
                Application.getWindowManager().showMessage("No file or object to load/reload was specified");
            }
        }
        catch (Throwable t) {
            Application.getWindowManager().showError("Error loading data from file", t);
        }
        return widget;
    }
}

