/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class ParserWorker
extends SwingWorker<Object, Void> {
    private static final Logger klog = Logger.getLogger(ParserWorker.class);
    private File[] files;

    public ParserWorker(File[] files) {
        this.files = files;
    }

    @Override
    protected Object doInBackground() throws Exception {
        StringBuffer buf_s = new StringBuffer("Loading ... " + this.files.length + " files\n\n");
        int sucess = 0;
        Errors errors = new Errors();
        for (int f = 0; f < this.files.length; ++f) {
            if (this.files[f].isDirectory()) {
                errors.add(new RuntimeException("Only files can be choosen - a directory was specified: " + this.files[f].getPath()));
                continue;
            }
            try {
                FileInputStream in = new FileInputStream(this.files[f]);
                ProgressMonitorInputStream pis = new ProgressMonitorInputStream(Application.getWindowManager().getRootFrame(), "Loading file " + this.files[f].getName(), in);
                PersistentObject pob = ParserFactory.read(this.files[f].getPath(), pis);
                if (pob == null || pis.getProgressMonitor().isCanceled()) {
                    throw new RuntimeException("Loading of file '" + this.files[f].getName() + "' canceled.");
                }
                klog.info((Object)("Loaded file: " + this.files[f].getPath()));
                Application.getFileManager().registerRecentlyOpenedFile(this.files[f]);
                buf_s.append(this.files[f].getName()).append("\n");
                ++sucess;
                continue;
            }
            catch (Throwable t) {
                errors.add("Parsing trouble", t);
            }
        }
        buf_s.append("\nFiles loaded successfully: ").append(sucess).append(" / ").append(this.files.length).append('\n');
        if (errors.isEmpty()) {
            buf_s.append("There were NO errors");
            Application.getWindowManager().showMessage(buf_s.toString());
        } else {
            Application.getWindowManager().showError(errors);
        }
        return null;
    }
}

