/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.parsers.AuxUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import xtools.api.param.GuiParam;
import xtools.api.param.MissingReqdParamException;
import xtools.api.param.Param;
import xtools.api.param.ParamComparator;
import xtools.api.param.ParamSet;
import xtools.api.param.ReportDirParam;
import xtools.api.param.ReportLabelParam;

public class ToolParamSet
implements ParamSet {
    private final List fReqdParams;
    private final List fOptParams;
    private final Logger log = Logger.getLogger(ToolParamSet.class);

    public ToolParamSet() {
        this.fReqdParams = new ArrayList();
        this.fOptParams = new ArrayList();
    }

    public Param getParam(String paramName) {
        Param p;
        int i;
        for (i = 0; i < this.fReqdParams.size(); ++i) {
            p = (Param)this.fReqdParams.get(i);
            if (!p.getName().equals(paramName)) continue;
            return p;
        }
        for (i = 0; i < this.fOptParams.size(); ++i) {
            p = (Param)this.fOptParams.get(i);
            if (!p.getName().equals(paramName)) continue;
            return p;
        }
        return null;
    }

    public void addParam(Param param) {
        if (param == null) {
            throw new IllegalArgumentException("Null param not allowed");
        }
        this.checkUniqueness(param);
        if (param.isReqd()) {
            this.fReqdParams.add(param);
        } else {
            this.fOptParams.add(param);
        }
    }

    public void addParamAdv(Param param) {
        param.setType(Param.ADVANCED);
        this.addParam(param);
    }

    public void addParamPseudoReqd(Param param) {
        param.setType(Param.PSEUDO_REQUIRED);
        this.addParam(param);
    }

    public void addParamBasic(Param param) {
        param.setType(Param.BASIC);
        this.addParam(param);
    }

    @Override
    public int getNumParams() {
        return this.fReqdParams.size() + this.fOptParams.size();
    }

    @Override
    public Param getParam(int pos) {
        if (pos < this.fReqdParams.size()) {
            return (Param)this.fReqdParams.get(pos);
        }
        return (Param)this.fOptParams.get(pos - this.fReqdParams.size());
    }

    /*
     * WARNING - void declaration
     */
    public void fill(Properties prop) {
        String val;
        Param param;
        int i;
        for (i = 0; i < this.fReqdParams.size(); ++i) {
            void var5_6;
            param = (Param)this.fReqdParams.get(i);
            val = prop.getProperty(param.getName());
            if (val != null) {
                val = val.trim();
            }
            if (val != null && val.equals("")) {
                Object var5_7 = null;
            } else if (val != null && val.equalsIgnoreCase("null")) {
                Object var5_8 = null;
            } else if (val != null) {
                String string = val;
            } else {
                Object var5_10 = null;
            }
            param.setValue(var5_6);
        }
        for (i = 0; i < this.fOptParams.size(); ++i) {
            void var5_16;
            param = (Param)this.fOptParams.get(i);
            val = prop.getProperty(param.getName());
            if (val != null) {
                val = val.trim();
            }
            if (val != null && val.equals("")) {
                Object var5_12 = null;
            } else if (val != null && val.equalsIgnoreCase("null")) {
                Object var5_13 = null;
            } else if (val != null) {
                String string = val;
            } else {
                Object var5_15 = null;
            }
            param.setValue(var5_16);
        }
        HashSet<String> badParamNames = new HashSet<String>();
        Iterator<Object> it = prop.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Param param2 = this.getParam(key);
            if (param2 != null || key.equals("param_file")) continue;
            badParamNames.add(key);
        }
        if (!badParamNames.isEmpty()) {
            StringBuffer buf = new StringBuffer("Some specified parameters are UNKNOWN to this usage: ").append(badParamNames.size()).append('\n');
            for (Object e : badParamNames) {
                buf.append(e).append('\t').append('>').append(prop.getProperty(e.toString())).append("<\n");
            }
            this.log.warn((Object)buf.toString());
        }
    }

    @Override
    public ParamSet.FoundMissingFile fileCheckingFill(Properties prop) {
        File f;
        String setval;
        String val;
        Param param;
        int i;
        ArrayList<File> foundFiles = new ArrayList<File>();
        ArrayList<File> missingFiles = new ArrayList<File>();
        ArrayList<String> foundFilesParamNames = new ArrayList<String>();
        for (i = 0; i < this.fReqdParams.size(); ++i) {
            param = (Param)this.fReqdParams.get(i);
            val = prop.getProperty(param.getName());
            if (val != null) {
                val = val.trim();
            }
            if ((setval = val != null && val.equals("") ? null : (val != null ? val : null)) != null && param.isFileBased() && !(param instanceof ReportDirParam) && !NamingConventions.isURL(setval)) {
                f = new File(setval);
                if (!(f = AuxUtils.getBaseFileFromAuxFile(f)).exists()) {
                    setval = null;
                    missingFiles.add(f);
                } else {
                    foundFilesParamNames.add(param.getName());
                    foundFiles.add(f);
                }
            }
            param.setValue(setval);
        }
        for (i = 0; i < this.fOptParams.size(); ++i) {
            param = (Param)this.fOptParams.get(i);
            val = prop.getProperty(param.getName());
            if (val != null) {
                val = val.trim();
            }
            if ((setval = val != null && val.equals("") ? null : (val != null ? val : null)) != null && param.isFileBased() && !NamingConventions.isURL(setval)) {
                f = new File(setval);
                if (!f.exists()) {
                    setval = null;
                    missingFiles.add(f);
                } else {
                    foundFilesParamNames.add(param.getName());
                    foundFiles.add(f);
                }
            }
            param.setValue(setval);
        }
        ParamSet.FoundMissingFile fmf = new ParamSet.FoundMissingFile();
        fmf.foundFiles = foundFiles.toArray(new File[foundFiles.size()]);
        fmf.foundFilesParamNames = foundFilesParamNames.toArray(new String[foundFilesParamNames.size()]);
        fmf.missingFiles = missingFiles.toArray(new File[missingFiles.size()]);
        return fmf;
    }

    @Override
    public Properties toProperties() {
        Properties props = new Properties();
        for (int i = 0; i < this.getNumParams(); ++i) {
            String s;
            Param param = this.getParam(i);
            if (!param.isSpecified() || (s = param.getValueStringRepresentation(true)) == null || (s = s.trim()).length() <= 0) continue;
            props.setProperty(param.getName(), s);
        }
        return props;
    }

    public void check() throws MissingReqdParamException {
        StringBuffer errors = new StringBuffer("\n\nError: Missing the following required parameters:\n");
        ArrayList<Param> missingParams = new ArrayList<Param>();
        for (int i = 0; i < this.fReqdParams.size(); ++i) {
            Param param = (Param)this.fReqdParams.get(i);
            if (param.isSpecified()) continue;
            errors.append('\t').append(((Param)this.fReqdParams.get(i)).formatForCmdLine());
            missingParams.add(param);
        }
        errors.append("\n-----------------------------------------------------------\n");
        errors.append(this.getUsage());
        if (!missingParams.isEmpty()) {
            throw new MissingReqdParamException(missingParams.toArray(new Param[missingParams.size()]));
        }
    }

    @Override
    public boolean isRequiredAllSet() throws RuntimeException {
        for (int i = 0; i < this.fReqdParams.size(); ++i) {
            Param param = (Param)this.fReqdParams.get(i);
            if (param.isSpecified() || param.getDefault() != null) continue;
            return false;
        }
        return true;
    }

    public Param[] getParams() {
        int i;
        ArrayList all = new ArrayList();
        for (i = 0; i < this.fReqdParams.size(); ++i) {
            all.add(this.fReqdParams.get(i));
        }
        for (i = 0; i < this.fOptParams.size(); ++i) {
            all.add(this.fOptParams.get(i));
        }
        return all.toArray(new Param[all.size()]);
    }

    @Override
    public Param[] getParams(Param.Type thisType, boolean excludeCommonOnes) {
        Param[] params = this.getParams();
        ArrayList<Param> use = new ArrayList<Param>();
        for (int i = 0; i < params.length; ++i) {
            if (excludeCommonOnes && params[i] instanceof GuiParam || !params[i].getType().equals(thisType)) continue;
            use.add(params[i]);
        }
        return use.toArray(new Param[use.size()]);
    }

    @Override
    public ReportDirParam getAnalysisDirParam() {
        for (int i = 0; i < this.getNumParams(); ++i) {
            Param p = this.getParam(i);
            if (!(p instanceof ReportDirParam)) continue;
            return (ReportDirParam)p;
        }
        return null;
    }

    @Override
    public ReportLabelParam getReportLabelParam() {
        for (int i = 0; i < this.getNumParams(); ++i) {
            Param p = this.getParam(i);
            if (!(p instanceof ReportLabelParam)) continue;
            return (ReportLabelParam)p;
        }
        return null;
    }

    @Override
    public GuiParam getGuiParam() {
        for (int i = 0; i < this.getNumParams(); ++i) {
            Param p = this.getParam(i);
            if (!(p instanceof GuiParam)) continue;
            return (GuiParam)p;
        }
        return null;
    }

    @Override
    public String getAsCommand(boolean fullfilepaths) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getNumParams(); ++i) {
            String rep;
            Param param = this.getParam(i);
            if (param instanceof GuiParam || (rep = param.getValueStringRepresentation(fullfilepaths)) == null || (rep = rep.trim()).length() <= 0) continue;
            buf.append(" -").append(param.getName()).append(' ').append(rep);
        }
        return buf.toString();
    }

    public String getUsage() {
        int i;
        StringBuffer buf = new StringBuffer("\n######## USAGE ########\n\n");
        if (this.fReqdParams.size() > 0) {
            buf.append("Required Parameters:").append('\n');
            for (i = 0; i < this.fReqdParams.size(); ++i) {
                buf.append(((Param)this.fReqdParams.get(i)).formatForCmdLine()).append('\n');
            }
        } else {
            buf.append("No required parameters").append('\n');
        }
        buf.append('\n');
        if (this.fOptParams.size() > 0) {
            buf.append("Optional Parameters:").append('\n');
            for (i = 0; i < this.fOptParams.size(); ++i) {
                buf.append(((Param)this.fOptParams.get(i)).formatForCmdLine()).append('\n');
            }
        } else {
            buf.append("No optional parameters").append('\n');
        }
        return buf.toString();
    }

    public void printfUsage() {
        System.out.println(this.getUsage());
    }

    private void checkUniqueness(Param param) {
        if (param == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        if (this.fOptParams.contains(param)) {
            throw new RuntimeException("Duplicated param in declarations - already have param: " + param + " # params: " + this.getNumParams() + " in the opt param list");
        }
        if (this.fReqdParams.contains(param)) {
            throw new RuntimeException("Duplicated param in declarations - already have param: " + param.getName() + " # params: " + this.getNumParams() + " in the reqd param list");
        }
    }

    public void sort() {
        Collections.sort(this.fReqdParams, new ParamComparator());
        Collections.sort(this.fOptParams, new ParamComparator());
    }
}

