/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GSafeCharsField;
import xtools.api.param.AbstractParam;
import xtools.api.param.Param;
import xtools.api.param.ParamHelper;

public class StringInputParam
extends AbstractParam {
    private GSafeCharsField tfName;
    private char[] addSafe;

    public StringInputParam(String name, String nameEnglish, String desc, String def_andonly_hint, boolean reqd) {
        super(name, nameEnglish, String.class, desc, (Object[])new String[]{def_andonly_hint}, reqd);
    }

    public StringInputParam(String name, String nameEnglish, String desc, String def_andonly_hint, boolean reqd, char[] addSafeChars, Param.Type type) {
        super(name, nameEnglish, String.class, desc, (Object[])new String[]{def_andonly_hint}, reqd);
        this.addSafe = addSafeChars;
        this.setType(type);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(value);
        } else if (value instanceof String) {
            String ss = ((String)value).trim();
            if (ss.length() == 0) {
                super.setValue(null);
            } else {
                this.setValue(ss);
            }
        } else {
            throw new IllegalArgumentException("Invalid type, only String accepted. Specified: " + value + " class: " + value.getClass());
        }
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.tfName == null) {
            Object t = this.getValue();
            if (t == null) {
                t = this.getDefault();
            }
            this.tfName = t != null ? new GSafeCharsField(t.toString()) : new GSafeCharsField();
            if (this.addSafe != null) {
                this.tfName.addSafeChars(this.addSafe);
            }
            ParamHelper.addDocumentListener(this.tfName, this);
        }
        return this.tfName;
    }

    @Override
    public boolean isFileBased() {
        return false;
    }
}

