/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;

public class SortParam
extends AbstractParam
implements ActionListener {
    private GComboBoxField cbOptions;

    public SortParam(boolean reqd) {
        super("sort", "Gene list sorting mode", SortMode.class, "Mode in which scores from the gene list should be considered ", (Object[])SortMode.ALL, reqd);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(null);
        } else {
            super.setValue(SortMode.lookup(value));
        }
    }

    public void setValue(SortMode sort) {
        super.setValue(sort);
    }

    public SortMode getMode() {
        Object val = super.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (SortMode)val;
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.cbOptions == null) {
            this.cbOptions = ParamHelper.createActionListenerBoundHintsComboBox(false, this, this);
            ParamHelper.safeSelectValueDefaultByString(this.cbOptions.getComboBox(), this);
        }
        return this.cbOptions;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setValue((SortMode)((JComboBox)this.cbOptions.getComponent()).getSelectedItem());
    }

    @Override
    public boolean isFileBased() {
        return false;
    }
}

