/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.io.File;
import xtools.api.param.FileParam;
import xtools.api.param.ParamHelper;

public class DirParam
extends FileParam {
    protected GDirFieldPlusChooser fChooser;

    public DirParam(String name, String nameEnglish, String desc, File hint, boolean reqd) {
        this(name, nameEnglish, desc, new File[]{hint}, reqd);
    }

    public DirParam(boolean reqd) {
        this("dir", "Path to dir", "Path to data dir", new File[0], reqd);
    }

    public DirParam(String name, String nameEnglish, String desc, File[] hints, boolean reqd) {
        super(name, nameEnglish, desc, hints, reqd);
    }

    public DirParam(String name, String nameEnglish, String desc, boolean reqd) {
        super(name, nameEnglish, desc, new File[0], reqd);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(value);
        } else if (value instanceof File) {
            this.setValue((File)value);
        } else if (value instanceof String) {
            this.setValue(new File(value.toString()));
        } else {
            throw new IllegalArgumentException("Invalid type, only File and String accepted. Specified: " + value + " class: " + value.getClass());
        }
    }

    @Override
    public void setValue(String dirpath) {
        this.setValue(new File(dirpath));
    }

    @Override
    public void setValue(File dir) {
        super.setValue(dir);
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    public File getDir() {
        Object val = super.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (File)val;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        File file = (File)this.getValue();
        if (full) {
            return file.getAbsolutePath();
        }
        return file.getName();
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new GDirFieldPlusChooser();
            if (this.getValue() != null) {
                this.fChooser.setValue(this.getValue());
            } else {
                this.fChooser.setValue(this.getDefault());
            }
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }
}

