/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.utils.ClassUtils;
import javax.swing.Action;
import org.apache.log4j.Logger;
import xtools.api.param.Param;

public abstract class AbstractParam
implements Param {
    protected static final Logger klog = Logger.getLogger(AbstractParam.class);
    protected Logger log;
    private String fName;
    private Class[] fClassTypes;
    private String fDesc;
    private String fNameEnglish;
    private StringBuffer fHtmlLabel_v2;
    private StringBuffer fHtmlLabel_v3;
    private boolean fReqd;
    private Object fValue;
    private Object[] fHints;
    private Object fDefault;
    private Param.Type fType;

    protected AbstractParam() {
    }

    protected AbstractParam(String name, Class type, String desc, Object[] hintsanddef, boolean reqd) {
        this(name, (String)null, new Class[]{type}, desc, hintsanddef, reqd);
    }

    protected AbstractParam(String name, Class type, String desc, Object def, Object[] hints, boolean reqd) {
        this(name, null, new Class[]{type}, desc, def, hints, reqd);
    }

    protected AbstractParam(String name, String nameEnglish, Class[] types, String desc, Object[] hintsanddef, boolean reqd) {
        if (hintsanddef == null) {
            throw new IllegalArgumentException("hint param cannot be null");
        }
        Object def = hintsanddef.length > 0 ? hintsanddef[0] : null;
        this.init(name, nameEnglish, types, desc, hintsanddef, def, reqd, null);
    }

    protected AbstractParam(String name, String nameEnglish, Class type, String desc, Object[] hintsanddef, boolean reqd) {
        this(name, nameEnglish, new Class[]{type}, desc, hintsanddef, reqd);
    }

    protected AbstractParam(String name, String nameEnglish, Class[] types, String desc, Object def_andonly_hint, boolean reqd) {
        if (def_andonly_hint == null) {
            throw new IllegalArgumentException("def_andonly_hint param cannot be null");
        }
        this.init(name, nameEnglish, types, desc, new Object[]{def_andonly_hint}, def_andonly_hint, reqd, null);
    }

    protected AbstractParam(String name, String nameEnglish, Class type, String desc, Object def_andonly_hint, boolean reqd) {
        this(name, nameEnglish, new Class[]{type}, desc, def_andonly_hint, reqd);
    }

    protected AbstractParam(String name, String nameEnglish, Class type, String desc, Object def_andonly_hint, boolean reqd, Param.Type paramType) {
        this.init(name, nameEnglish, new Class[]{type}, desc, new Object[]{def_andonly_hint}, def_andonly_hint, reqd, paramType);
    }

    protected AbstractParam(String name, String nameEnglish, Class[] types, String desc, Object def, Object[] hints, boolean reqd) {
        this.init(name, nameEnglish, types, desc, hints, def, reqd, null);
    }

    protected AbstractParam(String name, String nameEnglish, Class[] types, String desc, Object def, Object[] hints, boolean reqd, Param.Type type) {
        this.init(name, nameEnglish, types, desc, hints, def, reqd, type);
    }

    protected AbstractParam(String name, String nameEnglish, Class type, String desc, Object def, Object[] hints, boolean reqd) {
        this(name, nameEnglish, new Class[]{type}, desc, def, hints, reqd);
    }

    protected AbstractParam(String name, String nameEnglish, Class type, String desc, Object def, Object[] hints, boolean reqd, Param.Type paramType) {
        this(name, nameEnglish, new Class[]{type}, desc, def, hints, reqd, paramType);
    }

    protected void init(String name, String nameEnglish, Class[] classTypes, String desc, Object[] hints, Object def, boolean reqd, Param.Type type) {
        if (name == null) {
            throw new IllegalArgumentException("name param cannot be null");
        }
        if (classTypes == null) {
            throw new IllegalArgumentException("types param cannot be null");
        }
        if (classTypes.length == 0) {
            throw new IllegalArgumentException("types param cannot be empty");
        }
        for (int i = 0; i < classTypes.length; ++i) {
            if (classTypes[i] != null) continue;
            throw new IllegalArgumentException("types param cannot be null at: " + i);
        }
        if (desc == null) {
            throw new IllegalArgumentException("desc param cannot be null");
        }
        if (hints == null) {
            throw new IllegalArgumentException("hint param cannot be null");
        }
        if (name.indexOf(" ") != -1) {
            throw new IllegalArgumentException("Programmatic error: param name cannot contain whitespace");
        }
        if (name.indexOf("'") != -1) {
            throw new IllegalArgumentException("Programmatic error: param name cannot contain quote '");
        }
        if (name.indexOf("\"") != -1) {
            throw new IllegalArgumentException("Programmatic error: param name cannot contain quote \"");
        }
        this.fName = name;
        this.fNameEnglish = nameEnglish;
        this.fClassTypes = classTypes;
        this.fDesc = desc;
        this.fHints = hints;
        this.fReqd = reqd;
        this.fDefault = def;
        this.fType = type;
        this.log = Logger.getLogger(this.getClass());
    }

    @Override
    public String getName() {
        return this.fName;
    }

    protected Action createHelpAction() {
        return JarResources.createHelpAction(this.getName());
    }

    @Override
    public Param.Type getType() {
        if (this.fType != null) {
            return this.fType;
        }
        if (this.fReqd) {
            return Param.REQUIRED;
        }
        return Param.BASIC;
    }

    @Override
    public void setType(Param.Type type) {
        this.fType = type;
    }

    @Override
    public String getHtmlLabel_v2() {
        if (this.fHtmlLabel_v2 == null) {
            this.fHtmlLabel_v2 = new StringBuffer("<Html><body><b>").append(this.getNameEnglish()).append("</b></body></Html>");
        }
        return this.fHtmlLabel_v2.toString();
    }

    @Override
    public String getHtmlLabel_v3() {
        if (this.fHtmlLabel_v3 == null) {
            this.fHtmlLabel_v3 = new StringBuffer("<Html><body><b>").append(this.getNameEnglish()).append("</b>");
            if (this.isReqd() || this.getType() == Param.PSEUDO_REQUIRED) {
                this.fHtmlLabel_v3.append("<font color=\"red\">*</font>");
            }
            this.fHtmlLabel_v3.append("</body></Html>");
        }
        return this.fHtmlLabel_v3.toString();
    }

    @Override
    public String getDesc() {
        return this.fDesc;
    }

    @Override
    public String getNameEnglish() {
        if (this.fNameEnglish == null) {
            return this.fName;
        }
        return this.fNameEnglish;
    }

    public Class[] getTypes() {
        return this.fClassTypes;
    }

    @Override
    public String formatForCmdLine() {
        StringBuffer buf = new StringBuffer();
        String ct = "na";
        if (this.fClassTypes != null && this.fClassTypes.length > 0) {
            ct = ClassUtils.shorten(this.fClassTypes[0]);
        }
        buf.append("-").append(this.fName).append(' ').append('<').append(ct).append('>').append("\n");
        buf.append("\t").append(this.fDesc).append("\n");
        String def = AbstractParam._getCmdLineVersion(this.fDefault);
        if (def != null) {
            buf.append("\tDefault: ");
            buf.append(def.toString());
        }
        boolean added_start = false;
        if (this.fHints != null && this.fHints.length > 0) {
            for (int i = 0; i < this.fHints.length; ++i) {
                String hn = AbstractParam._getCmdLineVersion(this.fHints[i]);
                if (hn == null) continue;
                if (!added_start) {
                    buf.append("\n\t");
                    buf.append("Hints  : ");
                    added_start = true;
                }
                buf.append(hn);
                if (i == this.fHints.length - 1) continue;
                buf.append(',');
            }
        }
        if (added_start) {
            buf.append('\n');
        }
        return buf.toString();
    }

    private static String _getCmdLineVersion(Object obj) {
        String def = null;
        if (obj instanceof PersistentObject) {
            def = ((PersistentObject)obj).getName();
        } else if (obj != null) {
            if (obj instanceof PersistentObject[]) {
                PersistentObject[] objs = (PersistentObject[])obj;
                if (objs.length > 0) {
                    def = objs[0].getName();
                }
            } else if (obj instanceof Object[]) {
                Object[] objs = (Object[])obj;
                if (objs.length > 0) {
                    def = objs[0].toString();
                }
            } else {
                def = obj.toString();
            }
        }
        return def;
    }

    @Override
    public boolean isReqd() {
        return this.fReqd;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractParam && this.fName.equals(((AbstractParam)obj).fName);
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    @Override
    public void setValue(Object value) {
        this.fValue = value;
    }

    @Override
    public Object getValue() {
        if (this.fValue != null) {
            return this.fValue;
        }
        return this.fDefault;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public Object[] getHints() {
        return this.fHints;
    }

    protected void setHints(Object[] hints) {
        this.fHints = hints;
    }

    @Override
    public Object getDefault() {
        return this.fDefault;
    }

    @Override
    public boolean isSpecified() {
        boolean defaultAvailable;
        Object def = this.getDefault();
        if (def != null) {
            defaultAvailable = true;
            if (def instanceof Object[] && ((Object[])def).length == 0) {
                defaultAvailable = false;
            }
        } else {
            defaultAvailable = false;
        }
        if (this.fValue == null && !defaultAvailable) {
            return false;
        }
        if (this.fValue != null && this.fValue instanceof Object[] && ((Object[])this.fValue).length != 0) {
            return true;
        }
        return this.fValue == null || this.fValue.toString().length() != 0 || defaultAvailable;
    }

    protected static Integer[] toInts(int[] ints) {
        Integer[] fl = new Integer[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            fl[i] = new Integer(ints[i]);
        }
        return fl;
    }
}

