/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.looks.HeaderStyle;
import com.jidesoft.docking.DefaultDockableHolder;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import edu.mit.broad.cytoscape.action.EnrichmentMapInputPanelAction;
import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.ImageComponent;
import edu.mit.broad.genome.swing.SystemConsole;
import edu.mit.broad.xbench.actions.ShowAppRuntimeHomeDirAction;
import edu.mit.broad.xbench.actions.ShowDefaultOutputDirAction;
import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.core.WrappedComponent;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.FileManager;
import edu.mit.broad.xbench.core.api.FileManagerImpl;
import edu.mit.broad.xbench.core.api.ToolManager;
import edu.mit.broad.xbench.core.api.ToolManagerImpl;
import edu.mit.broad.xbench.core.api.VdbManager;
import edu.mit.broad.xbench.core.api.WindowManager;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import edu.mit.broad.xbench.tui.TaskManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.broad.gsea.ui.DesktopIntegration;
import org.jfree.ui.about.AboutPanel;
import xapps.api.AppDataLoaderAction;
import xapps.api.AppToolLauncherAction;
import xapps.api.PastAnalysisAction;
import xapps.api.frameworks.WorkspaceToolBar;
import xapps.api.frameworks.fiji.StatusBarAppender;
import xapps.api.frameworks.fiji.WindowManagerImplJideTabbedPane;
import xapps.gsea.GseaActionRegistry;
import xapps.gsea.GseaPreferencesDialog;
import xapps.gsea.GseaWebResources;
import xapps.gsea.LeadingEdgeReportAction;
import xapps.gsea.UpdateChecker;
import xapps.gsea.VdbManagerForGsea;
import xtools.chip2chip.Chip2Chip;
import xtools.gsea.Gsea;
import xtools.gsea.GseaPreranked;
import xtools.munge.CollapseDataset;

public class GseaFijiTabsApplicationFrame
extends DefaultDockableHolder
implements Application.Handler {
    public static final Properties buildProps = JarResources.getBuildInfo();
    private static final int INITIAL_LHS_WIDTH = 200;
    public static final String RPT_CACHE_BUILD_DATE = "April4_2006_build";
    private static String USER_VISIBLE_FRAME_TITLE;
    private static final Image ICON;
    private static final Icon PREF_ICON;
    public static final String PROFILE_NAME = "gsea";
    private StatusBarAppender fStatusBarAppender;
    private GseaFijiTabsApplicationFrame fFrame = this;
    private WindowAdapter fWindowListener;
    private MyWindowManagerImplJideTabbedPane fWindowManager;
    private AppToolLauncherAction fGseaTool_launcher;
    private AppDataLoaderAction fAppDataLoaderAction;
    private Gsea fGseaTool;
    private static final VdbManager fVdbmanager;
    private ToolManagerImpl fToolManager;
    private FileManager fFileManager;

    public GseaFijiTabsApplicationFrame() {
        super(USER_VISIBLE_FRAME_TITLE);
        this.fFrame.setVisible(false);
        this.fFrame.setDefaultCloseOperation(0);
        this.fFrame.setIconImage(ICON);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GseaFijiTabsApplicationFrame.this.exitApplication();
            }
        };
        if (SystemUtils.IS_OS_MAC_OSX) {
            try {
                DesktopIntegration.setAboutHandler(this);
                DesktopIntegration.setQuitHandler(this);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                System.out.println("Error setting apple-specific about and quit handlers");
            }
        }
        this.fFrame.addWindowListener(this.fWindowListener);
        this.fFrame.getDockingManager().setProfileKey(PROFILE_NAME);
        this.fFrame.getDockingManager().setOutlineMode(0);
        this.fFrame.getDockingManager().beginLoadLayoutData();
        this.fFrame.getDockingManager().setInitSplitPriority(1);
        this.fWindowManager = new MyWindowManagerImplJideTabbedPane();
        this.fStatusBarAppender = SystemConsole.createStatusBarAppender("StatusBar");
        Application.registerHandler(this);
        this.fFrame.setJMenuBar(this.createMenuBar());
        this.jbInit();
    }

    public void showAboutDialog() {
        Object buildInfo = this.formatBuildInfoForHelp();
        String buildTS = this.formatBuildTimestampForHelp();
        if (buildTS != null) {
            buildInfo = (String)buildInfo + ", " + buildTS;
        }
        AboutPanel aboutPanel = new AboutPanel("Gene Set Enrichment Analysis (GSEA) v" + buildProps.getProperty("build.version"), "Copyright (c) 2003-2017 Broad Institute, Inc., Massachusetts Institute of Technology, ", "and Regents of the University of California.  All rights reserved.", (String)buildInfo);
        JOptionPane.showMessageDialog((Component)((Object)this.fFrame), aboutPanel, "About GSEA", -1);
    }

    public void makeVisible(boolean bring2front) {
        this.fFrame.getDockingManager().loadLayoutData();
        this.fFrame.getDockingManager().getWorkspace().setAcceptDockableFrame(false);
        if (bring2front) {
            this.fFrame.toFront();
        }
    }

    public void init_bg_while_splashing() {
        try {
            Application.getFileManager().getFileChooser();
            Application.getFileManager().getDirChooser("test");
        }
        catch (Throwable t) {
            System.out.println("Error background initing: " + t);
        }
        this.fAppDataLoaderAction.getWidget();
        this.fGseaTool_launcher.getWidget();
        System.out.println("Done initing things while splashing");
    }

    private void jbInit() {
        this.fFrame.getContentPane().setLayout(new BorderLayout());
        JideSplitPane split = new JideSplitPane();
        split.add((Component)this.createToolBar());
        split.setShowGripper(true);
        split.setContinuousLayout(false);
        split.add((Component)this.fWindowManager.getTabbedPane());
        this.fWindowManager.openWindow(this.createStartupPanel());
        try {
            this.fWindowManager.getTabbedPane().setTabClosableAt(0, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fFrame.getContentPane().add((Component)split);
        this.fFrame.getContentPane().add((Component)this.fStatusBarAppender.getAsComponent(), "Last");
        UpdateChecker.oneTimeGseaUpdateCheck((Component)((Object)this));
    }

    private JComponent createToolBar() {
        WorkspaceToolBar tb1 = new WorkspaceToolBar(1);
        tb1.setFloatable(false);
        tb1.setBorder(BorderFactory.createTitledBorder("Steps in GSEA analysis"));
        int width = 75;
        int height = 60;
        Font font = new Font("Arial", 1, 12);
        int struth = 15;
        this.fAppDataLoaderAction = new AppDataLoaderAction();
        this.fGseaTool = new Gsea();
        this.fGseaTool_launcher = new AppToolLauncherAction(this.fGseaTool, this.fGseaTool.getParamSet(), "Run Gsea", JarResources.getIcon("Gsea_app16_v2.png"));
        tb1.add(JarResources.toURL("LocalFileExplorerWidget32.gif"), "Load data          ", (Action)this.fAppDataLoaderAction, width, height, font, true);
        tb1.add(Box.createVerticalStrut(struth));
        tb1.add(JarResources.toURL("GseaApp24.gif"), "Run GSEA           ", (Action)this.fGseaTool_launcher, width, height, font, true);
        tb1.add(Box.createVerticalStrut(struth));
        tb1.add(JarResources.toURL("Lev32.gif"), "Leading edge analysis", (Action)new LeadingEdgeReportAction(), width, height, font, true);
        tb1.add(Box.createVerticalStrut(struth));
        tb1.add(JarResources.toURL("enrichmentmap_logo.gif"), "Enrichment Map Visualization", (Action)new EnrichmentMapInputPanelAction(), width, height, font, true);
        tb1.add(Box.createVerticalStrut(struth));
        WorkspaceToolBar tb2 = new WorkspaceToolBar(1);
        tb2.setFloatable(false);
        tb2.setBorder(BorderFactory.createTitledBorder("Tools"));
        GseaPreranked gsea_tool = new GseaPreranked();
        CollapseDataset cd = new CollapseDataset();
        Chip2Chip fChip2ChipTool = new Chip2Chip();
        tb2.add(JarResources.toURL("GseaApp24.gif"), "Run GSEAPreranked  ", (Action)new AppToolLauncherAction(gsea_tool, gsea_tool.getParamSet(), "Run Gsea on a Pre-Ranked gene list", JarResources.getIcon("Gsea_app16_v2.png")), width, height, font, true);
        tb2.add(Box.createVerticalStrut(struth));
        tb2.add(JarResources.toURL("ProjectSpecific16.png"), "Collapse Dataset   ", (Action)new AppToolLauncherAction(cd, cd.getParamSet(), "Collapse Dataset from Probes to Symbols", JarResources.getIcon("ProjectSpecific16.png")), width, height, font, true);
        tb2.add(Box.createVerticalStrut(struth));
        tb2.add(JarResources.toURL("Chip2Chip24_b.gif"), "Chip2Chip mapping", (Action)new AppToolLauncherAction(fChip2ChipTool, fChip2ChipTool.getParamSet(), "Chip2Chip", JarResources.getIcon("Chip2Chip16.gif")), width, height, font, true);
        tb2.add(Box.createVerticalStrut(struth));
        WorkspaceToolBar tb3 = new WorkspaceToolBar(1);
        tb3.setBorder(BorderFactory.createEtchedBorder());
        tb3.setFloatable(false);
        tb3.add(JarResources.toURL("past_analysis32.gif"), "Analysis history", (Action)new PastAnalysisAction(), width, height, font, true);
        tb3.add(Box.createVerticalStrut(50));
        WorkspaceToolBar tb = new WorkspaceToolBar(1);
        tb.setFloatable(false);
        tb.add(tb1);
        tb.add(tb2);
        tb.add(tb3);
        JideSplitPane pane = new JideSplitPane(0);
        pane.setShowGripper(true);
        pane.add((Component)tb);
        pane.add((Component)this.createProcessForToolBar());
        return pane;
    }

    private WrappedComponent createStartupPanel() {
        final JScrollPane sp = new JScrollPane(new ImageComponent(JarResources.getImage("intro_screen.jpg"), false));
        return new WrappedComponent(){

            @Override
            public JComponent getWrappedComponent() {
                return sp;
            }

            @Override
            public String getAssociatedTitle() {
                return "Home";
            }

            @Override
            public Icon getAssociatedIcon() {
                return null;
            }
        };
    }

    private JComponent createProcessForToolBar() {
        TaskManager tm = TaskManager.getInstance();
        final JTable taskTable = tm.createTable();
        tm.setOnClickShowResultsInBrowserOnly(true);
        JScrollPane sp = new JScrollPane(taskTable);
        sp.setPreferredSize(new Dimension(200, 350));
        final JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)new JLabel("<html><body>Processes: click 'status' field for results</body></html>"), "North");
        leftPanel.setBackground(Color.LIGHT_GRAY);
        leftPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                leftPanel.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                leftPanel.setCursor(Cursor.getDefaultCursor());
            }
        });
        taskTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                taskTable.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                taskTable.setCursor(Cursor.getDefaultCursor());
            }
        });
        leftPanel.setBorder(BorderFactory.createTitledBorder("GSEA reports"));
        leftPanel.add((Component)sp, "Center");
        JideButton but = new JideButton("Show results folder");
        but.setAction((Action)new ShowDefaultOutputDirAction("Show results folder"));
        but.setRolloverEnabled(true);
        but.setBorderPainted(false);
        but.setButtonStyle(3);
        leftPanel.add((Component)but, "South");
        return leftPanel;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        menuBar.add(this.createJMenu("File", new Object[]{new GseaPreferencesAction(), null, new ClearFileHistoryAction(), null, SystemUtils.IS_OS_MAC_OSX ? null : new MyExitAction()}));
        menuBar.add(this.createJMenu("Downloads", new Object[]{new BrowserAction("Download chip annotations", "Download array annotation files - useful to annotate GSEA reports", null, GseaWebResources.getArrayAnnotationsURL()), new BrowserAction("Download example datasets", "Download example datasets for GSEA - expression data, phenotype labels and gene sets files", null, GseaWebResources.getGseaExamplesURL())}));
        menuBar.add(this.createJMenu("Help", new Object[]{new BrowserAction("GSEA web site", "Open the GSEA website in a web browser", GuiHelper.ICON_HELP16, GseaWebResources.getGseaBaseURL()), new BrowserAction("GSEA documentation", "Online documentation of the GSEA algorithm and software", GuiHelper.ICON_HELP16, GseaWebResources.getGseaHelpURL()), new BrowserAction("GSEA & MSigDB License Terms", "GSEA & MSigDB License Terms", GuiHelper.ICON_HELP16, GseaWebResources.getGseaBaseURL() + "/license_terms_list.jsp"), null, new ShowAppRuntimeHomeDirAction("Show GSEA home folder"), new ShowDefaultOutputDirAction("Show GSEA output folder (default location)"), null, new BrowserAction("Contact Us", "Contact Us", null, GseaWebResources.getGseaContactURL()), null, this.formatBuildInfoForHelp(), this.formatBuildTimestampForHelp()}));
        return menuBar;
    }

    private String formatBuildInfoForHelp() {
        String buildVer = buildProps.getProperty("build.version");
        String buildNum = buildProps.getProperty("build.number");
        String buildInfo = "GSEA v" + buildVer + " [build: " + buildNum + "]";
        return buildInfo;
    }

    private String formatBuildTimestampForHelp() {
        String buildTS = buildProps.getProperty("build.timestamp");
        if (StringUtils.isBlank((CharSequence)buildTS)) {
            return null;
        }
        return "Built: " + buildTS;
    }

    private JMenu createJMenu(String name, Object[] objs) {
        JMenu menu = new JMenu(name, true);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) {
                menu.addSeparator();
                continue;
            }
            if (objs[i] instanceof JMenuItem) {
                menu.add((JMenuItem)objs[i]);
                continue;
            }
            if (objs[i] instanceof String) {
                menu.add(objs[i].toString());
                continue;
            }
            menu.add(new JMenuItem((Action)objs[i]));
        }
        return menu;
    }

    public void exitApplication() {
        boolean res;
        boolean ask = XPreferencesFactory.kAskBeforeAppShutdown.getBoolean();
        if (ask && !(res = this.getWindowManager().showConfirm("Exit the application?"))) {
            return;
        }
        this.fFrame.removeWindowListener(this.fWindowListener);
        this.fWindowListener = null;
        if (this.fFrame.getDockingManager() != null) {
            this.fFrame.getDockingManager().saveLayoutData();
        }
        this.fFrame.dispose();
        this.fFrame = null;
        if (!Conf.isDebugMode()) {
            Conf.exitSystem(false);
        }
    }

    public String getName() {
        return "GSEA";
    }

    @Override
    public ToolManager getToolManager() {
        if (this.fToolManager == null) {
            this.fToolManager = new ToolManagerImpl();
        }
        return this.fToolManager;
    }

    @Override
    public FileManager getFileManager() {
        if (this.fFileManager == null) {
            this.fFileManager = new FileManagerImpl();
        }
        return this.fFileManager;
    }

    @Override
    public VdbManager getVdbManager() {
        return fVdbmanager;
    }

    @Override
    public WindowManager getWindowManager() throws HeadlessException {
        return this.fWindowManager;
    }

    @Override
    public StatusBarAppender getStatusBarAppender() {
        return this.fStatusBarAppender;
    }

    static {
        System.setProperty("GSEA", Boolean.TRUE.toString());
        if (StringUtils.isBlank((CharSequence)buildProps.getProperty("build.version"))) {
            buildProps.setProperty("build.version", "[NO BUILD VERSION FOUND]");
        }
        if (StringUtils.isBlank((CharSequence)buildProps.getProperty("build.number"))) {
            buildProps.setProperty("build.number", "Error loading build.properties!");
        }
        USER_VISIBLE_FRAME_TITLE = "GSEA " + buildProps.getProperty("build.version") + " (Gene set enrichment analysis)";
        ICON = JarResources.getImage("icon_16x16.png");
        PREF_ICON = JarResources.getIcon("Preferences16.gif");
        fVdbmanager = new VdbManagerForGsea(RPT_CACHE_BUILD_DATE);
    }

    class MyExitAction
    extends XAction {
        public MyExitAction() {
            super("ExitAction", "Exit", "Quit the GSEA application");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            GseaFijiTabsApplicationFrame.this.exitApplication();
        }
    }

    class MyWindowManagerImplJideTabbedPane
    extends WindowManagerImplJideTabbedPane {
        MyWindowManagerImplJideTabbedPane() {
            super((JFrame)((Object)GseaFijiTabsApplicationFrame.this.fFrame));
        }

        @Override
        public JPopupMenu createPopupMenu(Object obj) {
            return GseaActionRegistry.getInstance().createPopup(obj);
        }

        @Override
        public boolean runDefaultAction(Object obj) {
            return GseaActionRegistry.getInstance().runDefaultAction(obj);
        }
    }

    class GseaPreferencesAction
    extends AbstractAction {
        private JCheckBoxMenuItem fAsk;
        private JCheckBoxMenuItem fOnline;
        private JCheckBoxMenuItem fMedian;
        private JCheckBoxMenuItem fFix;
        private JCheckBoxMenuItem fBiased;

        public GseaPreferencesAction() {
            this.putValue("Name", this.getName());
            this.putValue("SmallIcon", this.getAssociatedIcon());
            this.putValue("ShortDescription", this.getDescription());
            this.fAsk = XPreferencesFactory.createCheckBoxMenuItem(XPreferencesFactory.kAskBeforeAppShutdown);
            this.fOnline = XPreferencesFactory.createCheckBoxMenuItem(XPreferencesFactory.kOnlineMode);
            this.fMedian = XPreferencesFactory.createCheckBoxMenuItem(XPreferencesFactory.kMedian);
            this.fFix = XPreferencesFactory.createCheckBoxMenuItem(XPreferencesFactory.kFixLowVar);
            this.fBiased = XPreferencesFactory.createCheckBoxMenuItem(XPreferencesFactory.kBiasedVar);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            GseaPreferencesDialog opt = new GseaPreferencesDialog((Frame)((Object)GseaFijiTabsApplicationFrame.this.fFrame), "Preferences");
            opt.pack();
            JideSwingUtilities.globalCenterWindow((Window)((Object)opt));
            opt.setVisible(true);
            if (this.fAsk != null) {
                this.fAsk.setSelected(XPreferencesFactory.kAskBeforeAppShutdown.getBoolean());
                this.fOnline.setSelected(XPreferencesFactory.kOnlineMode.getBoolean());
                this.fMedian.setSelected(XPreferencesFactory.kMedian.getBoolean());
                this.fFix.setSelected(XPreferencesFactory.kFixLowVar.getBoolean());
                this.fBiased.setSelected(XPreferencesFactory.kBiasedVar.getBoolean());
            }
        }

        public String getName() {
            return "Preferences ...";
        }

        public Icon getAssociatedIcon() {
            return PREF_ICON;
        }

        public String getDescription() {
            return "View and modify application wide preferences";
        }
    }

    class ClearFileHistoryAction
    extends XAction {
        public ClearFileHistoryAction() {
            super("ClearAction", "Clear recent file history", "Clear recent file history (from the 'Load Data' panel)");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean res = Application.getWindowManager().showConfirm("Clear file history", "Are you sure you want to erase all file history");
            if (res) {
                Application.getFileManager().getRecentFilesStore().clearAll();
                if (GseaFijiTabsApplicationFrame.this.fAppDataLoaderAction != null) {
                    GseaFijiTabsApplicationFrame.this.fAppDataLoaderAction.getWidget();
                }
            }
        }
    }
}

