/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io;

import edu.mit.broad.genome.StandardException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.genepattern.heatmap.image.HeatMap;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ImageUtil {
    private static final Logger klog = Logger.getLogger(ImageUtil.class);
    private static final Set<String> NON_JPG_IMG_FORMAT_EXTS = new HashSet<String>(Arrays.asList("png", "svg"));
    private static final Set<String> JPG_FORMAT_EXTS = new HashSet<String>(Arrays.asList("jpg", "jpeg"));

    private ImageUtil() {
    }

    private static final File saveImage(BufferedImage bi, File outputFile, String format) {
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)"svg", (CharSequence)format)) {
                throw new IllegalArgumentException("No SVG support for saving a BufferedImage.");
            }
            ImageIO.write((RenderedImage)bi, format, outputFile);
            return outputFile;
        }
        catch (Throwable t) {
            String errMsg = "An error occurred while saving the image '" + outputFile.getName() + "'";
            klog.error((Object)errMsg, t);
            throw new StandardException(errMsg, t, 9002);
        }
    }

    public static final File savePlotImage(ChartPanel plot, File outputFile, String format) throws IOException {
        return ImageUtil.coreSavePlotImage(plot, outputFile, format, false);
    }

    public static final File saveReportPlotImage(ChartPanel plot, File outputFile, String format) throws IOException {
        return ImageUtil.coreSavePlotImage(plot, outputFile, format, true);
    }

    private static File coreSavePlotImage(ChartPanel plot, File outputFile, String format, boolean gZipSvg) throws IOException {
        outputFile = ImageUtil.correctImageExtensionIfNecessary(outputFile, format, gZipSvg);
        if (StringUtils.equalsIgnoreCase((CharSequence)"svg", (CharSequence)format)) {
            Dimension prefSize = plot.getPreferredSize();
            return ImageUtil.saveAsSVG(plot.getChart(), outputFile, prefSize.width, prefSize.height, gZipSvg);
        }
        return ImageUtil.saveImage(ImageUtil.createImage(plot), outputFile, format);
    }

    public static final File savePlotImage(HeatMap heatMap, File outputFile, String format) throws IOException {
        return ImageUtil.coreSavePlotImage(heatMap, outputFile, format, false);
    }

    public static final File saveReportPlotImage(HeatMap heatMap, File outputFile, String format) throws IOException {
        return ImageUtil.coreSavePlotImage(heatMap, outputFile, format, true);
    }

    private static File coreSavePlotImage(HeatMap heatMap, File outputFile, String format, boolean gZipSvgs) throws IOException {
        outputFile = ImageUtil.correctImageExtensionIfNecessary(outputFile, format, gZipSvgs);
        if (StringUtils.equalsIgnoreCase((CharSequence)"svg", (CharSequence)format)) {
            return ImageUtil.saveAsSVG(heatMap, outputFile, gZipSvgs);
        }
        return ImageUtil.saveImage(heatMap.snapshot(), outputFile, format);
    }

    public static final File saveAsSVG(JFreeChart chart, File outputFile, int width, int height, boolean gZip) throws IOException {
        outputFile = ImageUtil.ensureGzipExtIfNecessary(outputFile, gZip);
        SVGGraphics2D svgGenerator = ImageUtil.setupSVGGenerator(outputFile, gZip, width, height);
        ImageUtil.drawChartPlot(chart, (Graphics2D)svgGenerator, width, height);
        return ImageUtil.streamToSvg(svgGenerator, outputFile, gZip);
    }

    private static final File saveAsSVG(HeatMap heatMap, File outputFile, boolean gZip) throws IOException {
        outputFile = ImageUtil.ensureGzipExtIfNecessary(outputFile, gZip);
        int height = heatMap.getHeightWithHeader();
        int width = heatMap.getContentWidth();
        SVGGraphics2D svgGenerator = ImageUtil.setupSVGGenerator(outputFile, gZip, width, height);
        heatMap.drawSnapshot((Graphics2D)svgGenerator);
        return ImageUtil.streamToSvg(svgGenerator, outputFile, gZip);
    }

    private static final File ensureGzipExtIfNecessary(File outputFile, boolean gZip) {
        if (gZip && !StringUtils.endsWithIgnoreCase((CharSequence)outputFile.getName(), (CharSequence)".gz")) {
            outputFile = ImageUtil.getSvgFileFromImgFile(outputFile, true);
        }
        return outputFile;
    }

    private static final SVGGraphics2D setupSVGGenerator(File outputFile, boolean gZip, int width, int height) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.setSVGCanvasSize(new Dimension(width, height));
        return svgGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File streamToSvg(SVGGraphics2D svgGenerator, File outputFile, boolean gZip) throws IOException {
        Writer out = null;
        try {
            boolean useCSS = true;
            OutputStream outputStream = gZip ? new GZIPOutputStream(new FileOutputStream(outputFile)) : new FileOutputStream(outputFile);
            out = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            svgGenerator.stream(out, useCSS);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    klog.error((Object)"Error closing svg file", (Throwable)e);
                }
            }
        }
        return outputFile;
    }

    private static final void drawChartPlot(JFreeChart chart, Graphics2D graphics, int width, int height) {
        Rectangle rectangle = new Rectangle(width, height);
        chart.draw(graphics, (Rectangle2D)rectangle);
    }

    private static final BufferedImage createImage(ChartPanel plot) {
        Dimension prefSize = plot.getPreferredSize();
        BufferedImage bufferedImage = new BufferedImage(prefSize.width, prefSize.height, 5);
        Graphics2D graphics = bufferedImage.createGraphics();
        ImageUtil.drawChartPlot(plot.getChart(), graphics, prefSize.width, prefSize.height);
        graphics.dispose();
        return bufferedImage;
    }

    public static final File correctImageExtensionIfNecessary(File outputFile, String format, boolean gZipSvgs) {
        format = StringUtils.lowerCase((String)format);
        String outputFileName = outputFile.getName();
        String ext = FilenameUtils.getExtension((String)outputFileName).toLowerCase();
        String compExt = "";
        if (gZipSvgs && StringUtils.equals((CharSequence)format, (CharSequence)"svg") && StringUtils.equals((CharSequence)ext, (CharSequence)"gz")) {
            compExt = ".gz";
            String baseName = FilenameUtils.getBaseName((String)outputFileName);
            ext = FilenameUtils.getExtension((String)baseName);
        }
        if (NON_JPG_IMG_FORMAT_EXTS.contains(format)) {
            if (!StringUtils.equals((CharSequence)format, (CharSequence)ext)) {
                return new File(outputFile.getParentFile(), outputFileName + "." + format + compExt);
            }
        } else if (JPG_FORMAT_EXTS.contains(format)) {
            if (!JPG_FORMAT_EXTS.contains(ext)) {
                return new File(outputFile.getParentFile(), outputFileName + ".jpg");
            }
        } else {
            throw new IllegalArgumentException("Unknown output file format '" + format + "'");
        }
        return outputFile;
    }

    public static final File getSvgFileFromImgFile(File imgFile, boolean gZip) {
        String baseName = FilenameUtils.getBaseName((String)imgFile.getName());
        String ext = gZip ? ".svg.gz" : ".svg";
        return new File(imgFile.getParent(), baseName + ext);
    }
}

