/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.ColorScheme;

public class GradientColorScheme
implements ColorScheme {
    double min;
    double max;
    double mid;
    private IExpressionData data;
    private BufferedImage posImage;
    private BufferedImage negImage;
    boolean useDoubleGradient = true;

    public GradientColorScheme(double min, double max, double mid, Color posColor, Color negColor, Color neutralColor) {
        this.min = min;
        this.max = max;
        this.mid = mid;
        this.posImage = this.createGradientImage(neutralColor, posColor);
        this.negImage = this.createGradientImage(negColor, neutralColor);
    }

    private BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = new BufferedImage(256, 1, 5);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        graphics.dispose();
        return image;
    }

    public void setUseDoubleGradient(boolean useDoubleGradient) {
        this.useDoubleGradient = useDoubleGradient;
    }

    @Override
    public Color getColor(int row, int column) {
        int rgb;
        double value = this.data.getValue(row, column);
        if (this.useDoubleGradient) {
            double maximum = value < this.mid ? this.min : this.max;
            int colorIndex = (int)(255.0 * (value - this.mid) / (maximum - this.mid));
            colorIndex = colorIndex > 255 ? 255 : colorIndex;
            rgb = value < this.mid ? this.negImage.getRGB(255 - colorIndex, 0) : this.posImage.getRGB(colorIndex, 0);
        } else {
            double span = this.max - this.min;
            int colorIndex = 0;
            colorIndex = value <= this.min ? 0 : (value >= this.max ? 255 : (int)((value - this.min) / span * 255.0));
            rgb = this.posImage.getRGB(colorIndex, 0);
        }
        return new Color(rgb);
    }

    @Override
    public void setDataset(IExpressionData d) {
        this.data = d;
    }

    @Override
    public Component getLegend() {
        return new Legend(this.min, this.mid, this.max, this.negImage, this.posImage, this.useDoubleGradient);
    }

    private static class Legend
    extends JPanel {
        private Insets insets;
        private int height = 15;
        BufferedImage negColorImage;
        BufferedImage posColorImage;
        boolean isAntiAliasing;
        private boolean useDoubleGradient = true;
        private double minValue;
        private double midValue;
        private double maxValue;

        public Legend(double min, double mid, double max, BufferedImage negativeImage, BufferedImage positiveImage, boolean useDoubleGradient) {
            this.minValue = min;
            this.midValue = mid;
            this.maxValue = max;
            this.negColorImage = negativeImage;
            this.posColorImage = positiveImage;
            this.setBackground(Color.white);
            this.insets = new Insets(0, 0, 0, 0);
            this.setPreferredSize(new Dimension(120, 40));
            this.useDoubleGradient = useDoubleGradient;
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            Graphics2D g = (Graphics2D)g1D;
            int width = this.getWidth();
            if (this.useDoubleGradient) {
                g.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)width / 2.0f), this.height, null);
                g.drawImage(this.posColorImage, (int)((float)width / 2.0f) + this.insets.left, 0, (int)((double)width / 2.0), this.height, null);
            } else {
                g.drawImage(this.posColorImage, this.insets.left, 0, width, this.height, null);
            }
            FontMetrics hfm = g.getFontMetrics();
            int fHeight = hfm.getHeight();
            g.setColor(Color.black);
            if (this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            g.drawString(String.valueOf(this.minValue), this.insets.left, this.height + fHeight);
            int textWidth = hfm.stringWidth(String.valueOf(this.midValue));
            if (this.useDoubleGradient) {
                g.drawString(String.valueOf(this.midValue), (int)((float)width / 2.0f) - textWidth / 2 + this.insets.left, this.height + fHeight);
            }
            textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
            g.drawString(String.valueOf(this.maxValue), width - textWidth + this.insets.left, this.height + fHeight);
        }
    }
}

