/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GPWrappers;
import java.util.Arrays;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.IExpressionDataUtil;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class HCLAlgorithm {
    private static final String AVERAGE_LINKAGE = "0";
    private static final String SINGLE_LINKAGE = "-1";
    private static final String PEARSON = "1";
    private int[] genes_order;
    private int[] samples_order;

    public static Dataset cluster(Dataset ds) {
        IExpressionData expressionData = GPWrappers.createIExpressionData(ds);
        try {
            HCLAlgorithm alg = new HCLAlgorithm(expressionData);
            IExpressionData ied = IExpressionDataUtil.sliceView(expressionData, alg.getGenes_order(), alg.getSamples_order());
            return GPWrappers.createDataset(ied, ds.getAnnot());
        }
        catch (AlgorithmException e) {
            throw new StandardException("Unexpected issue while clustering", e, 9001);
        }
    }

    public HCLAlgorithm(IExpressionData expressionData) throws AlgorithmException {
        FloatMatrix inputMatrix = new FloatMatrix(expressionData.getRowCount(), expressionData.getColumnCount());
        int rows = expressionData.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int cols = expressionData.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                inputMatrix.set(i, j, (float)expressionData.getValue(i, j));
            }
        }
        HCL hclRows = new HCL();
        AlgorithmData rowData = new AlgorithmData();
        rowData.addMatrix("experiment", inputMatrix);
        rowData.addParam("distance-function", PEARSON);
        rowData.addParam("distance-absolute", "false");
        rowData.addParam("calculate-genes", "true");
        rowData.addParam("method-linkage", SINGLE_LINKAGE);
        AlgorithmData genesResult = hclRows.execute(rowData);
        int[] genes_child_1_array = genesResult.getIntArray("child-1-array");
        int[] genes_child_2_array = genesResult.getIntArray("child-2-array");
        int[] genes_node_order = genesResult.getIntArray("node-order");
        this.genes_order = this.getLeafOrder(genes_node_order, genes_child_1_array, genes_child_2_array, null);
        HCL hclCols = new HCL();
        AlgorithmData colData = new AlgorithmData();
        colData.addMatrix("experiment", inputMatrix);
        colData.addParam("distance-function", PEARSON);
        colData.addParam("distance-absolute", "false");
        colData.addParam("calculate-genes", "false");
        colData.addParam("method-linkage", AVERAGE_LINKAGE);
        AlgorithmData samplesResult = hclCols.execute(colData);
        int[] samples_child_1_array = samplesResult.getIntArray("child-1-array");
        int[] samples_child_2_array = samplesResult.getIntArray("child-2-array");
        int[] samples_node_order = samplesResult.getIntArray("node-order");
        this.samples_order = this.getLeafOrder(samples_node_order, samples_child_1_array, samples_child_2_array, null);
    }

    public int[] getGenes_order() {
        return this.genes_order;
    }

    public int[] getSamples_order() {
        return this.samples_order;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }
}

