/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.models.ReportModel;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.utils.DateUtils;
import edu.mit.broad.xbench.ComparatorFactory2;
import edu.mit.broad.xbench.tui.ReportStub;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import xtools.api.Tool;
import xtools.api.ToolCategory;

public class ToolSelectorTree
extends JTree {
    private final Tool[] fTools = new Tool[0];
    private final Logger log = Logger.getLogger(ToolSelectorTree.class);
    private final DefaultTreeModel fModel;
    private final Map fToolNodeMap;

    public ToolSelectorTree() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(1);
        this.setSelectionModel(sm);
        this.fToolNodeMap = new HashMap();
        this.fModel = new Model();
        this.setModel(this.fModel);
        this.setCellRenderer(new Renderer());
    }

    public Tool selectTool(String toolName) {
        if (toolName == null) {
            return null;
        }
        for (int i = 0; i < this.fTools.length; ++i) {
            if (!this.fTools[i].getClass().getName().equalsIgnoreCase(toolName)) continue;
            TreePath tp = this.getPath(this.fTools[i]);
            this.setSelectionPath(tp);
            this.expandPath(tp);
            this.fireTreeExpanded(tp);
            this.revalidate();
            return this.fTools[i];
        }
        this.log.debug((Object)("Unknown tool name, and could not select it: " + toolName));
        return null;
    }

    public Component getComponent() {
        return this;
    }

    public TreePath getPath(Tool tool) {
        Object[] tns;
        Object obj = this.fToolNodeMap.get(tool);
        if (obj == null) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.fModel.getRoot();
            tns = this.fModel.getPathToRoot(rootNode);
        } else {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)obj;
            tns = this.fModel.getPathToRoot(dmtn);
        }
        return new TreePath(tns);
    }

    public static class Renderer
    extends DefaultTreeCellRenderer {
        private static final Icon ICON_RPT_SMALL = JarResources.getIcon("Rpt15.png");

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                Object node = ((DefaultMutableTreeNode)value).getUserObject();
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                this.setFont(GuiHelper.FONT_DEFAULT);
                if (node instanceof ToolCategory) {
                    this.setFont(GuiHelper.FONT_DEFAULT_BOLD);
                    this.setBorder(null);
                    this.setText(((ToolCategory)node).getName());
                    this.setToolTipText(((ToolCategory)node).getDesc());
                    this.setIcon(((ToolCategory)node).getIcon());
                } else if (node instanceof Tool) {
                    StringTokenizer tok = new StringTokenizer(((Tool)node).getClass().getName(), ".");
                    String name = null;
                    while (tok.hasMoreTokens()) {
                        name = tok.nextToken();
                    }
                    this.setText(name);
                    this.setIcon(Tool.ICON);
                    this.setToolTipText(((Tool)node).getDesc());
                } else if (node instanceof Report) {
                    Report rpt = (Report)node;
                    this.prettyFormat(rpt, (JLabel)this);
                    this.setToolTipText(rpt.getQuickInfo());
                } else if (node instanceof ReportStub) {
                    ReportStub stub = (ReportStub)node;
                    this.prettyFormat(stub, (JLabel)this);
                } else {
                    this.setBorder(null);
                    this.setText(value.toString());
                }
            } else {
                this.setText("Unknown: " + value);
            }
            return this;
        }

        private void prettyFormat(ReportStub stub, JLabel label) {
            StringBuffer buf = new StringBuffer("<html><body>");
            buf.append(stub.getName_without_ts());
            buf.append("<font color=gray>");
            buf.append('[').append(DateUtils.formatAsHourMin(stub.getDate())).append(']');
            buf.append("</font>");
            buf.append("</body></html>");
            label.setIcon(ICON_RPT_SMALL);
            label.setText(buf.toString());
            label.setBorder(null);
        }

        private void prettyFormat(Report rpt, JLabel label) {
            StringBuffer buf = new StringBuffer("<html><body>");
            buf.append(rpt.getName());
            buf.append("<font color=gray>");
            buf.append('[').append(DateUtils.formatAsHourMin(rpt.getDate())).append("min").append(']');
            buf.append("</font>");
            buf.append("</body></html>");
            label.setIcon(ICON_RPT_SMALL);
            label.setText(buf.toString());
            label.setBorder(null);
        }
    }

    private class Model
    extends DefaultTreeModel {
        Model() {
            super(new DefaultMutableTreeNode("Tools", true));
            DefaultMutableTreeNode toolNode = (DefaultMutableTreeNode)this.getRoot();
            TreeMap categoryMap = new TreeMap(new ComparatorFactory2.ToolCategoryComparator());
            for (int i = 0; i < ToolSelectorTree.this.fTools.length; ++i) {
                ToolCategory category = ToolSelectorTree.this.fTools[i].getCategory();
                if (!categoryMap.containsKey(category)) {
                    categoryMap.put(category, new ArrayList());
                }
                List list = (List)categoryMap.get(category);
                list.add(ToolSelectorTree.this.fTools[i]);
            }
            for (ToolCategory category : categoryMap.keySet()) {
                List tools = (List)categoryMap.get(category);
                DefaultMutableTreeNode cnode = new DefaultMutableTreeNode(category, true);
                for (int i = 0; i < tools.size(); ++i) {
                    DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(tools.get(i), false);
                    cnode.add(dmtn);
                    ToolSelectorTree.this.fToolNodeMap.put(tools.get(i), dmtn);
                }
                toolNode.add(cnode);
            }
            toolNode.add(new ReportModel().createReportNode(this));
        }
    }
}

