/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.objmgr;

import edu.mit.broad.genome.io.FileTransferable;
import edu.mit.broad.genome.io.PobTransferable;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.dnd.DndSource;
import edu.mit.broad.genome.swing.dnd.DragSourceDecorator;
import edu.mit.broad.xbench.actions.misc_actions.CopyFilesAction;
import edu.mit.broad.xbench.actions.misc_actions.FilesSelectable;
import edu.mit.broad.xbench.explorer.objmgr.ObjectTreePopup;
import edu.mit.broad.xbench.explorer.objmgr.ObjectTreeRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ObjectTree
extends JTree
implements DndSource,
FilesSelectable {
    private static final Logger klog = Logger.getLogger(ObjectTree.class);

    public ObjectTree() {
        this.setToolTipText("Anything but null");
        this.setModel(ParserFactory.getCache().createTreeModel());
        this.setCellRenderer(new ObjectTreeRenderer());
        TitledBorder b = BorderFactory.createTitledBorder(null, "Double click to open, right click for more options", 0, 2, new Font("Helvetica", 0, 10), Color.GRAY);
        this.setBorder(b);
        this.addMouseListener(new ObjectTreePopup(this));
        this.getSelectionModel().setSelectionMode(4);
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.expandAll();
        new DragSourceDecorator(this);
        CopyFilesAction ca = new CopyFilesAction(this);
        this.addKeyListener(ca.createCtrlCKeyListener());
    }

    private void expandAll() {
        try {
            TreePath path = this.getPathForRow(0);
            if (path == null) {
                return;
            }
            GuiHelper.Tree.expandAll(this, path);
        }
        catch (Throwable t) {
            klog.warn((Object)"develop error -- ignoring", t);
        }
    }

    @Override
    public Transferable getTransferable() {
        PersistentObject[] pobs = this.getSelectedPobs();
        if (pobs != null) {
            return new PobTransferable(pobs);
        }
        return null;
    }

    @Override
    public Component getDraggableComponent() {
        return this;
    }

    private PersistentObject[] getSelectedPobs() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<Object> pobs = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            Object userobj;
            DefaultMutableTreeNode dmtr;
            Object obj = paths[i].getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode) || (dmtr = (DefaultMutableTreeNode)obj).getAllowsChildren() || !((userobj = dmtr.getUserObject()) instanceof PersistentObject)) continue;
            pobs.add(userobj);
        }
        return pobs.toArray(new PersistentObject[pobs.size()]);
    }

    @Override
    public FileTransferable getSelectedFiles() {
        return new FileTransferable(this.getTheSelectedFiles());
    }

    private File[] getTheSelectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        PersistentObject[] pobs = this.getSelectedPobs();
        for (int i = 0; i < pobs.length; ++i) {
            File file = ParserFactory.getCache().getSourceFile(pobs[i]);
            if (file == null) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }
}

