/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.filemgr;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.io.FileTransferable;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserWorker;
import edu.mit.broad.genome.swing.GPopupChecker;
import edu.mit.broad.genome.swing.GseaSimpleInternalFrame;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.dnd.DndSource;
import edu.mit.broad.genome.swing.dnd.DragSourceDecorator;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.xbench.actions.misc_actions.CopyFilesAction;
import edu.mit.broad.xbench.actions.misc_actions.FilesSelectable;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class JRecentFilesList
extends JList
implements DndSource,
FilesSelectable {
    private final Logger log = Logger.getLogger(JRecentFilesList.class);
    private JRecentFilesList fInstance = this;
    public static final String DEFAULT_TITLE = "Recent files";
    public static final Icon ICON = JarResources.getIcon("History24.gif");
    private static final Font kFont = new Font("Arial", 0, 12);
    private CopyFilePathAction fCopyAction;
    private PurgeAllFilesPathAction fPurgeAllAction;

    public static JComponent createComponent(String title) {
        JRecentFilesList recentFiles = new JRecentFilesList();
        JScrollPane sp = new JScrollPane(recentFiles);
        GseaSimpleInternalFrame sif = new GseaSimpleInternalFrame(title);
        sif.add(sp);
        return sif;
    }

    public JRecentFilesList() {
        this.setModel(Application.getFileManager().getRecentFilesStore());
        this.setSelectionMode(2);
        this.fCopyAction = new CopyFilePathAction();
        this.fPurgeAllAction = new PurgeAllFilesPathAction();
        this.setCellRenderer(new ListCellRenderer());
        this.setBackground(GuiHelper.COLOR_VERY_LIGHT_GRAY);
        new DragSourceDecorator(this);
        CopyFilesAction cfa = new CopyFilesAction(this);
        this.addKeyListener(cfa.createCtrlCKeyListener());
    }

    @Override
    public FileTransferable getSelectedFiles() {
        return (FileTransferable)this.getTransferable();
    }

    public void refresh() {
    }

    @Override
    public Transferable getTransferable() {
        Object[] objs = this.fInstance.getSelectedValues();
        if (objs == null || objs.length == 0) {
            return new FileTransferable(new File[0]);
        }
        File[] files = new File[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            files[i] = new File(objs[i].toString());
        }
        return new FileTransferable(files);
    }

    @Override
    public Component getDraggableComponent() {
        return this;
    }

    static class ImportFilesAction
    extends AbstractAction {
        File[] files;

        ImportFilesAction(File[] files) {
            this.files = files;
            this.putValue("Name", "Import data from selected " + files.length + " files");
            this.putValue("ShortDescription", "Import data from selected files");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new ParserWorker(this.files).execute();
        }
    }

    class PurgeAllFilesPathAction
    extends AbstractAction {
        PurgeAllFilesPathAction() {
            this.putValue("Name", "Purge All Files");
            this.putValue("SmallIcon", null);
            this.putValue("ShortDescription", "Copy File(s)");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean proceed = Application.getWindowManager().showConfirm("Delete file history?", "<html><body><b>This will remove recently used files from this list (but NOT delete the files themselves)</b></body></html>");
            if (proceed) {
                Application.getFileManager().getRecentFilesStore().clearAll();
                JRecentFilesList.this.fInstance.refresh();
            }
        }
    }

    class CopyFilePathAction
    extends AbstractAction {
        CopyFilePathAction() {
            this.putValue("Name", "Copy File(s)");
            this.putValue("SmallIcon", JarResources.getIcon("Copy16.gif"));
            this.putValue("ShortDescription", "Copy File(s)");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Transferable t = JRecentFilesList.this.getTransferable();
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(t, (ClipboardOwner)((Object)t));
        }
    }

    class MyPopupMouseListener
    extends GPopupChecker {
        MyPopupMouseListener() {
        }

        @Override
        protected void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Object[] sel = JRecentFilesList.this.fInstance.getSelectedValues();
                if (sel == null) {
                    return;
                }
                JPopupMenu popup = null;
                JRecentFilesList.this.log.debug((Object)(">> sel = " + sel.length));
                if (sel.length > 1) {
                    popup = new JPopupMenu();
                    File[] files = new File[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        files[i] = new File(sel[i].toString());
                    }
                    popup.add(new ImportFilesAction(files));
                } else if (sel.length == 1) {
                    popup = Application.getWindowManager().createPopupMenu(new File(sel[0].toString()));
                }
                if (popup != null) {
                    popup.add(new JSeparator());
                    popup.add(JRecentFilesList.this.fCopyAction);
                    popup.add(new JSeparator());
                    popup.add(JRecentFilesList.this.fPurgeAllAction);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    class ListCellRenderer
    extends DefaultListCellRenderer {
        public ListCellRenderer() {
            JRecentFilesList.this.fInstance.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        if (JRecentFilesList.this.fInstance.getSelectedValue() == null) {
                            return;
                        }
                        File file = new File(JRecentFilesList.this.fInstance.getSelectedValue().toString());
                        JRecentFilesList.this.log.info((Object)("Loading ... " + file.getPath()));
                        Application.getWindowManager().runDefaultAction(file);
                    }
                }
            });
            JRecentFilesList.this.fInstance.addMouseListener(new MyPopupMouseListener());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                File file = new File(value.toString());
                this.setText(FileUtils.shortenedPathRepresentation(file));
                this.setIcon(DataFormat.getIcon(file));
                this.setToolTipText(value.toString());
                this.setFont(kFont);
                if (!file.exists()) {
                    this.setForeground(Color.red);
                }
            }
            return this;
        }
    }
}

