/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.utils.ClassUtils;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.ToolManager;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import edu.mit.broad.xbench.tui.ReportStub;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import xtools.api.Tool;

public class ToolManagerImpl
implements ToolManager {
    private static final Logger klog = Logger.getLogger(ToolManagerImpl.class);
    private static Map kToolNameReporStubMap;

    @Override
    public String getLastToolName() {
        return XPreferencesFactory.kLastToolName.getString();
    }

    @Override
    public void setLastToolName(Tool tool) {
        XPreferencesFactory.kLastToolName.setValue(tool.getClass().getName());
    }

    @Override
    public ReportStub getLastReportStub(String toolName) {
        if (kToolNameReporStubMap == null) {
            kToolNameReporStubMap = new HashMap();
        }
        if (kToolNameReporStubMap.containsKey(toolName = ClassUtils.shorten(toolName))) {
            return (ReportStub)kToolNameReporStubMap.get(toolName);
        }
        File[] files = this._getReportFiles();
        File lastFile = null;
        for (int i = 0; i < files.length; ++i) {
            try {
                String name = NamingConventions.removeExtension(files[i]);
                if (name.indexOf(toolName) == -1) continue;
                if (lastFile == null) {
                    lastFile = files[i];
                    continue;
                }
                if (lastFile.lastModified() >= files[i].lastModified()) continue;
                lastFile = files[i];
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (lastFile != null) {
            ReportStub rs = new ReportStub(lastFile);
            kToolNameReporStubMap.put(toolName, rs);
            return rs;
        }
        return null;
    }

    @Override
    public ReportStub[] getReportsInCache() {
        File[] files = this._getReportFiles();
        ArrayList<ReportStub> reports = new ArrayList<ReportStub>();
        for (int i = 0; i < files.length; ++i) {
            try {
                ReportStub stub = new ReportStub(files[i]);
                reports.add(stub);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return reports.toArray(new ReportStub[reports.size()]);
    }

    private File[] _getReportFiles() {
        File dir = Application.getVdbManager().getReportsCacheDir();
        if (!dir.exists()) {
            klog.warn((Object)("Report cache: " + dir + " not found"));
            return new File[0];
        }
        return dir.listFiles(DataFormat.RPT_FORMAT.getFilenameFilter());
    }
}

