/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.RendererFactory2;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.FileManager;
import edu.mit.broad.xbench.core.api.XStore;
import edu.mit.broad.xbench.core.api.XStores;
import edu.mit.broad.xbench.explorer.filemgr.RecentDirsModel;
import edu.mit.broad.xbench.explorer.filemgr.XDirChooser;
import edu.mit.broad.xbench.explorer.filemgr.XDirChooserJideImpl;
import edu.mit.broad.xbench.explorer.filemgr.XFileChooser;
import edu.mit.broad.xbench.explorer.filemgr.XFileChooserImpl;
import java.awt.Component;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileManagerImpl
implements FileManager {
    private static final Logger klog = Logger.getLogger(FileManagerImpl.class);
    private XStore fRecentFilesStore_as_dirs;
    private XStore fRecentFilesStore_as_files;
    private XStore fRecentUrlsStore;
    private XStore fRecentDirsStore;
    public XDirChooser fDirChooser;
    private XFileChooserImpl fFileChooser;

    private void initFC() {
        if (this.fFileChooser == null) {
            RecentDirsModel model = new RecentDirsModel((ComboBoxModel)this.getRecentFilesStore_as_dirs(), new String[0]);
            JList<Object> jlRecent = new JList<Object>(model);
            jlRecent.setCellRenderer(new ListCellRenderer());
            this.fFileChooser = new XFileChooserImpl(jlRecent);
            ParserFactory.getCache().addPathAdditionsListener(new MyPropertyChangeListener());
        }
    }

    @Override
    public void registerRecentlyOpenedDir(File dir) {
        XStore xstore;
        if (dir != null && dir.isDirectory() && dir.exists() && !(xstore = this.getRecentDirsStore()).contains(dir.getPath())) {
            xstore.addAndSave(dir.getPath());
        }
    }

    @Override
    public void registerRecentlyOpenedFile(File file) {
        this.getRecentFilesStore().addAndSave(file.getPath());
    }

    @Override
    public void registerRecentlyOpenedURL(String url) {
        this.getRecentUrlsStore().addAndSave(url);
    }

    @Override
    public File[] getRecentDirs() {
        this.getRecentFilesStore();
        this.getRecentDirsStore();
        HashSet<File> dirs = new HashSet<File>();
        ArrayList lines = new ArrayList();
        lines.addAll(this.getRecentDirsStore().fLines);
        lines.addAll(this.getRecentFilesStore().fLines);
        klog.debug((Object)("# of lines: " + lines.size()));
        for (int i = 0; i < lines.size(); ++i) {
            File file;
            Object obj = lines.get(i);
            if (obj == null || !(file = new File(obj.toString())).exists()) continue;
            if (file.isFile()) {
                dirs.add(file.getParentFile());
                continue;
            }
            dirs.add(file);
        }
        return dirs.toArray(new File[dirs.size()]);
    }

    public File getLastDirAccesessed() {
        XStore xs = this.getRecentDirsStore();
        if (xs.getSize() == 0) {
            return null;
        }
        Object obj = xs.getElementAt(xs.getSize() - 1);
        if (obj != null) {
            return new File(obj.toString());
        }
        return null;
    }

    @Override
    public XFileChooser getFileChooser() throws HeadlessException {
        this.initFC();
        return this.fFileChooser;
    }

    @Override
    public XFileChooser getFileChooser(FileFilter[] filts) throws HeadlessException {
        this.initFC();
        return this.fFileChooser;
    }

    @Override
    public XDirChooser getDirChooser(String approveButtonTxt) {
        if (this.fDirChooser == null) {
            this.fDirChooser = new XDirChooserJideImpl();
            File lastDir = this.getLastDirAccesessed();
            if (lastDir != null && lastDir.exists()) {
                this.fDirChooser.setCurrentLocation(lastDir.getPath());
            }
        }
        this.fDirChooser.resetState();
        this.fDirChooser.setApproveButtonText(approveButtonTxt);
        return this.fDirChooser;
    }

    private XStore getRecentFilesStore_as_dirs() {
        if (this.fRecentFilesStore_as_dirs == null) {
            this.getRecentFilesStore();
            this.fRecentFilesStore_as_dirs = new XStores.DirPathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_files.txt"));
        }
        return this.fRecentFilesStore_as_dirs;
    }

    @Override
    public XStore getRecentFilesStore() {
        if (this.fRecentFilesStore_as_files == null) {
            this.fRecentFilesStore_as_files = new XStores.FilePathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_files.txt"));
            try {
                ArrayList<Object> rems = new ArrayList<Object>();
                for (int i = 0; i < this.fRecentFilesStore_as_files.getSize(); ++i) {
                    File f = new File(this.fRecentFilesStore_as_files.getElementAt(i).toString());
                    if (f.exists()) continue;
                    rems.add(this.fRecentFilesStore_as_files.getElementAt(i));
                }
                this.fRecentFilesStore_as_files.removeAndSave(rems);
                this.fRecentFilesStore_as_files.trim(30);
            }
            catch (Throwable t) {
                t.printStackTrace();
                klog.error((Object)("Recent file list initing error: " + t));
            }
        }
        return this.fRecentFilesStore_as_files;
    }

    public XStore getRecentDirsStore() {
        if (this.fRecentDirsStore == null) {
            this.fRecentDirsStore = new XStores.DirPathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_dirs.txt"));
            this.fRecentDirsStore.trim(50);
        }
        return this.fRecentDirsStore;
    }

    public XStore getRecentUrlsStore() {
        if (this.fRecentUrlsStore == null) {
            this.fRecentUrlsStore = new XStores.StringStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_urls.txt"));
            this.fRecentUrlsStore.trim(50);
        }
        return this.fRecentUrlsStore;
    }

    private static class ListCellRenderer
    extends RendererFactory2.CommonLookListRenderer {
        private static final Icon ICON = JarResources.getIcon("pinned_ovr.gif");

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            return this;
        }
    }

    class MyPropertyChangeListener
    implements PropertyChangeListener {
        MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object obj;
            if (evt.getPropertyName().equals("path_added") && (obj = evt.getNewValue()) != null) {
                File f = new File(obj.toString());
                Application.getFileManager().registerRecentlyOpenedFile(f);
            }
        }
    }
}

