/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.parsers.ParseUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CmdLineArgs {
    private static final Logger klog = Logger.getLogger(CmdLineArgs.class);

    public static String toString(String[] args) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i]).append(" ");
        }
        return buf.toString();
    }

    public static Properties parse(String[] args) {
        Properties prp = new Properties();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i]).append(" ");
        }
        String argline = buf.toString().trim();
        StringTokenizer tok = new StringTokenizer(argline, "-");
        HashSet<String> keyval = new HashSet<String>();
        while (tok.hasMoreElements()) {
            String kv = tok.nextToken();
            keyval.add(kv);
        }
        Iterator it = keyval.iterator();
        while (it.hasNext()) {
            String kv = it.next().toString();
            tok = new StringTokenizer(kv, " =");
            CmdLineArgs._fillParam(tok, kv, prp);
        }
        return prp;
    }

    private static void _fillParam(StringTokenizer tok, String origString, Properties prp) {
        List<String> tokens = ParseUtils.getUniqueTokens(tok);
        String param_name = null;
        Object param_val = null;
        if (tokens.size() == 1) {
            param_name = tokens.get(0).toString();
        } else if (tokens.size() == 2) {
            param_name = tokens.get(0).toString();
            param_val = tokens.get(1).toString();
        } else {
            klog.warn((Object)("More than 2 tokens for key-value pair >" + origString + "< " + tokens.size()));
            int num = tokens.size();
            param_name = tokens.get(0).toString();
            param_val = "";
            for (int i = 1; i < num; ++i) {
                param_val = (String)param_val + tokens.get(i) + " ";
            }
        }
        param_name = param_name.trim();
        if (param_val != null) {
            param_val = ((String)param_val).trim();
            prp.setProperty(param_name, (String)param_val);
        }
    }
}

