/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.dnd;

import edu.mit.broad.genome.swing.dnd.DndSource;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import org.apache.log4j.Logger;

public class DragSourceDecorator
implements DragGestureListener,
DragSourceListener {
    private final Logger log = Logger.getLogger(DragSourceDecorator.class);
    private DragSource fDragSource;
    private final int fDragAction = 3;
    private DndSource fSource;

    public DragSourceDecorator(DndSource source) {
        if (source == null) {
            throw new IllegalArgumentException("Param DndSource cannot be null");
        }
        this.fSource = source;
        this.fDragSource = DragSource.getDefaultDragSource();
        if (this.fSource.getDraggableComponent() == null) {
            this.log.warn((Object)("Null draggable component for: " + this.fSource));
        }
        this.fDragSource.createDefaultDragGestureRecognizer(this.fSource.getDraggableComponent(), this.fDragAction, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if ((e.getDragAction() & 3) == 0) {
            return;
        }
        try {
            Transferable trf = this.fSource.getTransferable();
            if (trf != null) {
                e.startDrag(DragSource.DefaultCopyNoDrop, trf, this);
            }
        }
        catch (InvalidDnDOperationException idoe) {
            this.log.error((Object)idoe);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        int myaction = e.getDropAction();
        if ((myaction & 3) != 0) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        context.setCursor(DragSource.DefaultCopyNoDrop);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        context.setCursor(DragSource.DefaultCopyNoDrop);
    }
}

