/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XComboChart;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.api.PicFile;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.genome.reports.pages.Page;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ecs.Document;
import org.apache.ecs.Element;
import org.apache.ecs.html.A;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.log4j.Logger;
import org.genepattern.heatmap.image.HeatMap;

public class HtmlPage
implements Page {
    private String fName;
    private String fTitle;
    private Document fDoc;
    private Logger log = Logger.getLogger(HtmlPage.class);
    private int fPicCnt = 1;
    private List<PicFile> fPicFiles;
    boolean sectionStarted = false;

    public HtmlPage(String name, String title) {
        this.fTitle = title;
        this.fName = name;
        this.fPicFiles = new ArrayList<PicFile>();
        this.fDoc = new Document();
        HtmlFormat.setCommonDocThings(this.fTitle, this.fDoc);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getExt() {
        return "html";
    }

    public Document getDoc() {
        return this.fDoc;
    }

    public void addError(String msg, Throwable t) {
        this.log.error((Object)msg, t);
        Div error = HtmlFormat.Divs.error();
        error.addElement(msg);
        error.addElement((Element)new BR());
        error.addElement(TraceUtils.getAsString(t));
        this.addBlock(error);
    }

    public void addError(String msg) {
        Div error = HtmlFormat.Divs.error();
        error.addElement(msg);
        this.addBlock(error);
    }

    public void addBreak() {
        this.fDoc.appendBody((Element)new BR());
    }

    public void addChart(XChart xchart, int width, int height, File saveInDir, boolean createSvgs) {
        try {
            PicFile pf = new PicFile(xchart, width, height, this.fPicCnt++, saveInDir, createSvgs);
            this.fPicFiles.add(pf);
            this.addBlock(pf.createIMG());
        }
        catch (Throwable t) {
            this.addError("Trouble saving image", t);
        }
    }

    public void addChart(XComboChart combo, int width, int height, File saveInDir, boolean createSvgs) {
        this.addChart(combo.getCombinedChart(), width, height, saveInDir, createSvgs);
    }

    public void addHeatMap(String title, String caption, HeatMap heatMap, File saveInDir, boolean createSvgs) {
        try {
            PicFile pf = new PicFile(NamingConventions.createSafeFileName(title), title, caption, heatMap, this.fPicCnt++, saveInDir, createSvgs);
            this.fPicFiles.add(pf);
            this.addBlock(pf.createIMG());
        }
        catch (Throwable t) {
            this.addError("Trouble saving image", t);
        }
    }

    public void addBlock(Div div) {
        this.addBlock(div, true);
    }

    public void addBlock(Div div, boolean addBreakAfter) {
        this.fDoc.appendBody((Element)div);
        if (addBreakAfter) {
            this.fDoc.appendBody((Element)new BR());
        }
    }

    public void addTable(String title, KeyValTable keyValTable) {
        Table table = keyValTable.getTable();
        String stitle = this._noNull(title);
        table.addElement((Element)HtmlFormat.Titles.table(stitle));
        Div div = HtmlFormat.Divs.keyValTable();
        div.addElement((Element)table);
        this.addBlock(div);
    }

    public void addTable(String title, Table table) {
        Div div = HtmlFormat.Divs.dataTable();
        table.addElement((Element)HtmlFormat.Titles.table(title));
        div.addElement((Element)table);
        this.addBlock(div);
    }

    public void addTable(RichDataframe rdf, String plainTxtFileName, boolean showRowNameCol, boolean numberRows) {
        Table table = new Table();
        table.setBorder(1);
        int ncols = rdf.getNumCol();
        RichDataframe.MetaData metaData = rdf.getMetaData();
        if (numberRows) {
            ++ncols;
        }
        if (showRowNameCol) {
            ++ncols;
        }
        table.setCols(ncols);
        if (numberRows) {
            table.addElement((Element)HtmlFormat.THs.richTable(""));
        }
        if (showRowNameCol) {
            table.addElement((Element)HtmlFormat.THs.richTable("NAME"));
        }
        for (int c = 0; c < rdf.getNumCol(); ++c) {
            table.addElement((Element)HtmlFormat.THs.richTable(rdf.getColumnName(c)));
        }
        for (int r = 0; r < rdf.getNumRow(); ++r) {
            TR tr = new TR();
            if (numberRows) {
                tr.addElement((Element)HtmlFormat.TDs.lessen("" + (r + 1)));
            }
            if (showRowNameCol) {
                tr.addElement((Element)HtmlFormat._td(rdf.getRowName(r)));
            }
            for (int c = 0; c < rdf.getNumCol(); ++c) {
                TD td;
                Object obj = rdf.getElementObj(r, c);
                if (obj != null) {
                    String align;
                    String s = metaData != null ? metaData.adjustPrecision(obj, c).toString() : obj.toString();
                    td = HtmlFormat._td(s, rdf.getElementColor(r, c), rdf.getElementLink(r, c));
                    if (metaData != null && (align = metaData.getColumnAlignment(c)) != null) {
                        td.setAlign(align);
                    }
                } else {
                    td = new TD();
                }
                tr.addElement((Element)td);
            }
            table.addElement((Element)tr);
        }
        Object title_safe = "na";
        if (rdf.getMetaData() != null) {
            title_safe = this._noNull(rdf.getMetaData().getTitle());
        }
        if (plainTxtFileName != null) {
            A a = new A(plainTxtFileName, "[plain text format]");
            title_safe = (String)title_safe + "&nbsp" + a.toString();
            table.addElement((Element)HtmlFormat.Titles.table((String)title_safe));
        }
        Div div = HtmlFormat.Divs.richTable();
        div.addElement((Element)table);
        this.addBlock(div);
    }

    private String _noNull(String s) {
        if (s == null) {
            return "na";
        }
        return s;
    }

    public void addHtml(String code) {
        this.fDoc.getHtml().addElement(code);
    }

    public PicFile[] getPicFiles() {
        return this.fPicFiles.toArray(new PicFile[this.fPicFiles.size()]);
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.fDoc.output(os);
        os.close();
    }
}

