/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.api;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.swing.GPopupChecker;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.ext.FileBrowserAction;
import edu.mit.broad.xbench.actions.ext.OsExplorerAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class ToolReportDisplay {
    private JList jlDisplay;
    private ToolReport fReport;
    private final Logger log = Logger.getLogger(this.getClass());
    private JFrame fFrame;
    private static final Dimension DEFAULT_DIM = new Dimension(500, 325);
    private final ToolReportDisplay fInstance = this;
    private static final Font FONT_DEFAULT_BOLD = new Font("Helvetica", 1, 12);
    private static final String index_html = "index.html";

    public ToolReportDisplay(ToolReport report) {
        if (report == null) {
            throw new IllegalArgumentException("Param reports cannot be null");
        }
        this.fReport = report;
        this.init();
    }

    public void show() {
        ToolReportDisplay.centerFrame(this.fFrame);
        this.fFrame.setSize(DEFAULT_DIM);
        this.fFrame.setVisible(true);
    }

    private void init() {
        this.jbInit();
    }

    private void jbInit() {
        File rdir = this.fReport.getReportDir();
        String desc = rdir != null && rdir.exists() ? "Report for " + this.fReport.getName() + " [" + rdir.getAbsolutePath() + "]" : "Report for " + this.fReport.getName() + " [ No data files ]";
        this.jlDisplay = new JList();
        this.jlDisplay.setToolTipText(desc);
        this.jlDisplay.setCellRenderer(new CommonLookAndClickListRenderer(this.jlDisplay));
        this.jlDisplay.setSelectionMode(0);
        DefaultListModel<File> model = new DefaultListModel<File>();
        File[] files = this.fReport.getFilesProduced();
        File indexPageFile = this.fReport.getIndexPageFile();
        if (indexPageFile != null) {
            model.addElement(indexPageFile);
        }
        for (int i = 0; i < files.length; ++i) {
            if (indexPageFile != null) {
                if (indexPageFile.equals(files[i])) continue;
                model.addElement(files[i]);
                continue;
            }
            model.addElement(files[i]);
        }
        this.jlDisplay.setModel(model);
        this.jlDisplay.setBorder(BorderFactory.createTitledBorder("Files Produced (double click to open, right-click for options)"));
        this.jlDisplay.setBackground(GuiHelper.COLOR_LIGHT_ORANGE);
        if (model.getSize() > 0) {
            this.jlDisplay.setSelectedIndex(0);
        }
        this.fFrame = new JFrame(desc);
        this.fFrame.setVisible(false);
        this.fFrame.setSize(DEFAULT_DIM);
        this.fFrame.getContentPane().setLayout(new BorderLayout());
        this.fFrame.getContentPane().add((Component)this.createCommandPanel(), "North");
        JScrollPane sp = new JScrollPane(this.jlDisplay);
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(32);
        this.fFrame.getContentPane().add((Component)sp, "Center");
        JPanel butPanel = new JPanel();
        if (rdir != null && rdir.exists()) {
            JButton bExplorer = new JButton("Browse");
            bExplorer.addActionListener(new OsExplorerAction(rdir));
            butPanel.add(bExplorer);
        }
        JButton bQuit = new JButton("Quit");
        if (this.fReport.getTool().getParamSet().getGuiParam().isTrue()) {
            bQuit.setText("Close");
        }
        bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolReportDisplay.this.fInstance.close();
            }
        });
        butPanel.add(bQuit);
        this.fFrame.getContentPane().add((Component)butPanel, "South");
    }

    private JComponent createCommandPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(ToolReportDisplay.DEFAULT_DIM.width, 55));
        StringBuffer buf = new StringBuffer(this.fReport.getProducerName()).append(' ');
        buf.append(this.fReport.getTool().getParamSet().getAsCommand(false).trim());
        final JTextArea ta = new JTextArea(1, 40);
        ta.setBorder(BorderFactory.createTitledBorder("The command was:"));
        ta.setText(buf.toString());
        ta.setWrapStyleWord(true);
        JButton bCopy = new JButton("Copy", GuiHelper.ICON_COPY16);
        bCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StringSelection stsel = new StringSelection(ta.getText());
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(stsel, stsel);
            }
        });
        panel.add((Component)new JScrollPane(ta), "Center");
        panel.add((Component)bCopy, "East");
        return panel;
    }

    private Icon getIcon(File file) {
        return DataFormat.getIcon(file);
    }

    private void runDefaultAction(Object obj) {
        ActionListener action = null;
        if (obj instanceof File) {
            File file = (File)obj;
            String ext = NamingConventions.getExtension(file);
            action = ext.equalsIgnoreCase("html") ? new FileBrowserAction(file) : new OsExplorerAction(file);
        } else if (obj instanceof XChart) {
            action = new ReportChartAction((XChart)obj);
        }
        if (action != null) {
            action.actionPerformed(null);
        } else {
            Application.getWindowManager().showMessage("No action defined for: " + obj);
        }
    }

    private JPopupMenu createPopupMenu(Object obj) {
        JPopupMenu popup = null;
        if (obj instanceof File) {
            popup = new JPopupMenu();
            File file = (File)obj;
            String ext = NamingConventions.getExtension(file);
            if (ext.equalsIgnoreCase("html")) {
                popup.add(new FileBrowserAction(file));
            } else {
                popup.add(new OsExplorerAction(file));
            }
        } else if (obj instanceof XChart) {
            popup = new JPopupMenu();
            popup.add(new ReportChartAction((XChart)obj));
        }
        return popup;
    }

    private static void centerFrame(JFrame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = frame.getSize();
        frame.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    private void close() {
        this.fFrame.dispose();
        this.fFrame.setVisible(false);
        this.log.debug((Object)"Debug mode, so not quiting but hiding");
    }

    class ReportChartAction
    extends AbstractAction {
        final XChart fChart;

        private ReportChartAction(XChart chart) {
            this.fChart = chart;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }

    private class MyPopupMouseListener
    extends GPopupChecker {
        private MyPopupMouseListener() {
        }

        @Override
        protected void maybeShowPopup(MouseEvent e) {
            Object ot;
            if (e.isPopupTrigger() && (ot = e.getSource()) instanceof JList) {
                Object obj = ((JList)ot).getSelectedValue();
                if (obj == null) {
                    return;
                }
                JPopupMenu popup = ToolReportDisplay.this.createPopupMenu(obj);
                if (popup != null) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    private class CommonLookAndClickListRenderer
    extends DefaultListCellRenderer {
        private Font normalFont;

        private CommonLookAndClickListRenderer(final JList renderedlist) {
            renderedlist.addMouseListener(new MyPopupMouseListener());
            renderedlist.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Object obj = renderedlist.getSelectedValue();
                        if (obj == null) {
                            return;
                        }
                        ToolReportDisplay.this.runDefaultAction(obj);
                    }
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof XChart) {
                this.setText(((XChart)value).getName());
                this.setIcon(XChart.ICON);
            } else if (value instanceof File) {
                if (((File)value).getName().equalsIgnoreCase(ToolReportDisplay.index_html)) {
                    this.setText(ToolReportDisplay.index_html);
                    this.setFont(FONT_DEFAULT_BOLD);
                } else {
                    this.setFont(this.normalFont);
                    this.setText(((File)value).getAbsolutePath());
                }
                this.setIcon(ToolReportDisplay.this.fInstance.getIcon((File)value));
                this.setToolTipText(((File)value).getAbsolutePath());
            }
            return this;
        }
    }
}

