/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.gsea.PValueCalculatorImpls;
import edu.mit.broad.genome.alg.markers.PermutationTest;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.charts.XChartUtils;
import edu.mit.broad.genome.charts.XComboChart;
import edu.mit.broad.genome.charts.XComboDomainChart;
import edu.mit.broad.genome.charts.XComboRangeChart;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.models.XYDatasetMultiTmp;
import edu.mit.broad.genome.models.XYDatasetVERT;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImplWithPermTest;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentReport;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentReportDbImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentReportImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.GctParser;
import edu.mit.broad.genome.reports.ChartHelper;
import edu.mit.broad.genome.reports.EnrichmentCharts;
import edu.mit.broad.genome.reports.MiscReports;
import edu.mit.broad.genome.reports.RankedListCharts;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.api.PicFile;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.ExcelTxtPage;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.genome.reports.pages.Page;
import edu.mit.broad.genome.reports.web.LinkedFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.heatmap.GramImagerImpl;
import gnu.trove.TIntFloatHashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.IMG;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.html.UL;
import org.genepattern.io.ImageUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class EnrichmentReports
extends ChartHelper {
    protected static final String[] BASIC_COL_NAMES = new String[]{"GS<br> follow link to MSigDB", "GS DETAILS", "SIZE", "ES", "NES", "NOM p-val", "FDR q-val", "FWER p-val", "RANK AT MAX", "LEADING EDGE"};
    private static final int COL_ES = 3;
    private static final int COL_NES = 4;
    private static final int COL_NP = 5;
    private static final int COL_FDR = 6;
    private static final int COL_FWER = 7;
    public static final String ENPLOT_ = "enplot_";
    public static final Color CHART_FRAME_COLOR = new Color(242, 242, 242);

    private static IntervalMarker[] _markers(RankedList rl) {
        int numRanges = rl.getSize() < 100 ? rl.getSize() : 100;
        return RankedListCharts.createIntervalMarkers(numRanges, rl);
    }

    private static File _createSubDir(EnrichmentDb edb, ToolReport report, boolean makeSubDir) {
        File saveInDir;
        if (makeSubDir) {
            Object classB_name;
            Object classA_name;
            Template templatex = edb.getTemplate();
            if (templatex != null) {
                if (templatex.isContinuous()) {
                    String nn = AuxUtils.getAuxNameOnlyNoHash(templatex);
                    if (templatex.isContinuous()) {
                        classA_name = nn;
                        classB_name = nn;
                    } else {
                        classA_name = nn + "_pos";
                        classB_name = nn + "_neg";
                    }
                } else {
                    classA_name = templatex.getClassName(0);
                    classB_name = templatex.getClassName(1);
                }
            } else {
                classA_name = "classA";
                classB_name = "classB";
            }
            saveInDir = report.createSubDir((String)classA_name + "_vs_" + (String)classB_name);
        } else {
            saveInDir = report.getReportDir();
        }
        return saveInDir;
    }

    public static Ret createGseaLikeReport(EnrichmentDb edb_original, PrintStream out, CollapsedDetails cd, HtmlPage reportIndexPage, boolean makeSubDir, ToolReport report, int topXSets, int minSize, int maxSize, boolean makeGeneSetsReport, boolean makeZippedFile, boolean createSvgs, boolean createGcts, GeneSet[] origGeneSets_opt, String metricName, String normModeName) {
        FeatureAnnot fann = null;
        if (edb_original.getDataset() != null && edb_original.getDataset().getAnnot() != null) {
            fann = edb_original.getDataset().getAnnot().getFeatureAnnot();
        }
        return EnrichmentReports.createGseaLikeReport(edb_original, out, cd, reportIndexPage, EnrichmentReports._createSubDir(edb_original, report, makeSubDir), report, topXSets, minSize, maxSize, makeGeneSetsReport, makeZippedFile, createSvgs, createGcts, origGeneSets_opt, metricName, normModeName, fann, null, null, null);
    }

    public static Ret createGseaLikeReport(EnrichmentDb edb_original, PrintStream out, CollapsedDetails cd, HtmlPage reportIndexPage, boolean makeSubDir, ToolReport report, int topXSets, int minSize, int maxSize, boolean makeGeneSetsReport, boolean makeZippedFile, boolean createSvgs, GeneSet[] origGeneSets_opt, String metricName, String normModeName, FeatureAnnot fann_opt) {
        return EnrichmentReports.createGseaLikeReport(edb_original, out, cd, reportIndexPage, EnrichmentReports._createSubDir(edb_original, report, makeSubDir), report, topXSets, minSize, maxSize, makeGeneSetsReport, makeZippedFile, createSvgs, false, origGeneSets_opt, metricName, normModeName, fann_opt, null, null, null);
    }

    private static String _createPhenotypeName(EnrichmentDb edb) {
        Template templatex = edb.getTemplate();
        String phenotypeName = templatex != null ? templatex.getName() : "NoPhenotypeAvailable";
        return phenotypeName;
    }

    private static String[] _createClassNames(Template template_opt) {
        Object classB_name;
        Object classA_name;
        if (template_opt != null) {
            if (template_opt.isContinuous()) {
                String nn = AuxUtils.getAuxNameOnlyNoHash(template_opt);
                classA_name = nn + "_pos";
                classB_name = nn + "_neg";
            } else {
                classA_name = template_opt.getClassName(0);
                classB_name = template_opt.getClassName(1);
            }
        } else {
            classA_name = "na_pos";
            classB_name = "na_neg";
        }
        return new String[]{classA_name, classB_name};
    }

    public static Ret createGseaLikeReport(EnrichmentDb edb_original, PrintStream out, CollapsedDetails cd, HtmlPage reportIndexPage, File saveInThisDir, ToolReport report, int topXSets, int minSize, int maxSize, boolean makeGeneSetsReport, boolean makeZippedFile, boolean createSvgs, boolean createGcts, GeneSet[] origGeneSets_opt, String metricName, String normModeName, FeatureAnnot fann_opt, String phenotypeName_opt, String classA_name_opt, String classB_name_opt) {
        StringElement lined1;
        StringElement line6;
        StringElement line5;
        StringElement line4;
        StringElement line3;
        StringElement line2b;
        StringElement line2a;
        StringElement line1;
        Object classB_name_long;
        Object classA_name_long;
        if (normModeName == null) {
            throw new IllegalArgumentException("Param normModeName cannot be null");
        }
        if (saveInThisDir == null) {
            throw new IllegalArgumentException("Param saveInThisDir cannot be null");
        }
        if (!saveInThisDir.exists()) {
            saveInThisDir.mkdir();
        }
        if (phenotypeName_opt == null) {
            phenotypeName_opt = EnrichmentReports._createPhenotypeName(edb_original);
        }
        if (classA_name_opt == null || classB_name_opt == null) {
            String[] classNames = EnrichmentReports._createClassNames(edb_original.getTemplate());
            classA_name_opt = classNames[0];
            classB_name_opt = classNames[1];
        }
        PValueCalculatorImpls.GseaImpl pvc = new PValueCalculatorImpls.GseaImpl(normModeName);
        EnrichmentResult[] results = pvc.calcNPValuesAndFDR(edb_original.getResults());
        EnrichmentDb edb = edb_original.cloneDeep(results);
        Dataset my_gex_ds_for_heat_map = edb.getDataset();
        RankedList rlReal = edb.getRankedList();
        GeneSet[] gsets = edb.getGeneSets();
        MetricWeightStruc mws = rlReal.getMetricWeightStruc();
        if (mws != null && metricName != null && mws.getMetricName() == null) {
            mws.setMetricName(metricName);
        }
        File geneSets_sizes_file = null;
        Template template = edb.getTemplate();
        if (template != null) {
            if (template.isContinuous()) {
                classA_name_long = "positive correlation with profile";
                classB_name_long = "negative correlation with profile";
            } else {
                classA_name_long = template.getClassName(0) + " (" + template.getClass(0).getSize() + " samples)";
                classB_name_long = template.getClassName(1) + " (" + template.getClass(1).getSize() + " samples)";
            }
        } else {
            classB_name_long = "na";
            classA_name_long = "na";
        }
        String name = edb.getName();
        out.println("Creating marker selection reports ...");
        RichDataframe rdfGeneList = MiscReports.annotateProbesNames(name, rlReal, fann_opt);
        File real_gene_list_file_xls = report.savePageXls(rdfGeneList.getDataframe(), "ranked_gene_list_" + classA_name_opt + "_versus_" + classB_name_opt + "_" + report.getTimestamp(), saveInThisDir);
        File real_gene_list_heat_map_corr_plot_html_file = null;
        if (my_gex_ds_for_heat_map != null && template != null) {
            HtmlPage real_gene_list_heat_map_corr_plot_html = MiscReports.createDatasetHeatMapAndCorrelationPlots(my_gex_ds_for_heat_map, template, rlReal, 50, saveInThisDir, createSvgs, createGcts);
            real_gene_list_heat_map_corr_plot_html_file = report.savePage((Page)real_gene_list_heat_map_corr_plot_html, saveInThisDir);
        }
        File butterfly_file = null;
        File butterfly_file_svg = null;
        if (edb instanceof EnrichmentDbImplWithPermTest && ((EnrichmentDbImplWithPermTest)edb).getPermutationTest() != null) {
            try {
                XChart xc = EnrichmentReports.createButterflyChart(((EnrichmentDbImplWithPermTest)edb).getPermutationTest());
                butterfly_file = new File(saveInThisDir, "butterfly_plot.png");
                xc.saveAsPNG(butterfly_file, 500, 500);
                if (createSvgs) {
                    butterfly_file_svg = ImageUtil.getSvgFileFromImgFile(butterfly_file, true);
                    ImageUtil.saveAsSVG(xc.getFreeChart(), butterfly_file_svg, 500, 500, true);
                }
            }
            catch (Throwable t) {
                report.addError("Trouble making butterfly plot", t);
            }
        }
        out.println("Creating FDR reports ...");
        EnrichmentResult[] results_pos = edb.getResults(new ComparatorFactory.EnrichmentResultByNESComparator(Order.DESCENDING), true);
        BasicReportStruc pos_basic = EnrichmentReports.createReport(results_pos, name, phenotypeName_opt, classA_name_opt, classB_name_opt, rlReal, template, fann_opt, "Gene sets enriched in phenotype <b>" + (String)classA_name_long + "<b>", topXSets, makeGeneSetsReport, createSvgs, createGcts, saveInThisDir);
        RichDataframe pos_basic_rdf = pos_basic.rdf;
        out.println("Done FDR reports for positive phenotype");
        EnrichmentResult[] results_neg = edb.getResults(new ComparatorFactory.EnrichmentResultByNESComparator(Order.ASCENDING), false);
        BasicReportStruc neg_basic = EnrichmentReports.createReport(results_neg, name, phenotypeName_opt, classA_name_opt, classB_name_opt, rlReal, template, fann_opt, "Gene sets enriched in phenotype <b>" + (String)classB_name_long + "<b>", topXSets, makeGeneSetsReport, createSvgs, createGcts, saveInThisDir);
        RichDataframe neg_basic_rdf = neg_basic.rdf;
        out.println("Done FDR reports for negative phenotype");
        String pos_name = "gsea_report_for_" + classA_name_opt + "_" + report.getTimestamp();
        String pos_title = "Report for " + classA_name_opt + " " + report.getTimestamp() + " [GSEA]";
        String neg_name = "gsea_report_for_" + classB_name_opt + "_" + report.getTimestamp();
        String neg_title = "Report for " + classB_name_opt + " " + report.getTimestamp() + " [GSEA]";
        File pos_basic_xls = report.savePageXls(pos_basic_rdf, pos_name, saveInThisDir);
        File neg_basic_xls = report.savePageXls(neg_basic_rdf, neg_name, saveInThisDir);
        HtmlPage htmlPage = new HtmlPage(pos_name, pos_title);
        htmlPage.addTable(pos_basic_rdf, pos_basic_xls.getName(), false, true);
        File pos_basic_html = report.savePage((Page)htmlPage, saveInThisDir);
        File pos_snapshot_html = report.savePage((Page)EnrichmentReports.createSnapshotPage(true, pos_basic.reports), saveInThisDir);
        htmlPage = new HtmlPage(neg_name, neg_title);
        htmlPage.addTable(neg_basic_rdf, neg_basic_xls.getName(), false, true);
        File neg_basic_html = report.savePage((Page)htmlPage, saveInThisDir);
        File neg_snapshot_html = report.savePage((Page)EnrichmentReports.createSnapshotPage(false, neg_basic.reports), saveInThisDir);
        XChart pvalues_nes_plot_xc = EnrichmentReports.createNESvsSignificancePlot(edb);
        File pvalues_nes_plot_file = report.savePage(pvalues_nes_plot_xc, 500, 500, saveInThisDir);
        File pvalues_nes_plot_svg_file = null;
        if (createSvgs) {
            pvalues_nes_plot_svg_file = ImageUtil.getSvgFileFromImgFile(pvalues_nes_plot_file, true);
            report.savePageSvg(pvalues_nes_plot_xc, 500, 500, pvalues_nes_plot_svg_file);
        }
        XChart global_es_histogram_xc = EnrichmentReports.createGlobalESHistogram(AuxUtils.getAuxNameOnlyNoHash(phenotypeName_opt), edb.getESS_lv());
        File global_es_histogram_file = report.savePage(global_es_histogram_xc, 500, 500, saveInThisDir);
        File global_es_histogram_svg_file = null;
        if (createSvgs) {
            global_es_histogram_svg_file = ImageUtil.getSvgFileFromImgFile(global_es_histogram_file, true);
            report.savePageSvg(global_es_histogram_xc, 500, 500, global_es_histogram_svg_file);
        }
        Div div = new Div();
        H4 h4 = new H4("Enrichment in phenotype: <b>" + (String)classA_name_long + "</b>");
        div.addElement((Element)h4);
        UL ul = new UL();
        StringElement line7 = HtmlFormat.Links.hyper("Guide to", "http://www.gsea-msigdb.org/gsea/doc/GSEAUserGuideFrame.html?_Interpreting_GSEA_Results", "interpret results");
        if (edb.getNumScores(true) > 0) {
            line1 = new StringElement(edb.getNumScores(true) + " / " + gsets.length + " gene sets are upregulated in phenotype <b>" + classA_name_opt + "</b>");
            line2a = new StringElement(edb.getNumNominallySig(0.01f, true) + " gene sets are significantly enriched at nominal pvalue < 1%");
            line2b = new StringElement(edb.getNumNominallySig(0.05f, true) + " gene sets are significantly enriched at nominal pvalue < 5%");
            line3 = new StringElement(edb.getNumFDRSig(0.25f, true) + " gene sets are significant at FDR < 25%");
            line4 = HtmlFormat.Links.hyper("Snapshot", pos_snapshot_html, "of enrichment results", saveInThisDir);
            line5 = HtmlFormat.Links.hyper("Detailed", "enrichment results in html", pos_basic_html, " format", saveInThisDir);
            line6 = HtmlFormat.Links.hyper("Detailed", "enrichment results in excel", pos_basic_xls, " format (tab delimited text)", saveInThisDir);
            ul.addElement((Element)new LI((Element)line1));
            ul.addElement((Element)new LI((Element)line3));
            ul.addElement((Element)new LI((Element)line2a));
            ul.addElement((Element)new LI((Element)line2b));
            ul.addElement((Element)new LI((Element)line4));
            ul.addElement((Element)new LI((Element)line5));
            ul.addElement((Element)new LI((Element)line6));
            ul.addElement((Element)new LI((Element)line7));
        } else {
            line1 = new StringElement("None of the gene sets are enriched in phenotype <b>" + classA_name_opt + "</b>");
            ul.addElement((Element)new LI((Element)line1));
            ul.addElement((Element)new LI((Element)line7));
        }
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, false);
        div = new Div();
        h4 = new H4("Enrichment in phenotype: <b>" + (String)classB_name_long + "</b>");
        div.addElement((Element)h4);
        ul = new UL();
        if (edb.getNumScores(false) > 0) {
            line1 = new StringElement(edb.getNumScores(false) + " / " + gsets.length + " gene sets are upregulated in phenotype <b>" + classB_name_opt + "</b>");
            line2a = new StringElement(edb.getNumNominallySig(0.01f, false) + " gene sets are significantly enriched at nominal pvalue < 1%");
            line2b = new StringElement(edb.getNumNominallySig(0.05f, false) + " gene sets are significantly enriched at nominal pvalue < 5%");
            line3 = new StringElement(edb.getNumFDRSig(0.25f, false) + " gene sets are significantly enriched at FDR < 25%");
            line4 = HtmlFormat.Links.hyper("Snapshot", neg_snapshot_html, "of enrichment results", saveInThisDir);
            line5 = HtmlFormat.Links.hyper("Detailed", "enrichment results in html", neg_basic_html, " format", saveInThisDir);
            line6 = HtmlFormat.Links.hyper("Detailed", "enrichment results in excel", neg_basic_xls, " format (tab delimited text)", saveInThisDir);
            ul.addElement((Element)new LI((Element)line1));
            ul.addElement((Element)new LI((Element)line3));
            ul.addElement((Element)new LI((Element)line2a));
            ul.addElement((Element)new LI((Element)line2b));
            ul.addElement((Element)new LI((Element)line4));
            ul.addElement((Element)new LI((Element)line5));
            ul.addElement((Element)new LI((Element)line6));
            ul.addElement((Element)new LI((Element)line7));
        } else {
            line1 = new StringElement("None of the gene sets are enriched in phenotype <b>" + classB_name_opt + "</b>");
            ul.addElement((Element)new LI((Element)line1));
            ul.addElement((Element)new LI((Element)line7));
        }
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, false);
        div = new Div();
        ul = new UL();
        h4 = new H4("Dataset details");
        div.addElement((Element)h4);
        if (cd.wasCollapsed) {
            lined1 = new StringElement("The dataset has " + cd.getNumRow_orig() + " native features");
            StringElement lined2 = new StringElement("After collapsing features into gene symbols, there are: " + rlReal.getSize() + " genes");
            ul.addElement((Element)new LI((Element)lined1));
            ul.addElement((Element)new LI((Element)lined2));
        } else {
            lined1 = new StringElement("The dataset has " + rlReal.getSize() + " features (genes)");
            ul.addElement((Element)new LI((Element)lined1));
            ul.addElement((Element)new LI("No probe set => gene symbol collapsing was requested, so all " + rlReal.getSize() + " features were used"));
        }
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, false);
        if (origGeneSets_opt != null) {
            div = new Div();
            ul = new UL();
            h4 = new H4("Gene set details");
            div.addElement((Element)h4);
            int xs = origGeneSets_opt.length - gsets.length;
            StringBuffer buf = new StringBuffer("Gene set size filters (min=").append(minSize).append(", max=").append(maxSize).append(")");
            buf.append(" resulted in filtering out ").append(xs).append(" / ").append(origGeneSets_opt.length).append(" gene sets");
            ul.addElement((Element)new LI(buf.toString()));
            geneSets_sizes_file = EnrichmentReports._getGeneSetSizesFile(gsets, origGeneSets_opt, geneSets_sizes_file, report);
            ul.addElement((Element)new LI("The remaining " + gsets.length + " gene sets were used in the analysis"));
            ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("List of", "gene sets used and their sizes", geneSets_sizes_file, "(restricted to features in the specified dataset)", saveInThisDir)));
            div.addElement((Element)ul);
            reportIndexPage.addBlock(div, false);
        }
        div = new Div();
        h4 = template != null && template.isContinuous() ? new H4("Gene markers for the neighbors of " + classA_name_opt) : new H4("Gene markers for the <b>" + classA_name_opt + "</b><i> versus </i><b>" + classB_name_opt + "</b> comparison");
        div.addElement((Element)h4);
        StringElement line12 = new StringElement("The dataset has " + rlReal.getSize() + " features (genes)");
        StringElement line2 = new StringElement("# of markers for phenotype <b>" + classA_name_opt + "</b>: " + mws.getTotalPosLength() + " (" + Printf.format(mws.getTotalPosLength_frac() * 100.0f, 1) + "% ) with correlation area " + Printf.format(mws.getTotalPosWeight_frac() * 100.0f, 1) + "%");
        StringElement line32 = new StringElement("# of markers for phenotype <b>" + classB_name_opt + "</b>: " + mws.getTotalNegLength() + " (" + Printf.format(mws.getTotalNegLength_frac() * 100.0f, 1) + "% ) with correlation area " + Printf.format(mws.getTotalNegWeight_frac() * 100.0f, 1) + "%");
        StringElement line42 = HtmlFormat.Links.hyper("Detailed", "rank ordered gene list", real_gene_list_file_xls, " for all features in the dataset", saveInThisDir);
        ul = new UL();
        ul.addElement((Element)new LI((Element)line12));
        if (template != null && !template.isContinuous()) {
            ul.addElement((Element)new LI((Element)line2));
            ul.addElement((Element)new LI((Element)line32));
        }
        ul.addElement((Element)new LI((Element)line42));
        if (real_gene_list_heat_map_corr_plot_html_file != null) {
            StringElement line52 = HtmlFormat.Links.hyper("Heat map and gene list correlation ", real_gene_list_heat_map_corr_plot_html_file, " profile for all features in the dataset", saveInThisDir);
            ul.addElement((Element)new LI((Element)line52));
        }
        if (butterfly_file != null && butterfly_file.exists()) {
            StringElement line62 = HtmlFormat.Links.hyper("Butterfly plot", butterfly_file, "of significant genes", saveInThisDir);
            ul.addElement((Element)new LI((Element)line62));
            if (createSvgs) {
                StringElement line6a = HtmlFormat.Links.hyper("Butterfly plot", butterfly_file_svg, "of significant genes (in compressed SVG format)", saveInThisDir);
                ul.addElement((Element)new LI((Element)line6a));
            }
        }
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, false);
        out.println("Creating global reports ...");
        div = new Div();
        ul = new UL();
        div.addElement((Element)new H4("Global statistics and plots"));
        ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("Plot of ", "p-values <i>vs.</i> NES", pvalues_nes_plot_file, "", saveInThisDir)));
        if (createSvgs) {
            ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("Plot of ", "p-values <i>vs.</i> NES", pvalues_nes_plot_svg_file, "(in compressed SVG format)", saveInThisDir)));
        }
        ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("Global ES", global_es_histogram_file, "histogram", saveInThisDir)));
        if (createSvgs) {
            ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("Global ES", global_es_histogram_svg_file, "histogram (in compressed SVG format)", saveInThisDir)));
        }
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, false);
        div = new Div();
        ul = new UL();
        div.addElement((Element)new H4("Other"));
        ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("Parameters", report.getParamsFile(), "used for this analysis", saveInThisDir)));
        if (makeZippedFile) {
            File zipped_report = report.getZipReportFile();
            ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("Zipped", zipped_report, "file with all results", saveInThisDir)));
        }
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, false);
        if (reportIndexPage instanceof HtmlReportIndexPage) {
            ((HtmlReportIndexPage)reportIndexPage).setAddBrowseFooter(false);
        }
        out.println("Done all reports!!");
        ArrayList<EnrichmentReport> all_reports = new ArrayList<EnrichmentReport>(Arrays.asList(pos_basic.reports));
        all_reports.addAll(Arrays.asList(neg_basic.reports));
        Ret ret = new Ret();
        ret.rdb = new EnrichmentReportDbImpl(all_reports.toArray(new EnrichmentReport[all_reports.size()]));
        ret.savedInDir = saveInThisDir;
        ret.edb = edb;
        return ret;
    }

    public static BasicReportStruc createReport(EnrichmentResult[] results, String dsName, String phenotypeName, String phenoClassAName_opt, String phenoClassBName_opt, RankedList rl, Template template_opt, FeatureAnnot fannx, String title, int showDetailsForTopXSets, boolean makeDetailsPage, boolean createSvgs, boolean createGcts, File saveDetailFilesInDir) {
        String[] gsetNames = new String[results.length];
        TIntObjectHashMap cell_id_linkMap = new TIntObjectHashMap();
        StringMatrix sm = new StringMatrix(gsetNames.length, BASIC_COL_NAMES.length);
        IntervalMarker[] markers = EnrichmentReports._markers(rl);
        ArrayList<EnrichmentReportImpl> ereports = new ArrayList<EnrichmentReportImpl>();
        for (int r = 0; r < results.length; ++r) {
            int coln = 0;
            EnrichmentResult result = results[r];
            gsetNames[r] = result.getGeneSet().getName(true);
            HtmlPage htmlPage = null;
            sm.setElement(r, coln++, gsetNames[r]);
            if (makeDetailsPage && r < showDetailsForTopXSets) {
                EnrichmentResult dtg = results[r];
                htmlPage = new HtmlPage(gsetNames[r], "Details for gene set " + gsetNames[r] + "[GSEA]");
                MyEnrichmentReportImpl mer = EnrichmentReports.createReport(dsName, phenotypeName, phenoClassAName_opt, phenoClassBName_opt, rl, template_opt, dtg.getGeneSet(), dtg.getScore().getHitIndices(), dtg.getScore().getESProfile(), dtg.getScore().getESProfile_point_by_point_opt(), result.getScore().getES(), result.getScore().getNES(), result.getScore().getNP(), result.getScore().getFDR(), result.getScore().getFWER(), dtg.getRndESS(), htmlPage, fannx, true, createSvgs, createGcts, markers, true, saveDetailFilesInDir);
                try {
                    File htmlFile = new File(saveDetailFilesInDir, mer.fHtmlPage.getName() + ".html");
                    htmlPage.write(new FileOutputStream(htmlFile));
                    mer.fExcelPage.write(new FileOutputStream(new File(saveDetailFilesInDir, mer.fExcelPage.getName() + ".xls")));
                    PicFile[] pfs = htmlPage.getPicFiles();
                    File plotFile = pfs[0].getFile();
                    ereports.add(new EnrichmentReportImpl(htmlFile, plotFile));
                }
                catch (Throwable thr) {
                    klog.error((Object)("Error making details: " + gsetNames[r]), thr);
                }
                sm.setElement(r, coln++, "Details ...");
            } else {
                sm.setElement(r, coln++, "");
            }
            sm.setElement(r, coln++, result.getScore().getNumHits());
            sm.setElement(r, coln++, result.getScore().getES());
            sm.setElement(r, coln++, result.getScore().getNES());
            sm.setElement(r, coln++, result.getScore().getNP());
            sm.setElement(r, coln++, result.getScore().getFDR());
            sm.setElement(r, coln++, result.getScore().getFWER());
            sm.setElement(r, coln++, result.getSignal().getRankAtMax());
            sm.setElement(r, coln, EnrichmentReports.getLeadingEdge(result));
            if (htmlPage == null) continue;
            cell_id_linkMap.put(sm.getElementPos(r, 0), (Object)LinkedFactory.createLinkedGeneSet(result.getGeneSet()));
            cell_id_linkMap.put(sm.getElementPos(r, 1), (Object)new LinkedFactory.SimpleLinkedPage("Details", htmlPage));
        }
        StringDataframe sdf = new StringDataframe(dsName + "_basic", sm, gsetNames, BASIC_COL_NAMES, true);
        TIntIntHashMap colPrecision = new TIntIntHashMap();
        colPrecision.put(3, 2);
        colPrecision.put(4, 2);
        colPrecision.put(5, 3);
        colPrecision.put(6, 3);
        colPrecision.put(7, 3);
        BasicReportStruc struc = new BasicReportStruc();
        RichDataframe.MetaData md = new RichDataframe.MetaData(title, null, null, null, colPrecision);
        struc.rdf = new RichDataframe(sdf, md, null, cell_id_linkMap);
        struc.reports = ereports.toArray(new EnrichmentReport[ereports.size()]);
        return struc;
    }

    public static HtmlPage createSnapshotPage(boolean pos, EnrichmentReport[] reports) {
        Table table = new Table();
        int index = 0;
        for (int r = 0; r < reports.length; ++r) {
            TR tr = new TR();
            for (int c = 0; c < 3; ++c) {
                A a = new A();
                a.setName("");
                a.setHref(reports[index].getHtmlFile().getName());
                IMG img = new IMG();
                img.setSrc(reports[index].getESPlotFile().getName());
                img.setWidth(200);
                img.setHeight(200);
                a.addElement((Element)img);
                TD td = new TD((Element)a);
                tr.addElement((Element)td);
                if (++index >= reports.length) break;
            }
            table.addElement((Element)tr);
            if (index >= reports.length) break;
        }
        String name = pos ? "pos_snapshot" : "neg_snapshot";
        HtmlPage page = new HtmlPage(name, "Snapshot of " + reports.length + " enrichment plots");
        page.addTable("Snapshot of enrichment results", table);
        return page;
    }

    public static String getLeadingEdge(EnrichmentResult result) {
        GeneSetSignal signal = result.getSignal();
        StringBuffer buf = new StringBuffer();
        buf.append("tags=").append(Printf.format(signal.getTagFraction() * 100.0f, 0)).append("%, ");
        buf.append("list=").append(Printf.format(signal.getListFraction() * 100.0f, 0)).append("%, ");
        buf.append("signal=").append(Printf.format(signal.getSignalStrength() * 100.0f, 0)).append("%");
        return buf.toString();
    }

    public static MyEnrichmentReportImpl createReport(String dsName, String phenotypeName, String classAName_opt, String classBName_opt, RankedList rl, Template template_opt, GeneSet gset, int[] hitIndices, Vector esProfile, Vector esProfile_full_opt, float es, float nes, float np, float fdr, float fwer, Vector rndEss, HtmlPage htmlPage, FeatureAnnot fann_opt, boolean doBpog, boolean createSvgs, boolean createGcts, IntervalMarker[] markers, boolean horizontal, File saveDetailFilesInDir) {
        ExcelTxtPage excelPage = null;
        EnrichmentCharts combo = null;
        try {
            String gsetName = gset.getName(true);
            if (hitIndices.length != gset.getNumMembers(rl)) {
                throw new IllegalStateException("Mismatched gset: " + gset.getNumMembers(rl) + " and hitIndices: " + hitIndices.length);
            }
            if ((int)esProfile.maxDevFrom0() != (int)es) {
                klog.warn((Object)("Possibly mismatched scores: " + esProfile.maxDevFrom0() + " " + es));
            }
            if (esProfile.getSize() != hitIndices.length) {
                throw new IllegalStateException("Mismatched esProfile: " + esProfile.getSize() + " and hitIndices: " + hitIndices.length);
            }
            RichDataframe rdf = EnrichmentReports.createDetailTable(dsName, hitIndices, esProfile, rl, gset, fann_opt);
            excelPage = new ExcelTxtPage(htmlPage.getName(), rdf);
            String upInClass = XMath.isPositive(es) ? classAName_opt : classBName_opt;
            KeyValTable table = EnrichmentReports.createSummaryTable(dsName, phenotypeName, upInClass, gset.getName(), es, nes, np, fdr, fwer);
            htmlPage.addTable("GSEA Results Summary", table);
            combo = EnrichmentReports._createComboChart(gsetName, esProfile, esProfile_full_opt, EnrichmentReports._hitIndices2Vector(rl.getSize(), hitIndices), rl, classAName_opt, classBName_opt, markers, horizontal);
            htmlPage.addChart(combo.comboChart, 500, 500, saveDetailFilesInDir, createSvgs);
            htmlPage.addTable(rdf, excelPage.getName() + "." + excelPage.getExt(), false, true);
            if (rl instanceof ScoredDataset && doBpog) {
                Dataset extractedDSForGSet = new DatasetGenerators().extractRowsSorted((ScoredDataset)rl, gset);
                htmlPage.addHeatMap(gsetName, "Blue-Pink O' Gram in the Space of the Analyzed GeneSet", new GramImagerImpl().createBpogHeatMap(extractedDSForGSet, template_opt), saveDetailFilesInDir, createSvgs);
                if (createGcts) {
                    File gctFile = new File(saveDetailFilesInDir, gsetName + ".gct");
                    GctParser gctExporter = new GctParser();
                    gctExporter.export((PersistentObject)extractedDSForGSet, gctFile);
                    StringElement gctLink = HtmlFormat.Links.hyper("GCT file  ", gctFile, " for the data backing the heatmap (for use in external visualizations)", saveDetailFilesInDir);
                    Div div = new Div();
                    htmlPage.addBlock(div, true);
                    div.addElement((Element)gctLink);
                }
            }
            if (rndEss != null && rndEss.getSize() != 0) {
                XChart chart = EnrichmentReports.createESNullDistribHistogram(gsetName, classAName_opt, classBName_opt, es, rndEss);
                htmlPage.addChart(chart, 500, 500, saveDetailFilesInDir, createSvgs);
            }
        }
        catch (Throwable t) {
            htmlPage.addError("Trouble making HtmlPage", t);
        }
        MyEnrichmentReportImpl mer = new MyEnrichmentReportImpl();
        mer.fHtmlPage = htmlPage;
        mer.fPlot = combo;
        mer.fExcelPage = excelPage;
        return mer;
    }

    public static RichDataframe createDetailTable(String name, int[] hitIndices, Vector esProfile, RankedList rl, GeneSet gset, FeatureAnnot fann_opt) {
        int symbolIndex;
        String[] colNames;
        if (rl == null) {
            throw new IllegalArgumentException("Param rl cannot be null");
        }
        int maxminIndex = hitIndices[esProfile.maxDevFrom0Index()];
        float maxmin = esProfile.maxDevFrom0();
        boolean pos = XMath.isPositive(maxmin);
        TIntIntHashMap colIndexFloatPrecMap = new TIntIntHashMap();
        if (fann_opt != null && fann_opt.hasNativeDescriptions()) {
            colNames = new String[]{"PROBE", "DESCRIPTION<br>(from dataset)", "GENE SYMBOL", "GENE_TITLE", "RANK IN GENE LIST", "RANK METRIC SCORE", "RUNNING ES", "CORE ENRICHMENT"};
            colIndexFloatPrecMap.put(5, 3);
            colIndexFloatPrecMap.put(6, 4);
            symbolIndex = 2;
        } else {
            colNames = new String[]{"PROBE", "GENE SYMBOL", "GENE_TITLE", "RANK IN GENE LIST", "RANK METRIC SCORE", "RUNNING ES", "CORE ENRICHMENT"};
            symbolIndex = 1;
            colIndexFloatPrecMap.put(4, 3);
            colIndexFloatPrecMap.put(5, 4);
        }
        int signalIndex = colNames.length - 1;
        TIntObjectHashMap cell_id_linkMap = new TIntObjectHashMap();
        TIntObjectHashMap cell_id_colorMap = new TIntObjectHashMap();
        StringMatrix sm = new StringMatrix(hitIndices.length, colNames.length);
        for (int r = 0; r < hitIndices.length; ++r) {
            String geneTitle;
            String geneSymbol;
            String desc;
            float res;
            double metricScore;
            String probeName;
            int rank;
            int coln;
            block11: {
                coln = 0;
                rank = hitIndices[r];
                probeName = rl.getRankName(rank);
                metricScore = rl.getScore(rank);
                res = esProfile.getElement(r);
                desc = null;
                geneSymbol = null;
                geneTitle = null;
                try {
                    if (fann_opt != null) {
                        desc = fann_opt.getNativeDesc(probeName);
                        geneTitle = fann_opt.getGeneTitle(probeName);
                        geneSymbol = fann_opt.getGeneSymbol(probeName);
                    }
                    if (geneSymbol != null) {
                        cell_id_linkMap.put(sm.getElementPos(r, symbolIndex), (Object)LinkedFactory.createLinkedGeneSymbol(geneSymbol));
                    }
                }
                catch (Throwable t) {
                    if (r != 0) break block11;
                    t.printStackTrace();
                }
            }
            cell_id_linkMap.put(sm.getElementPos(r, 0), (Object)LinkedFactory.createLinkedProbeSet(probeName));
            sm.setElement(r, coln++, probeName);
            if (fann_opt != null && fann_opt.hasNativeDescriptions()) {
                sm.setElement(r, coln++, desc);
            }
            sm.setElement(r, coln++, geneSymbol);
            sm.setElement(r, coln++, geneTitle);
            sm.setElement(r, coln++, new Integer(rank));
            if (!gset.isMember(probeName)) {
                klog.warn((Object)("The ranked list content doesnt match the gene set content. Missing mamber: " + probeName));
            }
            sm.setElement(r, coln++, new Double(metricScore));
            sm.setElement(r, coln++, new Float(res));
            if (pos && hitIndices[r] <= maxminIndex || !pos && hitIndices[r] >= maxminIndex) {
                sm.setElement(r, coln, "Yes");
                cell_id_colorMap.put(sm.getElementPos(r, signalIndex), (Object)"#CCFFCC");
                continue;
            }
            sm.setElement(r, coln, "No");
        }
        StringDataframe sdf = new StringDataframe(name, sm, colNames, true);
        RichDataframe.MetaData metaData = new RichDataframe.MetaData("GSEA details", "some caption", null, null, colIndexFloatPrecMap);
        return new RichDataframe(sdf, metaData, cell_id_colorMap, cell_id_linkMap);
    }

    public static KeyValTable createSummaryTable(String dsName, String phenotypeName, String upInClassName_opt, String gsetName, float esRaw, float nes, float np, float fdr, float fwer) {
        KeyValTable table = new KeyValTable();
        table.addRow("Dataset", NamingConventions.splitLongHashName(dsName, "<br>"));
        table.addRow("Phenotype", phenotypeName);
        table.addRow("Upregulated in class", upInClassName_opt);
        table.addRow("GeneSet", gsetName);
        table.addRow("Enrichment Score (ES)", esRaw);
        table.addRow("Normalized Enrichment Score (NES)", nes);
        table.addRow("Nominal p-value", np);
        table.addRow("FDR q-value", fdr);
        table.addRow("FWER p-Value", fwer);
        return table;
    }

    public static XChart createHitProfileChart(Vector hitProfile, RankedList rl, boolean drawTicks, boolean shadeBg, boolean horizontal) {
        IntervalMarker[] markers = null;
        if (shadeBg) {
            markers = EnrichmentReports._markers(rl);
        }
        return EnrichmentReports._createHitProfileChart(hitProfile, drawTicks, markers, horizontal);
    }

    private static XChart _createHitProfileChart(Vector hitProfile, boolean drawTicks, IntervalMarker[] markers, boolean horizontal) {
        XYPlot plot;
        String seriesName = drawTicks ? "Hits" : "";
        String label = "Position in ranked list";
        if (horizontal) {
            plot = XChartUtils.lineYHits("HIT_LOCATION", "Position in ranked list", seriesName, hitProfile);
            plot.getDomainAxis().setLabel(label);
        } else {
            XYDatasetVERT data = new XYDatasetVERT(hitProfile, seriesName);
            NumberAxis xAxis = new NumberAxis("none");
            xAxis.setAutoRangeIncludesZero(false);
            NumberAxis yAxis = new NumberAxis("Position in ranked list");
            yAxis.setTickMarksVisible(false);
            yAxis.setTickLabelsVisible(true);
            StandardXYItemRenderer rend = new StandardXYItemRenderer(2);
            plot = new XYPlot((XYDataset)data, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)rend);
            plot.getRangeAxis().setLabel(label);
        }
        plot.getRangeAxis().setTickLabelsVisible(false);
        plot.getRangeAxis().setTickMarksVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.getRangeAxis().setLabel("");
        plot.getDomainAxis().setTickLabelsVisible(false);
        plot.getDomainAxis().setTickMarksVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setDomainGridlinesVisible(false);
        if (drawTicks) {
            plot.getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        } else {
            plot.getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(0.0f));
            plot.setOutlinePaint((Paint)Color.BLACK);
        }
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.BLACK);
        if (markers != null && markers.length > 0) {
            for (int i = 0; i < markers.length; ++i) {
                markers[i].setAlpha(1.0f);
                markers[i].setOutlineStroke((Stroke)new BasicStroke(0.0f));
                markers[i].setOutlinePaint((Paint)new Color(0, 0, 0, 0));
                if (horizontal) {
                    plot.addDomainMarker(0, (Marker)markers[i], Layer.BACKGROUND);
                    continue;
                }
                plot.addRangeMarker(0, (Marker)markers[i], Layer.BACKGROUND);
            }
        }
        return new XChartImpl("hit_locations", "Lines are drawn to represent positions in the ordered Dataset that match a gene in the GeneSet", new JFreeChart((Plot)plot));
    }

    public static XChart createNESvsSignificancePlot(EnrichmentDb edb) {
        Vector nessX = edb.getNESS();
        Vector fdrs = edb.getFDRs();
        for (int i = 0; i < fdrs.getSize(); ++i) {
            fdrs.setElement(i, fdrs.getElement(i) * 100.0f);
        }
        Vector[] yss = new Vector[]{fdrs};
        JFreeChart chart = XChartUtils.scatterOneXManyY("NES vs. Significance", new String[]{"FDR q-value"}, "NES", "FDR q-value", nessX, yss);
        chart.setBackgroundPaint((Paint)CHART_FRAME_COLOR);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        NumberAxis axis2 = new NumberAxis("Nominal P-value");
        axis2.setAutoRangeIncludesZero(false);
        plot.setRangeAxis(1, (ValueAxis)axis2);
        XYDatasetMultiTmp data_np = new XYDatasetMultiTmp(new String[]{"nominal p-value"}, nessX, new Vector[]{edb.getNPs()});
        plot.setDataset(1, (XYDataset)data_np);
        plot.mapDatasetToRangeAxis(1, 1);
        plot = (XYPlot)chart.getPlot();
        IntervalMarker target = new IntervalMarker(0.0, 25.0);
        target.setLabelAnchor(RectangleAnchor.LEFT);
        target.setPaint((Paint)GuiHelper.COLOR_LIGHT_YELLOW);
        plot.addRangeMarker((Marker)target, Layer.BACKGROUND);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setBaseShapesVisible(true);
            rr.setBaseShapesFilled(true);
            rr.setSeriesPaint(0, (Paint)Color.MAGENTA);
        }
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        renderer2.setSeriesPaint(0, (Paint)Color.BLACK);
        renderer2.setBaseShapesVisible(true);
        renderer2.setDrawSeriesLineAsPath(false);
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        LegendTitle legend1 = new LegendTitle((LegendItemSource)renderer);
        LegendTitle legend2 = new LegendTitle((LegendItemSource)renderer2);
        BlockContainer container = new BlockContainer((Arrangement)new BorderArrangement());
        container.add((Block)legend1, (Object)RectangleEdge.LEFT);
        container.add((Block)legend2, (Object)RectangleEdge.RIGHT);
        container.add((Block)new EmptyBlock(2000.0, 0.0));
        CompositeTitle legends = new CompositeTitle(container);
        legends.setPosition(RectangleEdge.BOTTOM);
        chart.addSubtitle((Title)legends);
        return new XChartImpl("pvalues_vs_nes_plot", "p-values vs. NES for " + edb.getName(), chart);
    }

    public static XChart createGlobalESHistogram(String phenotypeName, LabelledVector realEss) {
        int numBins = 20;
        if (realEss.getSize() < 20) {
            numBins = realEss.getSize();
        }
        JFreeChart chart = XChartUtils.createHistogram(phenotypeName, false, "Enrichment score (ES)", "# of gene sets", realEss.getScoresV(false), true, numBins, HistogramType.FREQUENCY);
        chart.getXYPlot().getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        return new XChartImpl("global_es_histogram", "Global histogram of ES for <b>" + phenotypeName + "</b>", chart);
    }

    public static XChart createESNullDistribHistogram(String gsetName, String classAName_opt, String classBName_opt, float realEs, Vector rndEss) {
        IntervalMarker target;
        int numBins = 20;
        if (rndEss.getSize() < 20) {
            numBins = rndEss.getSize();
        }
        JFreeChart chart = XChartUtils.createHistogram(gsetName + ": Random ES distribution", false, "ES", "P(ES)", rndEss, true, numBins, HistogramType.FREQUENCY);
        chart.setBackgroundPaint((Paint)CHART_FRAME_COLOR);
        chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)Color.MAGENTA);
        chart.getXYPlot().getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        ValueMarker midLine = new ValueMarker((double)realEs);
        midLine.setPaint((Paint)Color.BLACK);
        midLine.setStroke((Stroke)new BasicStroke(2.0f, 0, 0, 3.0f, new float[]{5.0f, 3.0f, 3.0f, 3.0f}, 0.0f));
        String label = "Real ES " + Printf.format(realEs, 1);
        midLine.setLabel(label);
        midLine.setLabelBackgroundColor(Color.WHITE);
        if (XMath.isPositive(realEs)) {
            midLine.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
        } else {
            midLine.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
        }
        chart.getXYPlot().addDomainMarker((Marker)midLine);
        float bias = 100.0f * ((float)rndEss.extract(ScoreMode.POS_ONLY).getSize() / (float)rndEss.getSize());
        XYTextAnnotation xyt = new XYTextAnnotation("Sets with pos scores: " + Printf.format(bias, 0) + "%", 0.0, 2.0);
        chart.getXYPlot().addAnnotation((XYAnnotation)xyt);
        if (classAName_opt != null && classAName_opt.length() > 0) {
            float max = rndEss.max() - 0.25f;
            target = new IntervalMarker((double)max, (double)max);
            target.setLabel("'" + classAName_opt + "' (Pos ES)");
            target.setLabelFont(new Font("SansSerif", 0, 10));
            target.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            target.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
            target.setLabelPaint((Paint)Color.RED);
            target.setLabelBackgroundColor(Color.WHITE);
            target.setOutlineStroke((Stroke)new BasicStroke(0.0f));
            target.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
            chart.getXYPlot().addDomainMarker((Marker)target);
        }
        if (classBName_opt != null && classBName_opt.length() > 0) {
            float min = rndEss.min() + 0.25f;
            target = new IntervalMarker((double)min, (double)min);
            target.setLabel("'" + classBName_opt + "' (Neg ES)");
            target.setLabelFont(new Font("SansSerif", 0, 10));
            target.setLabelAnchor(RectangleAnchor.TOP_LEFT);
            target.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            target.setLabelPaint((Paint)Color.BLUE);
            target.setLabelBackgroundColor(Color.WHITE);
            target.setOutlineStroke((Stroke)new BasicStroke(0.0f));
            target.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
            chart.getXYPlot().addDomainMarker((Marker)target);
        }
        return new XChartImpl("gset_rnd_es_dist", "Gene set null distribution of ES for <b>" + gsetName + "</b>", chart);
    }

    public static EnrichmentCharts _createComboChart(String gsetName, Vector enrichmentScoreProfile, Vector esProfile_full_opt, Vector hitIndices, RankedList rl, String classAName_opt, String classBName_opt, IntervalMarker[] markers, boolean horizontal) {
        XComboChart combo;
        if (enrichmentScoreProfile == null) {
            throw new IllegalArgumentException("Param scoreProfile cannot be null");
        }
        if (hitIndices == null) {
            throw new IllegalArgumentException("Param hitProfile cannot be null");
        }
        if (rl == null) {
            throw new IllegalArgumentException("Param rl cannot be null");
        }
        XChart chart0 = EnrichmentReports.createESProfileChart(enrichmentScoreProfile, esProfile_full_opt, hitIndices, horizontal);
        XChart chart1 = EnrichmentReports.createHitProfileChart(hitIndices, rl, true, false, horizontal);
        XChart chart2 = EnrichmentReports._createHitProfileChart(hitIndices, false, markers, horizontal);
        XChart chart3 = RankedListCharts.createRankedListChart(rl, classAName_opt, classBName_opt, enrichmentScoreProfile.maxDevFrom0Index(), horizontal);
        XYPlot plot = chart0.getFreeChart().getXYPlot();
        plot.setAxisOffset(new RectangleInsets(-1.0, 0.0, 0.0, 0.0));
        plot.setOutlineStroke((Stroke)new BasicStroke(0.5f, 2, 0));
        plot.setOutlinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        plot = chart1.getFreeChart().getXYPlot();
        plot.setAxisOffset(new RectangleInsets(-1.0, 0.0, 0.0, 0.0));
        plot.setOutlineStroke((Stroke)new BasicStroke(0.5f, 2, 0));
        plot.setOutlinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        plot = chart2.getFreeChart().getXYPlot();
        plot.setAxisOffset(new RectangleInsets(-1.0, 0.0, 0.0, 0.0));
        plot.setOutlineStroke((Stroke)new BasicStroke(0.5f, 2, 0));
        plot.setOutlinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        plot = chart3.getFreeChart().getXYPlot();
        plot.setAxisOffset(new RectangleInsets(-1.0, 0.0, 0.0, 0.0));
        plot.setOutlineStroke((Stroke)new BasicStroke(0.5f, 2, 0));
        plot.setOutlinePaint((Paint)Color.GRAY);
        plot.getDomainAxis().setAxisLineVisible(true);
        plot.getDomainAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getDomainAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        plot.getRangeAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        if (horizontal) {
            XComboDomainChart cd = new XComboDomainChart(ENPLOT_ + gsetName, "Enrichment plot: " + gsetName, "Profile of the Running ES Score & Positions of GeneSet Members on the Rank Ordered List", "Rank in Ordered Dataset", new XChart[]{chart0, chart1, chart2, chart3}, new int[]{12, 4, 1, 8});
            cd.getCombinedXYPlot().setGap(0.0);
            cd.getCombinedXYPlot().getDomainAxis().setTickLabelsVisible(true);
            cd.getCombinedXYPlot().getDomainAxis().setTickMarksVisible(true);
            cd.getCombinedXYPlot().getDomainAxis().setTickMarkStroke((Stroke)new BasicStroke(1.0f));
            cd.getCombinedXYPlot().getDomainAxis().setTickMarkPaint((Paint)Color.GRAY);
            combo = cd;
        } else {
            XComboRangeChart cr = new XComboRangeChart(ENPLOT_ + gsetName, "Enrichment plot: " + gsetName, "Profile of the Running ES Score & Positions of GeneSet Members on the Rank Ordered List", "Rank in Ordered Dataset", new XChart[]{chart0, chart1, chart2, chart3}, new int[]{12, 4, 1, 8});
            cr.getCombinedXYPlot().setGap(0.0);
            cr.getCombinedXYPlot().getRangeAxis().setTickLabelsVisible(true);
            cr.getCombinedXYPlot().getRangeAxis().setTickMarksVisible(true);
            cr.getCombinedXYPlot().getRangeAxis().setTickMarkStroke((Stroke)new BasicStroke(1.0f));
            cr.getCombinedXYPlot().getRangeAxis().setTickMarkPaint((Paint)Color.GRAY);
            combo = cr;
        }
        return new EnrichmentCharts(chart0, chart1, chart2, chart3, combo);
    }

    public static XChart createESProfileChart(Vector esProfile, Vector esProfile_full_opt, Vector hitIndices, boolean horizontal) {
        JFreeChart chart;
        Object data;
        if (esProfile_full_opt == null) {
            data = new EsProfileDataset("Enrichment profile", esProfile, hitIndices, horizontal);
            chart = ChartFactory.createXYLineChart((String)"Enrichment profile", (String)"Enrichment profile", (String)"Running enrichment score (RES)", (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        } else {
            data = new EsProfileDataset2("Enrichment profile", esProfile_full_opt, horizontal);
            chart = ChartFactory.createXYLineChart((String)"Enrichment profile", (String)"Enrichment profile", (String)"Running enrichment score (RES)", (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        XYPlot plot = chart.getXYPlot();
        plot.getRangeAxis().setTickLabelsVisible(true);
        plot.getRangeAxis().setTickMarksVisible(true);
        plot.getRangeAxis().setTickMarkStroke((Stroke)new BasicStroke(1.0f));
        plot.getRangeAxis().setTickMarkPaint((Paint)Color.GRAY);
        plot.getDomainAxis().setTickLabelsVisible(true);
        plot.getDomainAxis().setTickMarksVisible(true);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        if (horizontal) {
            plot.getRangeAxis().setLabel("Enrichment score (ES)");
            plot.getDomainAxis().setLabel("Position in ranked list");
            plot.getDomainAxis().setVisible(true);
        } else {
            plot.getDomainAxis().setLabel("Enrichment score (ES)");
            plot.getRangeAxis().setLabel("Position in ranked list");
            plot.getRangeAxis().setVisible(true);
        }
        plot.getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        ValueMarker midLine = new ValueMarker(0.0);
        midLine.setPaint((Paint)Color.DARK_GRAY);
        if (horizontal) {
            plot.addRangeMarker((Marker)midLine);
        } else {
            plot.addDomainMarker((Marker)midLine);
        }
        return new XChartImpl("Enrichment profile", "Enrichment profile", chart);
    }

    private static Vector _hitIndices2Vector(int numRows, int[] hitIndices) {
        Vector v = new Vector(numRows);
        for (int i = 0; i < hitIndices.length; ++i) {
            v.setElement(hitIndices[i], 1.0f);
        }
        return v;
    }

    private static File _getGeneSetSizesFile(GeneSet[] gsets_restricted_to_dataset, GeneSet[] origGeneSets, File geneSets_sizes_file, ToolReport report) {
        if (geneSets_sizes_file == null) {
            try {
                String[] colNames = new String[]{"ORIGINAL SIZE", "AFTER RESTRICTING TO DATASET", "STATUS"};
                String[] rowNames = new String[origGeneSets.length];
                StringMatrix sm = new StringMatrix(origGeneSets.length, colNames.length);
                DefaultGeneSetMatrix tmp = new DefaultGeneSetMatrix("after", gsets_restricted_to_dataset);
                for (int r = 0; r < origGeneSets.length; ++r) {
                    String gsetName;
                    rowNames[r] = gsetName = AuxUtils.getAuxNameOnlyNoHash(origGeneSets[r].getName());
                    sm.setElement(r, 0, origGeneSets[r].getNumMembers());
                    if (tmp.containsSet(gsetName)) {
                        sm.setElement(r, 1, tmp.getGeneSet(gsetName).getNumMembers());
                        continue;
                    }
                    sm.setElement(r, 2, "Rejected!");
                }
                geneSets_sizes_file = report.savePageXls(new StringDataframe("gene_set_sizes", sm, rowNames, colNames, true));
            }
            catch (Throwable t) {
                klog.error((Object)t);
                geneSets_sizes_file = report.createFile("gene_set_sizes_errored_out.txt", "List of gene sets that errored out");
                try {
                    FileUtils.writeStringToFile((File)geneSets_sizes_file, (String)t.getStackTrace().toString());
                }
                catch (IOException ie) {
                    klog.error((Object)ie);
                }
            }
        }
        return geneSets_sizes_file;
    }

    public static XChart createButterflyChart(PermutationTest ptest) {
        int r;
        ArrayList<Vector> xValues = new ArrayList<Vector>();
        Dataset pos_sig_levels = ptest.getSigLevels(true);
        Dataset neg_sig_levels = ptest.getSigLevels(false);
        Vector yValues = new Vector(ptest.getNumMarkers());
        for (int i = 0; i < ptest.getNumMarkers(); ++i) {
            yValues.setElement(i, i + 1);
        }
        float[] sigLevels = ptest.getSigLevels();
        ArrayList<Object> xLabels = new ArrayList<Object>();
        xLabels.add("Observed pos");
        xLabels.add("Observed neg");
        RankedList rlReal = ptest.getRankedList();
        Vector x1 = new Vector(ptest.getNumMarkers());
        for (r = 0; r < ptest.getNumMarkers(); ++r) {
            x1.setElement(r, rlReal.getScore(r));
        }
        xValues.add(x1);
        r = rlReal.getSize() - 1;
        x1 = new Vector(ptest.getNumMarkers());
        int cnt = 0;
        while (cnt < ptest.getNumMarkers()) {
            x1.setElement(cnt, rlReal.getScore(r));
            ++cnt;
            --r;
        }
        xValues.add(x1);
        for (int c = 0; c < pos_sig_levels.getNumCol(); ++c) {
            xValues.add(pos_sig_levels.getColumn(c));
            xValues.add(neg_sig_levels.getColumn(c));
            xLabels.add("Permuted pos " + Printf.format(sigLevels[c] * 100.0f, 0) + "%");
            xLabels.add("Permuted neg " + Printf.format(sigLevels[c] * 100.0f, 0) + "%");
        }
        String classAName = null;
        String classBName = null;
        if (ptest.getTemplate().isCategorical()) {
            classAName = ptest.getTemplate().getClassName(0);
            classBName = ptest.getTemplate().getClassName(1);
        }
        return new XChartImpl("butterfly_plot", "Butterfly plot of significance", EnrichmentReports._createButterflyChart("Butterfly plot for: " + ptest.getName(), "Score (" + ptest.getMetric().getName() + ")", xValues.toArray(new Vector[xValues.size()]), xLabels.toArray(new String[xLabels.size()]), "Gene rank", yValues, classAName, classBName));
    }

    private static JFreeChart _createButterflyChart(String chartTitle, String xaxisLabel, Vector[] xValues, String[] xNames, String yaxisLabel, Vector yValues, String classAName_opt, String classBName_opt) {
        IntervalMarker target;
        if (xNames.length != xValues.length) {
            throw new IllegalArgumentException("Unequal lengths for xvectors: " + xValues.length + " and xlabels: " + xNames);
        }
        XYSeries[] serieses = new XYSeries[xValues.length];
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (int i = 0; i < xValues.length; ++i) {
            serieses[i] = new XYSeries((Comparable)((Object)xNames[i]));
            for (int j = 0; j < xValues[i].getSize(); ++j) {
                serieses[i].add((double)xValues[i].getElement(j), (double)yValues.getElement(j));
            }
            dataset.addSeries(serieses[i]);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)chartTitle, (String)xaxisLabel, (String)yaxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getTitle().setFont(new Font("SansSerif", 1, 16));
        chart.getLegend().setBorder(1.0, 1.0, 1.0, 1.0);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.BLUE);
        renderer.setSeriesShape(0, EnrichmentReports.createCircleShape());
        renderer.setSeriesShape(1, EnrichmentReports.createCircleShape());
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesLinesVisible(1, false);
        ArrayList<Color> colors = new ArrayList<Color>(Arrays.asList(Color.BLACK, Color.PINK, Color.GREEN));
        int ii = 0;
        for (int i = 2; i < serieses.length; i += 2) {
            renderer.setSeriesShapesVisible(i, false);
            renderer.setSeriesShapesVisible(i + 1, false);
            Paint color = ii < colors.size() ? (Color)colors.get(ii) : renderer.getSeriesPaint(i);
            renderer.setSeriesPaint(i, color);
            renderer.setSeriesPaint(i + 1, color);
            ++ii;
        }
        plot.setRenderer(0, (XYItemRenderer)renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        float pos = yValues.max() / 2.0f;
        if (classAName_opt != null && classAName_opt.length() > 0) {
            target = new IntervalMarker((double)pos, (double)pos);
            target.setLabel("'" + classAName_opt + "' (Pos corr)");
            target.setLabelFont(new Font("SansSerif", 0, 10));
            target.setLabelAnchor(RectangleAnchor.RIGHT);
            target.setLabelTextAnchor(TextAnchor.CENTER_RIGHT);
            target.setLabelPaint((Paint)Color.RED);
            target.setLabelBackgroundColor(Color.WHITE);
            target.setOutlineStroke((Stroke)new BasicStroke(0.0f));
            target.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
            chart.getXYPlot().addRangeMarker((Marker)target);
        }
        if (classBName_opt != null && classBName_opt.length() > 0) {
            target = new IntervalMarker((double)pos, (double)pos);
            target.setLabel("'" + classBName_opt + "' (Neg corr)");
            target.setLabelFont(new Font("SansSerif", 0, 10));
            target.setLabelAnchor(RectangleAnchor.LEFT);
            target.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
            target.setLabelPaint((Paint)Color.BLUE);
            target.setLabelBackgroundColor(Color.WHITE);
            target.setOutlineStroke((Stroke)new BasicStroke(0.0f));
            target.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
            chart.getXYPlot().addRangeMarker((Marker)target);
        }
        return chart;
    }

    static class EsProfileDataset2
    implements XYDataset {
        private DatasetGroup fGroup = new DatasetGroup();
        private String[] fSeriesNames;
        private boolean fHorizontal;
        private Vector fEsProfile;

        public EsProfileDataset2(String seriesName, Vector esProfile, boolean horizontal) {
            this.fSeriesNames = new String[]{seriesName};
            this.fHorizontal = horizontal;
            this.fEsProfile = esProfile;
        }

        public double getYValue(int series, int item) {
            if (this.fHorizontal) {
                return this.fEsProfile.getElement(item);
            }
            return item;
        }

        public double getXValue(int series, int item) {
            if (this.fHorizontal) {
                return item;
            }
            return this.fEsProfile.getElement(item);
        }

        public int getItemCount(int series) {
            return this.fEsProfile.getSize();
        }

        public String toString() {
            return this.fSeriesNames[0];
        }

        public int getSeriesCount() {
            return this.fSeriesNames.length;
        }

        public DatasetGroup getGroup() {
            return this.fGroup;
        }

        public void setGroup(DatasetGroup g) {
            this.fGroup = g;
        }

        public int indexOf(Comparable comparable) {
            return 0;
        }

        public Number getX(int i, int i1) {
            throw new NotImplementedException();
        }

        public Number getY(int i, int i1) {
            throw new NotImplementedException();
        }

        public void addChangeListener(DatasetChangeListener listener) {
        }

        public void removeChangeListener(DatasetChangeListener listener) {
        }

        public DomainOrder getDomainOrder() {
            return DomainOrder.NONE;
        }

        public Comparable getSeriesKey(int series) {
            if (this.fSeriesNames == null) {
                throw new IllegalStateException("Dataset has no series");
            }
            return this.fSeriesNames[series];
        }
    }

    static class EsProfileDataset
    implements XYDataset {
        private DatasetGroup fGroup;
        private String[] fSeriesNames;
        private TIntFloatHashMap fYValues;
        private TIntFloatHashMap fJustHitIndices;
        private boolean fHorizontal;

        protected EsProfileDataset() {
        }

        public EsProfileDataset(String seriesName, Vector esProfile, Vector hitIndices_all, boolean horizontal) {
            this.fGroup = new DatasetGroup();
            this.fSeriesNames = new String[]{seriesName};
            this.fHorizontal = horizontal;
            this.fYValues = new TIntFloatHashMap();
            this.fJustHitIndices = new TIntFloatHashMap();
            int cnt = 0;
            if (hitIndices_all.getElement(0) != 1.0f) {
                this.fYValues.put(0, 0.0f);
                this.fJustHitIndices.put(0, 0.0f);
                ++cnt;
            }
            int numFound = 0;
            for (int r = 0; r < hitIndices_all.getSize(); ++r) {
                if (hitIndices_all.getElement(r) != 1.0f) continue;
                this.fYValues.put(cnt, esProfile.getElement(numFound));
                this.fJustHitIndices.put(cnt, (float)r);
                ++cnt;
                ++numFound;
            }
            int lastRank = hitIndices_all.getSize() - 1;
            if (hitIndices_all.getElement(lastRank) != 1.0f) {
                this.fYValues.put(cnt, 0.0f);
                this.fJustHitIndices.put(cnt, (float)lastRank);
            }
            if (numFound != esProfile.getSize()) {
                throw new IllegalStateException("numFound: " + numFound + " esProfile: " + esProfile.getSize());
            }
        }

        public double getYValue(int series, int item) {
            if (this.fHorizontal) {
                return this.fYValues.get(item);
            }
            return this.fJustHitIndices.get(item);
        }

        public double getXValue(int series, int item) {
            if (this.fHorizontal) {
                return this.fJustHitIndices.get(item);
            }
            return this.fYValues.get(item);
        }

        public int getItemCount(int series) {
            return this.fYValues.size();
        }

        public String toString() {
            return this.fSeriesNames[0];
        }

        public int getSeriesCount() {
            return this.fSeriesNames.length;
        }

        public DatasetGroup getGroup() {
            return this.fGroup;
        }

        public void setGroup(DatasetGroup g) {
            this.fGroup = g;
        }

        public int indexOf(Comparable comparable) {
            return 0;
        }

        public Number getX(int i, int i1) {
            throw new NotImplementedException();
        }

        public Number getY(int i, int i1) {
            throw new NotImplementedException();
        }

        public void addChangeListener(DatasetChangeListener listener) {
        }

        public void removeChangeListener(DatasetChangeListener listener) {
        }

        public DomainOrder getDomainOrder() {
            return DomainOrder.NONE;
        }

        public Comparable getSeriesKey(int series) {
            if (this.fSeriesNames == null) {
                throw new IllegalStateException("Dataset has no series");
            }
            return this.fSeriesNames[series];
        }
    }

    static class MyEnrichmentReportImpl
    implements EnrichmentReport {
        private File fPlotFile;
        private File fHtmlFile;
        private EnrichmentCharts fPlot;
        private HtmlPage fHtmlPage;
        private ExcelTxtPage fExcelPage;

        MyEnrichmentReportImpl() {
        }

        @Override
        public File getESPlotFile() {
            return this.fPlotFile;
        }

        @Override
        public File getHtmlFile() {
            return this.fHtmlFile;
        }
    }

    public static class BasicReportStruc {
        public RichDataframe rdf;
        public EnrichmentReport[] reports;
    }

    public static class Ret {
        public EnrichmentReportDbImpl rdb;
        public EnrichmentDb edb;
        public File savedInDir;
    }
}

