/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class StringDataframeParser
extends AbstractParser {
    public StringDataframeParser() {
        super(StringDataframe.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        PrintWriter pw = this.startExport(pob, file);
        this._export(pob, pw);
    }

    @Override
    public void export(PersistentObject pob, OutputStream os) throws Exception {
        PrintWriter pw = this.startExport(pob, os, null);
        this._export(pob, pw);
    }

    private void _export(PersistentObject pob, PrintWriter pw) throws Exception {
        StringDataframe sdf = (StringDataframe)pob;
        String s = sdf.getRowLabelName();
        if (s == null) {
            s = "NAME";
        }
        pw.print(s + "\t");
        for (int i = 0; i < sdf.getNumCol(); ++i) {
            pw.print(sdf.getColumnName(i));
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < sdf.getNumRow(); ++r) {
            pw.print(sdf.getRowName(r));
            pw.print('\t');
            int len = sdf.getNumCol();
            for (int c = 0; c < len; ++c) {
                pw.print(sdf.getElement(r, c));
                pw.print('\t');
            }
            pw.println();
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List<PersistentObject> parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        StringDataframe sdf = this.parseSdf(sourcepath, bin);
        return StringDataframeParser.unmodlist(new PersistentObject[]{sdf});
    }

    private StringDataframe parseSdf(String objname, BufferedReader bin) throws Exception {
        return this.parseSdf(objname, bin, this.nextNonEmptyLine(bin));
    }

    public StringDataframe parseSdf(String objname, BufferedReader bin, String firstLine) throws Exception {
        String currLine = firstLine;
        List<String> colNames = ParseUtils.string2stringsList(currLine, "\t");
        colNames.remove(0);
        ArrayList<String> lines = new ArrayList<String>();
        currLine = this.nextLineTrimless(bin);
        while (currLine != null) {
            lines.add(currLine);
            currLine = this.nextLineTrimless(bin);
        }
        StringDataframe sdf = this._parse(objname, lines, colNames);
        bin.close();
        this.doneImport();
        return sdf;
    }

    private StringDataframe _parse(String objname, List<String> lines, List<String> colNames) throws Exception {
        StringMatrix matrix = new StringMatrix(lines.size(), colNames.size());
        ArrayList<String> rowNames = new ArrayList<String>();
        String nstr = null;
        for (int i = 0; i < lines.size(); ++i) {
            String currLine = lines.get(i);
            List fields = StringDataframeParser.string2stringsV2(currLine, colNames.size() + 1);
            if (fields.size() != colNames.size() + 1) {
                throw new ParserException("Bad format - expect ncols: " + (colNames.size() + 1) + " but found: " + fields.size() + " on line: " + currLine);
            }
            String rowname = (String)fields.get(0);
            rowNames.add(rowname);
            for (int f = 1; f < fields.size(); ++f) {
                String elem = fields.get(f).toString();
                if (elem.equalsIgnoreCase("NULL")) {
                    matrix.setElement(i, f - 1, nstr);
                    continue;
                }
                matrix.setElement(i, f - 1, elem);
            }
        }
        StringDataframe sdf = new StringDataframe(objname, matrix, rowNames, colNames, true);
        sdf.addComment(this.fComment.toString());
        return sdf;
    }
}

