/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.PreTemplateImpl;
import edu.mit.broad.genome.objects.ProbePreTemplate;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.utils.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ClsParser
extends AbstractParser
implements Constants {
    private int[] fHdrInts;
    private int fItemCnt;

    public ClsParser() {
        super(Template.class);
    }

    @Override
    public void export(PersistentObject template, File file) throws Exception {
        PrintWriter pw = this.startExport(template, file);
        pw.println(((Template)template).getAsString(false));
        pw.close();
        this.doneExport();
    }

    public void export(PersistentObject template, boolean gcFormat, File file) throws Exception {
        PrintWriter pw = this.startExport(template, file);
        pw.println(((Template)template).getAsString(gcFormat));
        pw.close();
        this.doneExport();
    }

    private boolean isNumericLine(String firstline) {
        if (firstline == null) {
            throw new IllegalArgumentException("No content in cls file");
        }
        boolean isNum = (firstline = firstline.trim()).equalsIgnoreCase("#numeric");
        if (!isNum) {
            isNum = firstline.equalsIgnoreCase("# numeric");
        }
        return isNum;
    }

    private boolean isProbesLine(String firstline) {
        if (firstline == null) {
            throw new IllegalArgumentException("No content in cls file");
        }
        firstline = firstline.trim();
        return firstline.equalsIgnoreCase("#probes");
    }

    private List parseContinuousTemplate(String fileName, BufferedReader bin) throws IOException, ParserException {
        HashMap<String, String> nameProfileMap = new HashMap<String, String>();
        String currLine = this.nextNonEmptyLine(bin);
        while (currLine != null) {
            if (currLine.startsWith("#")) {
                String profileLine = this.nextNonEmptyLine(bin);
                if (profileLine == null) {
                    throw new ParserException("Bad cls data format - missing profile line for: " + currLine);
                }
                if (profileLine.length() == 0 || profileLine.startsWith("#")) {
                    throw new ParserException("Bad cls data format - missing profile line for: " + currLine);
                }
                nameProfileMap.put(currLine, profileLine);
            }
            currLine = this.nextNonEmptyLine(bin);
        }
        Iterator it = nameProfileMap.keySet().iterator();
        ArrayList<Template> templates = new ArrayList<Template>();
        while (it.hasNext()) {
            String name = (String)it.next();
            String profile = (String)nameProfileMap.get(name);
            float[] floats = ParseUtils.string2floats(profile);
            name = name.substring(1, name.length());
            Template t = TemplateFactory.createContinuousTemplate(fileName + "#" + name, new Vector(floats));
            templates.add(t);
        }
        this.log.info((Object)"Completed parsing NUMERIC CLS file");
        return Collections.unmodifiableList(templates);
    }

    private List parseProbeTemplate(String fileName, BufferedReader bin) throws IOException {
        String currLine = this.nextNonEmptyLine(bin);
        ArrayList<ProbePreTemplate> probePreTemplates = new ArrayList<ProbePreTemplate>();
        while (currLine != null) {
            probePreTemplates.add(new ProbePreTemplate(fileName, currLine));
            currLine = this.nextNonEmptyLine(bin);
        }
        return probePreTemplates;
    }

    @Override
    public List parse(String fileName, InputStream is) throws Exception {
        this.startImport(fileName);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String firstLine = this.nextNonEmptyLine(bin);
        if (firstLine == null) {
            throw new ParserException("Bad format for cls fike - check lines 1 and 2 --- they seem to have no content");
        }
        if (this.isProbesLine(firstLine)) {
            return this.parseProbeTemplate(fileName, bin);
        }
        if (this.isNumericLine(firstLine)) {
            return this.parseContinuousTemplate(fileName, bin);
        }
        StringTokenizer tok = new StringTokenizer(firstLine, " \t");
        boolean oldStyle = false;
        try {
            if (tok.countTokens() == 3) {
                Float.parseFloat(tok.nextToken());
                Float.parseFloat(tok.nextToken());
                Float.parseFloat(tok.nextToken());
                oldStyle = true;
            }
        }
        catch (NumberFormatException nfe) {
            oldStyle = false;
        }
        if (oldStyle) {
            return this._parse_genecluster_style_categorical(fileName, bin, firstLine);
        }
        return this._parse_new_style(fileName, bin, firstLine);
    }

    private List _parse_genecluster_style_categorical(String sourcepath, BufferedReader bin, String firstLine) throws Exception {
        String currLine = firstLine;
        boolean continuous = false;
        this.fHdrInts = this.parseHeaderLine(currLine);
        currLine = this.nextNonEmptyLine(bin);
        Template.Class[] classes = this.generateClasses(currLine);
        currLine = this.nextLine(bin);
        Template.Item[] items = this.generateItems(currLine);
        Template template = TemplateFactory.createTemplate(sourcepath, items, classes, continuous);
        template.addComment(this.fComment.toString());
        this.doSanityChecks(template);
        this.doneImport();
        return ClsParser.unmodlist(template);
    }

    private List _parse_new_style(String sourceFileName, BufferedReader buf, String firstLine) throws Exception {
        StringDataframe sdf = new StringDataframeParser().parseSdf(sourceFileName, buf, firstLine);
        String[] sampleNames = sdf.getRowNamesArray();
        ArrayList<PreTemplateImpl> preTemplates = new ArrayList<PreTemplateImpl>();
        for (int c = 0; c < sdf.getNumCol(); ++c) {
            String colName = sdf.getColumnName(c);
            if (colName == null || colName.length() == 0) {
                throw new ParserException("Bad column identifier (it was null or empty) >" + colName + "< at column: " + (c + 1));
            }
            if (ClsParser.isCommentColumn(colName)) continue;
            if (ClsParser.isNumericColumn(colName)) {
                preTemplates.add(ClsParser._createNumericPreTemplate(sourceFileName, colName, sampleNames, sdf.getColumn(c)));
                continue;
            }
            preTemplates.add(ClsParser._createCategoricalPreTemplate(sourceFileName, colName, sampleNames, sdf.getColumn(c)));
        }
        this.doneImport();
        return preTemplates;
    }

    private int[] parseHeaderLine(String line) throws Exception {
        char theDelim = ParseUtils.getDelim(line);
        int[] inds = new int[3];
        try {
            ParseUtils.splitIntegers(line, theDelim, inds);
        }
        catch (ParseException e) {
            throw new ParserException(e);
        }
        if (inds.length != 3) {
            throw new ParserException("Missing data in header " + line + " found only " + inds.length + " fields .. expecting 3");
        }
        return inds;
    }

    private Template.Class[] generateClasses(String currLine) throws ParserException {
        if (currLine.startsWith("#")) {
            currLine = currLine.substring(1, currLine.length());
            currLine = currLine.trim();
            StringTokenizer st = new StringTokenizer(currLine, " \t");
            Template.Class[] cls = new Template.Class[st.countTokens()];
            int cnt = 0;
            while (st.hasMoreTokens()) {
                cls[cnt++] = new TemplateImpl.ClassImpl(st.nextToken().trim());
            }
            return cls;
        }
        throw new ParserException("Bad format in cls file - expected the line to be of the form '# foo bar ...'");
    }

    private Template.Item[] generateItems(String currLine) {
        this.fItemCnt = 0;
        if (currLine == null) {
            throw new NullPointerException("Bad cls data format -- check the item descriptor line (line 2)");
        }
        StringTokenizer st = new StringTokenizer(currLine, " \t");
        Template.Item[] items = new Template.Item[st.countTokens()];
        if (!this.isSilentMode()) {
            this.log.debug((Object)("# of items = " + st.countTokens()));
        }
        while (st.hasMoreTokens()) {
            String className = st.nextToken().trim();
            items[this.fItemCnt] = TemplateImpl.ItemImpl.createItem(className, this.fItemCnt);
            ++this.fItemCnt;
        }
        return items;
    }

    private void doSanityChecks(Template template) throws ParserException {
        if (template.getNumItems() != this.fHdrInts[0]) {
            throw new ParserException("Number of items found in cls data " + this.fItemCnt + " is not equal to the number specified on the header line " + this.fHdrInts[0]);
        }
        if (template.getNumClasses() != this.fHdrInts[1]) {
            throw new ParserException("Number of classes found in cls data " + template.getNumClasses() + " is not equal to the number of classes specified on the header line " + this.fHdrInts[1]);
        }
    }

    private static PreTemplateImpl _createNumericPreTemplate(String sourceFileName, String name, String[] sampleNames, String[] values) {
        ArrayList<PreTemplateImpl.NumPair> pairs = new ArrayList<PreTemplateImpl.NumPair>();
        for (int i = 0; i < sampleNames.length; ++i) {
            if (sampleNames[i] == null || values[i] == null) continue;
            pairs.add(new PreTemplateImpl.NumPair(sampleNames[i], values[i]));
        }
        return new PreTemplateImpl(sourceFileName, name, pairs.toArray(new PreTemplateImpl.Pair[pairs.size()]), true);
    }

    private static PreTemplateImpl _createCategoricalPreTemplate(String sourceFileName, String name, String[] sampleNames, String[] values) {
        ArrayList<PreTemplateImpl.StringPair> pairs = new ArrayList<PreTemplateImpl.StringPair>();
        for (int i = 0; i < sampleNames.length; ++i) {
            if (sampleNames[i] == null || values[i] == null) continue;
            pairs.add(new PreTemplateImpl.StringPair(sampleNames[i], values[i]));
        }
        return new PreTemplateImpl(sourceFileName, name, pairs.toArray(new PreTemplateImpl.Pair[pairs.size()]), false);
    }

    private static boolean isCommentColumn(String colName) {
        return colName.equalsIgnoreCase("COMMENT") || colName.equalsIgnoreCase("COMMENTS");
    }

    private static boolean isNumericColumn(String colName) {
        return colName.equalsIgnoreCase("NUMERIC") || colName.equalsIgnoreCase("FLOAT");
    }
}

