/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import org.apache.log4j.Logger;

public class DefaultMetricWeightStruc
implements MetricWeightStruc {
    private float fTotalPosWeight;
    private float fTotalNegWeight;
    private int fTotalPosLength;
    private int fTotalNegLength;
    private String fMetricName;
    private static final Logger klog = Logger.getLogger(DefaultMetricWeightStruc.class);

    public DefaultMetricWeightStruc(String metricName, RankedList rl) {
        if (rl == null) {
            throw new IllegalArgumentException("Param rl cannot be null");
        }
        this.fMetricName = metricName;
        for (int r = 0; r < rl.getSize(); ++r) {
            float score = rl.getScore(r);
            if (XMath.isNegative(score)) {
                this.fTotalNegWeight += score;
                ++this.fTotalNegLength;
                continue;
            }
            this.fTotalPosWeight += score;
            ++this.fTotalPosLength;
        }
    }

    public DefaultMetricWeightStruc(String metricName, LabelledVector lv) {
        if (lv == null) {
            throw new IllegalArgumentException("Param lv cannot be null");
        }
        for (int r = 0; r < lv.getSize(); ++r) {
            float score = lv.getScore(r);
            if (XMath.isNegative(score)) {
                this.fTotalNegWeight += score;
                ++this.fTotalNegLength;
                continue;
            }
            this.fTotalPosWeight += score;
            ++this.fTotalPosLength;
        }
        this.fMetricName = metricName;
    }

    @Override
    public String getMetricName() {
        return this.fMetricName;
    }

    @Override
    public void setMetricName(String name) {
        if (this.fMetricName != null) {
            klog.warn((Object)("Overwriting metric: " + this.fMetricName + " with: " + name));
            TraceUtils.showTrace();
        }
        this.fMetricName = name;
    }

    public float getTotalPosWeight() {
        return this.fTotalPosWeight;
    }

    public float getTotalNegWeight() {
        return this.fTotalNegWeight;
    }

    @Override
    public int getTotalPosLength() {
        return this.fTotalPosLength;
    }

    @Override
    public int getTotalNegLength() {
        return this.fTotalNegLength;
    }

    public float getTotalWeight() {
        return this.getTotalPosWeight() + Math.abs(this.getTotalNegWeight());
    }

    public int getTotalLength() {
        return this.getTotalPosLength() + this.getTotalNegLength();
    }

    @Override
    public float getTotalNegLength_frac() {
        return (float)this.getTotalNegLength() / (float)this.getTotalLength();
    }

    @Override
    public float getTotalPosLength_frac() {
        return (float)this.getTotalPosLength() / (float)this.getTotalLength();
    }

    @Override
    public float getTotalNegWeight_frac() {
        return Math.abs(this.getTotalNegWeight() / this.getTotalWeight());
    }

    @Override
    public float getTotalPosWeight_frac() {
        return this.getTotalPosWeight() / this.getTotalWeight();
    }
}

