/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.AbstractEnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class EnrichmentDbImpl_one_shared_rl
extends AbstractEnrichmentDb {
    private EnrichmentResult[] fResults;
    private RankedList fRankedList_shared;
    private Template fTemplate_opt_shared;
    private Dataset fDataset_shared;
    private Chip fChip_shared;

    public EnrichmentDbImpl_one_shared_rl(String name, RankedList ranked_list_shared, Dataset ds_shared_opt, Template template_shared_opt, EnrichmentResult[] results, LabelledVectorProcessor lvp, Metric metric, Map metricParams, SortMode sort, Order order, int numPerm, File edb_dir_opt) {
        this.initHere(name, ranked_list_shared, ds_shared_opt, template_shared_opt, results, lvp, metric, metricParams, sort, order, numPerm, edb_dir_opt);
    }

    public EnrichmentDbImpl_one_shared_rl(String name, EnrichmentResult[] results, Dataset ds_shared_opt, LabelledVectorProcessor lvp, Metric metric, Map metricParams, SortMode sort, Order order, int numPerm, File edb_dir_opt) {
        this(name, EnrichmentDbImpl_one_shared_rl._rl_shared(results), ds_shared_opt, EnrichmentDbImpl_one_shared_rl.template_shared(results), results, lvp, metric, metricParams, sort, order, numPerm, edb_dir_opt);
    }

    private void initHere(String name, RankedList ranked_list_shared, Dataset ds_shared_opt, Template template_shared_opt, EnrichmentResult[] results, LabelledVectorProcessor lvp, Metric metric, Map metricParams, SortMode sort, Order order, int numPerms, File edb_dir_opt) {
        if (results == null) {
            throw new IllegalArgumentException("Param results cannot be null");
        }
        if (ranked_list_shared == null) {
            throw new IllegalArgumentException("Shared ranked list cannot be null");
        }
        this.fResults = results;
        this.fRankedList_shared = ranked_list_shared;
        this.fTemplate_opt_shared = template_shared_opt;
        this.fDataset_shared = ds_shared_opt;
        if (this.fDataset_shared != null) {
            this.fChip_shared = this.fDataset_shared.getAnnot().getChip();
        }
        super.init(name, lvp, metric, metricParams, sort, order, numPerms, edb_dir_opt);
        super.initResultMaps();
    }

    @Override
    public EnrichmentDb cloneDeep(EnrichmentResult[] results) {
        return new EnrichmentDbImpl_one_shared_rl(this.getName(), this.getRankedList(), this.getDataset(), this.getTemplate(), results, this.getRankedListProcessor(), this.getMetric(), this.getMetricParams(), this.getSortMode(), this.getOrder(), this.getNumPerm(), this.getEdbDir());
    }

    @Override
    public Template getTemplate() {
        return this.fTemplate_opt_shared;
    }

    @Override
    public Dataset getDataset() {
        return this.fDataset_shared;
    }

    @Override
    public RankedList getRankedList() {
        return this.fRankedList_shared;
    }

    @Override
    public EnrichmentResult[] getResults() {
        return this.fResults;
    }

    @Override
    public List getResultsList() {
        return Arrays.asList(this.fResults);
    }

    private static RankedList _rl_shared(EnrichmentResult[] results) {
        Errors errors = new Errors();
        String theName = results[0].getRankedList().getName();
        int theSize = results[0].getRankedList().getSize();
        for (int r = 0; r < results.length; ++r) {
            String name = results[r].getRankedList().getName();
            int size = results[r].getRankedList().getSize();
            if (!name.equals(theName)) {
                errors.add("Mismatched rl theName: " + theName + " name: " + name + " at r: " + r + " # rls: " + results.length);
            }
            if (size == theSize) continue;
            errors.add("Mismatched rl theName: " + theName + " name: " + name + " at r: " + r + " # rls: " + results.length);
        }
        errors.barfIfNotEmptyRuntime();
        return results[0].getRankedList();
    }

    private static Template template_shared(EnrichmentResult[] results) {
        Errors errors = new Errors();
        if (results[0].getTemplate() == null) {
            return null;
        }
        String theName = results[0].getTemplate().getName();
        for (int r = 0; r < results.length; ++r) {
            String name = results[r].getTemplate().getName();
            if (name.equals(theName)) continue;
            errors.add("Mismatched template theName: " + theName + " name: " + name + " at r: " + r + " # results: " + results.length);
        }
        errors.barfIfNotEmptyRuntime();
        return results[0].getTemplate();
    }
}

