/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.objects.AbstractTemplate;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.utils.ColorUtils;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TIntObjectHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;

public class TemplateImpl
extends AbstractTemplate {
    private ArrayList fClasses;
    private ArrayList fItems;
    private boolean fContinuous;
    private boolean fImmutable = false;
    private int fCoi = 0;
    private boolean fAux;
    static boolean warned = false;
    private boolean checked;
    private boolean fSampleNamesFromDataset;
    private static final Color DEFAULT_CLASS0_COLOR = Color.LIGHT_GRAY;
    private static final Color DEFAULT_CLASS1_COLOR = Color.ORANGE;
    private static final Color[] DEFAULT_COLORS = new Color[]{DEFAULT_CLASS0_COLOR, DEFAULT_CLASS1_COLOR, Color.YELLOW, Color.MAGENTA, Color.GREEN, Color.CYAN, Color.PINK};
    private TIntObjectHashMap fItemProfilePosColorScheme;

    protected TemplateImpl(String name) {
        super(name);
        this.fClasses = new ArrayList();
        this.fItems = new ArrayList();
    }

    protected TemplateImpl() {
    }

    @Override
    protected Template.Item _getItemAsIs(int itemIndex) {
        return (Template.Item)this.fItems.get(itemIndex);
    }

    @Override
    protected Template.Item[] _getItems() {
        return this.fItems.toArray(new Template.Item[this.fItems.size()]);
    }

    @Override
    public String getClassName(int i) {
        return ((Template.Class)this.fClasses.get(i)).getName();
    }

    @Override
    public Template cloneDeep(String newName) {
        TemplateImpl newt = new TemplateImpl(newName);
        newt.fImmutable = false;
        newt.fContinuous = this.fContinuous;
        for (int i = 0; i < this.getNumClasses(); ++i) {
            Template.Class cl = this.getClass(i);
            ClassImpl newcl = new ClassImpl(cl.getName());
            newt.add(newcl);
            for (int j = 0; j < cl.getSize(); ++j) {
                Template.Item newitem = cl.getItem(j).cloneDeep();
                newcl.add(newitem);
                newt.add(newitem);
            }
        }
        newt.fCoi = this.fCoi;
        return newt;
    }

    @Override
    public int getClassOfInterestIndex() {
        return this.fCoi;
    }

    @Override
    public boolean isContinuous() {
        return this.fContinuous;
    }

    @Override
    public boolean isCategorical() {
        return !this.fContinuous;
    }

    @Override
    public Template.Class getClass(int classIndex) {
        return (Template.Class)this.fClasses.get(classIndex);
    }

    @Override
    public boolean isMemberClass(Template.Class cl) {
        int index = this.fClasses.indexOf(cl);
        return index != -1;
    }

    @Override
    public int getClassIndex(Template.Class cl) {
        return this.fClasses.indexOf(cl);
    }

    @Override
    public int getNumItems() {
        return this.fItems.size();
    }

    @Override
    public int getNumClasses() {
        return this.fClasses.size();
    }

    protected void setAux(boolean aux) {
        if (aux) {
            if (!StringUtils.contains((CharSequence)this.getName(), (CharSequence)"#")) {
                throw new IllegalStateException("Cannot make aux as the name has no # in it. Name: " + this.getName());
            }
        } else if (StringUtils.contains((CharSequence)this.getName(), (CharSequence)"#")) {
            throw new IllegalStateException("Non-aux template cannot have # in its name. Name: " + this.getName());
        }
        this.fAux = aux;
    }

    @Override
    public boolean isAux() {
        if (this.getName().indexOf(35) != -1) {
            return true;
        }
        return this.fAux;
    }

    public void setClassOfInterestIndex(int coi) {
        this.checkImmutable();
        this.fCoi = coi;
    }

    @Override
    public String getClassOfInterestName() {
        return this.getClass(this.fCoi).getName();
    }

    protected void add(Template.Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Param cl cannot be null");
        }
        this.checkImmutable();
        for (int i = 0; i < this.getNumClasses(); ++i) {
            if (!this.getClass(i).getName().equals(cl.getName())) continue;
            throw new IllegalArgumentException("Class with this name already exists: " + cl.getName() + " . The Classes in a Template must be unique");
        }
        this.fClasses.add(cl);
    }

    protected void add(Template.Item aItem) {
        if (aItem == null) {
            throw new IllegalArgumentException("Param aItem cannot be null");
        }
        this.checkImmutable();
        if (this.isContinuous()) {
            try {
                Float.parseFloat(aItem.getId());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Template is numeric but Template.Item asked to be added was not Float-parsable " + e.toString());
            }
        }
        this.fItems.add(aItem);
    }

    protected void runChecks() {
        if (!this.checked) {
            this.runChecksInit();
            this.runChecksPost();
            this.checked = true;
        }
    }

    protected ArrayList runChecksInit() {
        if (this.fClasses == null) {
            throw new RuntimeException("Cannot call method as Template has no associated Template.Class's");
        }
        if (this.fItems == null) {
            throw new RuntimeException("Cannot call method as Template has no associated Template.Items's");
        }
        ArrayList<Integer> ual = new ArrayList<Integer>(this.getNumItems());
        for (int i = 0; i < this.getNumItems(); ++i) {
            Template.Item item = (Template.Item)this.fItems.get(i);
            Integer primPos = new Integer(item.getProfilePosition());
            if (ual.contains(primPos)) {
                throw new RuntimeException("ProfilePosition has been reused! Position = " + primPos + " by Item: " + Printf.outs(item));
            }
            ual.add(primPos);
        }
        ArrayList<String> unique_item_ids_ordered_by_profile_pos = new ArrayList<String>();
        Template.Item[] items_ordered = this.getItemsOrderedByProfilePos();
        for (int i = 0; i < items_ordered.length; ++i) {
            if (unique_item_ids_ordered_by_profile_pos.contains(items_ordered[i].getId())) continue;
            unique_item_ids_ordered_by_profile_pos.add(items_ordered[i].getId());
        }
        if (!this.isContinuous() && unique_item_ids_ordered_by_profile_pos.size() != this.fClasses.size()) {
            StringBuffer err = new StringBuffer("Mismatched numbers between unique item id's: ").append(unique_item_ids_ordered_by_profile_pos.size());
            err.append(' ').append(unique_item_ids_ordered_by_profile_pos).append(" and number of Template.Class's: ").append(this.fClasses.size()).append('\n');
            for (int c = 0; c < this.fClasses.size(); ++c) {
                err.append(((Template.Class)this.fClasses.get(c)).getName()).append(' ');
            }
            throw new IllegalArgumentException(err.toString());
        }
        return unique_item_ids_ordered_by_profile_pos;
    }

    protected void runChecksPost() {
        HashSet<String> classNames = new HashSet<String>();
        for (int c = 0; c < this.fClasses.size(); ++c) {
            Template.Class cl = (Template.Class)this.fClasses.get(c);
            if (classNames.contains(cl.getName())) {
                throw new IllegalArgumentException("Duplicate class names: " + cl.getName() + "\n" + classNames);
            }
            classNames.add(cl.getName());
            if (cl.getSize() == 0) {
                throw new IllegalStateException("Empty class: " + cl.getName() + " " + cl.getSize() + " total # items: " + this.getNumItems());
            }
            Template.Item item = cl.getItem(0);
            for (int r = 0; r < this.fClasses.size(); ++r) {
                Template.Class clr = (Template.Class)this.fClasses.get(r);
                if (!clr.getName().equals(item.getId()) || r == c) continue;
                throw new IllegalStateException("Something obviously wrong items and classes mismatched: \n" + Printf.outs(this));
            }
        }
    }

    protected void assignItems2ClassInOrder() {
        int i;
        for (int i2 = 0; i2 < this.fClasses.size(); ++i2) {
            if (this.getClass(i2).getSize() == 0) continue;
            throw new RuntimeException("Items already seem to be assigned to class: " + this.getClass(i2).getName());
        }
        ArrayList unique_item_ids_ordered_by_profile_pos = this.runChecksInit();
        Hashtable idClassHash = new Hashtable();
        for (i = 0; i < unique_item_ids_ordered_by_profile_pos.size(); ++i) {
            idClassHash.put(unique_item_ids_ordered_by_profile_pos.get(i), this.fClasses.get(i));
        }
        for (i = 0; i < this.getNumItems(); ++i) {
            Template.Item item = (Template.Item)this.fItems.get(i);
            ClassImpl cl = (ClassImpl)idClassHash.get(item.getId());
            cl.add(item);
        }
        this.runChecksPost();
    }

    protected void setContinuous(boolean cont) {
        this.checkImmutable();
        this.fContinuous = cont;
        if (cont) {
            if (this.getNumItems() != this.getNumClasses()) {
                throw new IllegalStateException("Cannot make template continuous. # items: " + this.getNumItems() + " is not equal to # classes: " + this.getNumClasses());
            }
            Template.Item it = null;
            try {
                for (int i = 0; i < this.getNumItems(); ++i) {
                    it = this._getItemAsIs(i);
                    it.floatValue();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Item: " + it.getId() + " at pos: " + it.getProfilePosition() + " is not numeric. The Template cannot be set as continuous");
            }
        }
    }

    protected void setSampleNamesFromDataset(boolean set) {
        this.fSampleNamesFromDataset = set;
    }

    @Override
    public void makeImmutable() {
        this.fImmutable = true;
        this.runChecks();
    }

    private void checkImmutable() {
        if (this.fImmutable) {
            throw new ImmutedException();
        }
    }

    @Override
    public Color getItemColor(int itemProfilePos) {
        Object obj;
        if (this.fItemProfilePosColorScheme == null) {
            this.makeAutoColors();
        }
        if ((obj = this.fItemProfilePosColorScheme.get(itemProfilePos)) == null) {
            this.log.warn((Object)("No color for item at profile pos: " + itemProfilePos + " existing pos-color scheme size: " + Printf.outs(this.fItemProfilePosColorScheme)));
            return Color.WHITE;
        }
        return (Color)obj;
    }

    private void makeAutoColors() {
        this.fItemProfilePosColorScheme = new TIntObjectHashMap();
        if (this.getNumClasses() == 1 || this.isContinuous()) {
            for (int i = 0; i < this.getNumItems(); ++i) {
                this.fItemProfilePosColorScheme.put(this._getItemAsIs(i).getProfilePosition(), (Object)Color.WHITE);
            }
        } else if (this.getNumClasses() == 2) {
            Template.Class c0 = this.getClass(0);
            for (int i = 0; i < c0.getSize(); ++i) {
                this.fItemProfilePosColorScheme.put(c0.getItem(i).getProfilePosition(), (Object)DEFAULT_CLASS0_COLOR);
            }
            Template.Class c1 = this.getClass(1);
            for (int i = 0; i < c1.getSize(); ++i) {
                this.fItemProfilePosColorScheme.put(c1.getItem(i).getProfilePosition(), (Object)DEFAULT_CLASS1_COLOR);
            }
        } else {
            Color[] colors = ColorUtils.pickRandomColors(this.getNumClasses(), DEFAULT_COLORS);
            for (int c = 0; c < this.getNumClasses(); ++c) {
                Template.Class cl = this.getClass(c);
                for (int i = 0; i < cl.getSize(); ++i) {
                    this.fItemProfilePosColorScheme.put(cl.getItem(i).getProfilePosition(), (Object)colors[c]);
                }
            }
        }
    }

    public static class ItemImpl
    implements Template.Item {
        private String fId;
        protected int fProfilePos = -999;

        private ItemImpl(String id, int profilePos) {
            this.init(id, profilePos);
        }

        public static ItemImpl createItem(String id, int profilePos) {
            return new ItemImpl(id, profilePos);
        }

        private void init(String id, int profilePos) {
            this.fId = id;
            this.fProfilePos = profilePos;
        }

        @Override
        public Template.Item cloneDeep() {
            return new ItemImpl(this.fId, this.fProfilePos);
        }

        @Override
        public String getId() {
            return this.fId;
        }

        @Override
        public int getProfilePosition() {
            return this.fProfilePos;
        }

        @Override
        public float floatValue() throws NumberFormatException {
            return Float.parseFloat(this.fId);
        }

        public boolean equals(Object obj) {
            Template.Item io;
            return obj instanceof Template.Item && (io = (Template.Item)obj).getId().equals(this.fId) && io.getProfilePosition() == this.fProfilePos;
        }
    }

    public static class ClassImpl
    implements Template.Class {
        protected String fName;
        protected ArrayList fItems;

        public ClassImpl(String className) {
            this.fName = className;
            this.fItems = new ArrayList();
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Template.Item getItem(int i) {
            return (Template.Item)this.fItems.get(i);
        }

        @Override
        public Template.Item[] getItemsOrderedByProfilePos() {
            Template.Item[] items = this.fItems.toArray(new Template.Item[this.fItems.size()]);
            TIntObjectHashMap map = AbstractTemplate.hashProfilePosItemMap(items);
            int[] pp = AbstractTemplate.getProfilePositionsSorted(map);
            Template.Item[] ret = new Template.Item[pp.length];
            for (int i = 0; i < pp.length; ++i) {
                ret[i] = (Template.Item)map.get(pp[i]);
            }
            return ret;
        }

        @Override
        public int getSize() {
            return this.fItems.size();
        }

        public int hashCode() {
            return this.fName.hashCode();
        }

        @Override
        public String getMembershipInfo() {
            StringBuffer buf = new StringBuffer("Class: ").append(this.getName()).append('\n');
            buf.append("Members: \t");
            for (int i = 0; i < this.getSize(); ++i) {
                int profile_pos = this.getItem(i).getProfilePosition();
                if (profile_pos != -1) {
                    buf.append(this.getItem(i).getId()).append('[').append(i).append(',').append(profile_pos).append(']');
                } else {
                    buf.append(this.getItem(i).getId()).append('[').append(this.getItem(i).getProfilePosition()).append(']');
                }
                if (i == this.getSize() - 1) continue;
                buf.append(',');
            }
            return buf.toString();
        }

        protected void add(Template.Item item) {
            if (item == null) {
                throw new IllegalArgumentException("item cannot be null");
            }
            this.fItems.add(item);
        }
    }
}

