/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ScoredDatasetImpl
extends AbstractObject
implements ScoredDataset {
    private Dataset fDataset;
    private AddressedVector fIndVector;
    private List fRowNamesInSdsOrder;
    private GeneSet fRowNamesGeneSet;
    private Map<String, Integer> fRowNameSdsRowIndexMap;
    private MetricWeightStruc ws;

    public ScoredDatasetImpl(AddressedVector iv, Dataset ds) {
        if (iv == null) {
            throw new NullPointerException("Param AddressedVector cannot be null");
        }
        if (ds == null) {
            throw new NullPointerException("Param Dataset cannot be null");
        }
        super.initialize(ds.getName());
        int num = iv.getSize();
        if (num < 0) {
            throw new IllegalArgumentException("# features: " + num + " cannot be less than zero");
        }
        if (num > ds.getNumRow()) {
            throw new IllegalArgumentException("# sorted elements: " + num + " cannot be > Dataset length: " + ds.getNumRow());
        }
        this.fDataset = ds;
        this.fIndVector = iv;
        this.fRowNamesInSdsOrder = new ArrayList(num);
        for (int sdsrown = 0; sdsrown < num; ++sdsrown) {
            int posinds = this.sdsrown2posinds(sdsrown);
            this.fRowNamesInSdsOrder.add(ds.getRowName(posinds));
        }
        this.fRowNamesInSdsOrder = Collections.unmodifiableList(this.fRowNamesInSdsOrder);
    }

    @Override
    public RankedList cloneShallowRL(String newName) {
        super.setName(newName);
        return this;
    }

    @Override
    public Annot getAnnot() {
        return this.fDataset.getAnnot();
    }

    @Override
    public Vector getRow(int sdsrown) {
        return this.fDataset.getRow(this.sdsrown2posinds(sdsrown));
    }

    @Override
    public Vector getRow(String rowName) {
        return this.fDataset.getRow(rowName);
    }

    @Override
    public Vector[] getRows(GeneSet gset) {
        return this.fDataset.getRows(gset);
    }

    @Override
    public Vector getColumn(int coln) {
        throw new NotImplementedException();
    }

    @Override
    public float getElement(int sdsrown, int coln) {
        return this.fDataset.getElement(this.sdsrown2posinds(sdsrown), coln);
    }

    @Override
    public String getRowName(int sdsrown) {
        return (String)this.fRowNamesInSdsOrder.get(sdsrown);
    }

    @Override
    public List getRankedNames() {
        return Collections.unmodifiableList(this.fRowNamesInSdsOrder);
    }

    @Override
    public List getRowNames() {
        return this.getRankedNames();
    }

    @Override
    public GeneSet getRowNamesGeneSet() {
        if (this.fRowNamesGeneSet == null) {
            this.fRowNamesGeneSet = new GeneSet(this.getName(), new HashSet(this.getRankedNames()));
        }
        return this.fRowNamesGeneSet;
    }

    @Override
    public int getRowIndex(String rowName) {
        int index;
        if (this.fRowNameSdsRowIndexMap == null) {
            this.cacheRowNameIndex();
        }
        if ((index = this.fRowNameSdsRowIndexMap.get(rowName).intValue()) == 0) {
            if (!this.fRowNameSdsRowIndexMap.containsKey(rowName)) {
                return -1;
            }
            return 0;
        }
        return index;
    }

    private void cacheRowNameIndex() {
        if (this.fRowNameSdsRowIndexMap == null) {
            this.fRowNameSdsRowIndexMap = new HashMap<String, Integer>();
            int numRow = this.getNumRow();
            for (int sdsrown = 0; sdsrown < numRow; ++sdsrown) {
                this.fRowNameSdsRowIndexMap.put(this.getRowName(sdsrown), sdsrown);
            }
        }
    }

    @Override
    public String[] getRankedNamesArray() {
        return this.fRowNamesInSdsOrder.toArray(new String[this.fRowNamesInSdsOrder.size()]);
    }

    @Override
    public List getColumnNames() {
        return this.fDataset.getColumnNames();
    }

    @Override
    public int getColumnIndex(String colName) {
        return this.fDataset.getColumnIndex(colName);
    }

    @Override
    public String getColumnName(int coln) {
        return this.fDataset.getColumnName(coln);
    }

    @Override
    public int getNumRow() {
        return this.fIndVector.getSize();
    }

    @Override
    public int getNumCol() {
        return this.fDataset.getNumCol();
    }

    @Override
    public int getDim() {
        return this.fDataset.getDim();
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        return buf.toString();
    }

    @Override
    public Matrix getMatrix() {
        Matrix matrix = new Matrix(this.fIndVector.getSize(), this.fDataset.getNumCol());
        for (int i = 0; i < this.fIndVector.getSize(); ++i) {
            matrix.setRow(i, this.fDataset.getRow(this.sdsrown2posinds(i)));
        }
        return matrix;
    }

    private int sdsrown2posinds(int index) {
        return this.fIndVector.getAddress(index);
    }

    @Override
    public int getRank(String rowname) {
        return this.getRowIndex(rowname);
    }

    @Override
    public float getScore(int sdsrown) {
        return this.fIndVector.getScore(sdsrown);
    }

    @Override
    public float getScore(String rowName) {
        int sdsrown = this.getRowIndex(rowName);
        if (sdsrown == -1) {
            throw new IllegalArgumentException("Could not find feat index for: " + sdsrown + " " + rowName);
        }
        return this.fIndVector.getScore(sdsrown);
    }

    @Override
    public Vector getScoresV(boolean clonedCopy) {
        return this.fIndVector.getScoresV(clonedCopy);
    }

    @Override
    public int getSize() {
        return this.getNumRow();
    }

    @Override
    public int getSize(ScoreMode smode) {
        return this.getScoresV(false).getSize(smode);
    }

    @Override
    public String getRankName(int rank) {
        return this.getRowName(rank);
    }

    @Override
    public float[] getScores(GeneSet gset) {
        float[] scores = new float[gset.getNumMembers()];
        for (int i = 0; i < gset.getNumMembers(); ++i) {
            scores[i] = this.getScore(gset.getMember(i));
        }
        return scores;
    }

    @Override
    public List getNamesOfUpOrDnXRanks(int topOrBotX, boolean top) {
        return RankedList.Helper.getLabelsOfUpOrDnXRanks(topOrBotX, top, this);
    }

    @Override
    public RankedList extractRanked(ScoreMode smode) {
        return RankedList.Helper.extractRanked(smode, this);
    }

    @Override
    public RankedList extractRanked(GeneSet gset) {
        return RankedList.Helper.extract(gset, this);
    }

    @Override
    public MetricWeightStruc getMetricWeightStruc() {
        if (this.ws == null) {
            this.ws = new DefaultMetricWeightStruc(null, this);
        }
        return this.ws;
    }
}

