/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultRankedList
extends AbstractObject
implements RankedList {
    private List fRankedNames;
    private Vector fRankedScores;
    private Map<String, Integer> fRowNameSdsRowIndexMap;
    private MetricWeightStruc mws;

    public DefaultRankedList(String name, List rankedNames, TFloatArrayList rankedScores) {
        this.init(name, rankedNames, new Vector(rankedScores));
    }

    public DefaultRankedList(List rankedNames, Vector rankedScores, boolean shareNames, boolean shareScores) {
        this(null, rankedNames, rankedScores, shareNames, shareScores);
    }

    public DefaultRankedList(String name, List rankedNames, Vector rankedScores, boolean shareNames, boolean shareScores) {
        Vector scores = new Vector(rankedScores, shareScores);
        ArrayList names = shareNames ? rankedNames : new ArrayList(rankedNames);
        this.init(name, names, scores);
    }

    @Override
    public RankedList cloneShallowRL(String newName) {
        super.setName(newName);
        return this;
    }

    private void init(String name, List rankedNames, Vector rankedScores) {
        if (rankedScores == null) {
            throw new IllegalArgumentException("Param v cannot be null");
        }
        if (rankedNames == null) {
            throw new IllegalArgumentException("Param labels cannot be null");
        }
        if (rankedScores.getSize() != rankedNames.size()) {
            throw new MismatchedSizeException("Vector", rankedScores.getSize(), "Labels", rankedNames.size());
        }
        if (name == null) {
            super.initialize(" " + this.getClass().hashCode() + System.currentTimeMillis());
        } else {
            super.initialize(name);
        }
        this.fRankedScores = rankedScores;
        this.fRankedNames = Collections.unmodifiableList(rankedNames);
        this.fRankedScores.setImmutable();
    }

    @Override
    public String getQuickInfo() {
        return this.getSize() + " names";
    }

    @Override
    public String getRankName(int rank) {
        return this.fRankedNames.get(rank).toString();
    }

    @Override
    public List getRankedNames() {
        return Collections.unmodifiableList(this.fRankedNames);
    }

    @Override
    public String[] getRankedNamesArray() {
        return this.fRankedNames.toArray(new String[this.fRankedNames.size()]);
    }

    @Override
    public Vector getScoresV(boolean clonedCopy) {
        return new Vector(this.fRankedScores, clonedCopy);
    }

    @Override
    public float getScore(int rank) {
        return this.fRankedScores.getElement(rank);
    }

    @Override
    public int getRank(String name) {
        int rank = this._index(name);
        return rank;
    }

    @Override
    public float getScore(String name) {
        int index = this._index(name);
        if (index == -1) {
            throw new IllegalArgumentException("No such name: " + name + " \navailable: " + this.fRankedNames + "\n but no: " + name);
        }
        return this.fRankedScores.getElement(index);
    }

    private int _index(String rowName) {
        Integer index;
        if (this.fRowNameSdsRowIndexMap == null) {
            this.cacheRowNameIndex();
        }
        if ((index = this.fRowNameSdsRowIndexMap.get(rowName)) == null) {
            if (!this.fRowNameSdsRowIndexMap.containsKey(rowName)) {
                return -1;
            }
            return 0;
        }
        return index;
    }

    private void cacheRowNameIndex() {
        if (this.fRowNameSdsRowIndexMap == null) {
            this.fRowNameSdsRowIndexMap = new HashMap<String, Integer>();
            for (int r = 0; r < this.getSize(); ++r) {
                this.fRowNameSdsRowIndexMap.put(this.fRankedNames.get(r).toString(), r);
            }
        }
    }

    @Override
    public float[] getScores(GeneSet gset) {
        float[] scores = new float[gset.getNumMembers()];
        for (int i = 0; i < gset.getNumMembers(); ++i) {
            scores[i] = this.getScore(gset.getMember(i));
        }
        return scores;
    }

    @Override
    public RankedList extractRanked(GeneSet gset) {
        return RankedList.Helper.extract(gset, this);
    }

    @Override
    public int getSize() {
        return this.fRankedScores.getSize();
    }

    @Override
    public int getSize(ScoreMode smode) {
        return this.fRankedScores.getSize(smode);
    }

    @Override
    public List getNamesOfUpOrDnXRanks(int topOrBotX, boolean top) {
        return RankedList.Helper.getLabelsOfUpOrDnXRanks(topOrBotX, top, this);
    }

    @Override
    public RankedList extractRanked(ScoreMode smode) {
        return RankedList.Helper.extractRanked(smode, this);
    }

    @Override
    public MetricWeightStruc getMetricWeightStruc() {
        if (this.mws == null) {
            this.mws = new DefaultMetricWeightStruc(null, this);
        }
        return this.mws;
    }
}

