/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.ParserFactory;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class DefaultDataset
extends AbstractObject
implements Dataset {
    private Matrix fMatrix;
    private List fRowNames;
    private List fColNames;
    private GeneSet rowNamesGeneSet;
    private Annot fAnn;
    private File dsFile;
    private String fQuickInfo;
    private APMMatrix fAPMMatrix;
    private TObjectIntHashMap fRowIndexNameHashMap;

    public APMMatrix getAPMMatrix() {
        return this.fAPMMatrix;
    }

    protected DefaultDataset() {
    }

    public DefaultDataset(String name, Matrix matrix, List rowNames, List colNames, boolean shareAll, Annot annOpt) {
        this(name, matrix, rowNames, colNames, shareAll, shareAll, shareAll, annOpt);
    }

    public DefaultDataset(String name, Matrix matrix, List rowNames, List colNames, boolean shareAll, Annot annOpt, APMMatrix apm) {
        this(name, matrix, rowNames, colNames, shareAll, shareAll, shareAll, annOpt, apm);
    }

    public DefaultDataset(String name, Matrix matrix, String[] rowNames, String[] colNames, boolean shareMatrix, Annot annOpt) {
        this(name, matrix, DefaultDataset.toList(rowNames), DefaultDataset.toList(colNames), shareMatrix, true, true, annOpt);
    }

    public DefaultDataset(String name, Matrix matrix, Annot annOpt) {
        ArrayList<CallSite> rowNames = new ArrayList<CallSite>(matrix.getNumRow());
        ArrayList<CallSite> colNames = new ArrayList<CallSite>(matrix.getNumCol());
        for (int r = 0; r < matrix.getNumRow(); ++r) {
            rowNames.add((CallSite)((Object)("row_" + r)));
        }
        for (int c = 0; c < matrix.getNumCol(); ++c) {
            colNames.add((CallSite)((Object)("col_" + c)));
        }
        this.init(name, matrix, rowNames, colNames, annOpt);
    }

    public DefaultDataset(String name, Matrix matrix, List rowNames, List colNames, boolean shareMatrix, boolean shareRowNames, boolean shareColNames, Annot annOpt) {
        this(name, matrix, rowNames, colNames, shareMatrix, shareRowNames, shareColNames, annOpt, null);
    }

    public DefaultDataset(String name, Matrix matrix, List rowNames, List colNames, boolean shareMatrix, boolean shareRowNames, boolean shareColNames, Annot annOpt, APMMatrix apm) {
        if (matrix == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (rowNames == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("Param colNames cant be null");
        }
        Matrix dmatrix = shareMatrix ? matrix : matrix.cloneDeep();
        ArrayList drowNames = shareRowNames ? rowNames : new ArrayList(rowNames);
        ArrayList dcolNames = shareColNames ? colNames : new ArrayList(colNames);
        this.init(name, dmatrix, drowNames, dcolNames, annOpt, apm);
    }

    protected void init(String dsname, Matrix matrix, List rowNames, List colNames, Annot annOpt) {
        this.init(dsname, matrix, rowNames, colNames, annOpt, null);
    }

    protected void init(String dsName, Matrix matrix, List rowNames, List colNames, Annot annOpt, APMMatrix apm) {
        this.init_rows_and_cols(dsName, rowNames, colNames, annOpt, apm);
        this.initMatrix(matrix, rowNames, colNames);
    }

    private void initMatrix(Matrix matrix, List rowNames, List colNames) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        if (matrix.getNumRow() != rowNames.size()) {
            throw new IllegalArgumentException("Matrix nrows: " + matrix.getNumRow() + " and rownames: " + rowNames.size() + " do not match in size");
        }
        if (matrix.getNumCol() != colNames.size()) {
            throw new IllegalArgumentException("Matrix ncols: " + matrix.getNumCol() + " and colnames: " + colNames.size() + " do not match in size");
        }
        this.fMatrix = matrix;
        this.fMatrix.setImmutable();
    }

    protected void init_rows_and_cols(String dsName, List rowNames, List colNames, Annot annOpt, APMMatrix apm) {
        super.initialize(dsName);
        if (rowNames == null) {
            throw new IllegalArgumentException("rowNames cannot be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("colNames cannot be null");
        }
        this.fRowNames = rowNames;
        this.fRowNames = Collections.unmodifiableList(this.fRowNames);
        this.fColNames = colNames;
        this.fColNames = Collections.unmodifiableList(this.fColNames);
        if (annOpt != null) {
            FeatureAnnot fa = annOpt.getFeatureAnnot();
            if (fa.getNumFeatures() < this.fRowNames.size()) {
                throw new IllegalArgumentException("Annot features is less than dataset rowNames: " + fa.getNumFeatures() + " " + this.fRowNames.size());
            }
            if (fa.hasNativeDescriptions() && this.fRowNames.size() > 1) {
                fa.getNativeDesc(this.fRowNames.get(0).toString());
            }
        }
        this.fAnn = annOpt;
        DefaultDataset.ensureAllUniqueValues(this.fColNames);
        this.fAPMMatrix = apm;
    }

    protected static void ensureAllUniqueValues(List list) {
        HashSet set = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (set.contains(obj)) {
                throw new IllegalArgumentException("Duplicate COL names are NOT allowed in Datasets. The offending entry was: " + obj + " at pos: " + i);
            }
            set.add(obj);
        }
        set.clear();
    }

    @Override
    public Annot getAnnot() {
        if (this.fAnn == null) {
            FeatureAnnot fann = new FeatureAnnot(this.getName(), this.fRowNames, null);
            SampleAnnot sann = new SampleAnnot(this.getName(), this.getColumnNames());
            this.fAnn = new Annot(fann, sann);
        }
        return this.fAnn;
    }

    @Override
    public String getRowName(int rown) {
        return (String)this.fRowNames.get(rown);
    }

    @Override
    public List getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    @Override
    public int getRowIndex(String rowName) {
        int index;
        if (rowName == null) {
            throw new IllegalArgumentException("rowName cannot be null: " + rowName);
        }
        if (this.fRowIndexNameHashMap == null) {
            this.fRowIndexNameHashMap = new TObjectIntHashMap();
            for (int r = 0; r < this.fRowNames.size(); ++r) {
                this.fRowIndexNameHashMap.put(this.fRowNames.get(r), r);
            }
        }
        if ((index = this.fRowIndexNameHashMap.get((Object)rowName)) == 0 && !this.fRowIndexNameHashMap.containsKey((Object)rowName)) {
            index = -1;
            return -1;
        }
        return index;
    }

    @Override
    public List getColumnNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    @Override
    public GeneSet getRowNamesGeneSet() {
        if (this.rowNamesGeneSet == null) {
            this.rowNamesGeneSet = new GeneSet(this.getName(), new HashSet(this.fRowNames));
        }
        return this.rowNamesGeneSet;
    }

    @Override
    public int getColumnIndex(String colName) {
        return this.fColNames.indexOf(colName);
    }

    @Override
    public String getColumnName(int coln) {
        return (String)this.fColNames.get(coln);
    }

    @Override
    public int getNumRow() {
        return this.fRowNames.size();
    }

    @Override
    public int getNumCol() {
        return this.fColNames.size();
    }

    @Override
    public Vector getRow(String rowName) {
        return this.getRow(this.getRowIndex(rowName));
    }

    @Override
    public Vector[] getRows(GeneSet gset) {
        Vector[] vss = new Vector[gset.getNumMembers()];
        for (int i = 0; i < gset.getNumMembers(); ++i) {
            vss[i] = this.getRow(gset.getMember(i));
        }
        return vss;
    }

    @Override
    public float getElement(int rown, int coln) {
        return this._matrix().getElement(rown, coln);
    }

    @Override
    public Vector getRow(int rown) {
        return this._matrix().getRowV(rown);
    }

    @Override
    public Vector getColumn(int coln) {
        return this._matrix().getColumnV(coln);
    }

    @Override
    public int getDim() {
        return this._matrix().getDim();
    }

    @Override
    public Matrix getMatrix() {
        this._matrix().setImmutable();
        return this._matrix();
    }

    private Matrix _matrix() {
        if (this.fMatrix == null) {
            if (this.dsFile == null || !this.dsFile.exists()) {
                throw new IllegalStateException("ds file for lazy matrix loading is null or missing: " + this.dsFile);
            }
            try {
                this.log.debug((Object)("LAZY loading dataset from: " + this.dsFile.getPath()));
                Dataset ds = ParserFactory.readDataset(this.dsFile, true, true);
                this.initMatrix(((DefaultDataset)ds).fMatrix, this.fRowNames, this.fColNames);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.fMatrix;
    }

    @Override
    public String getQuickInfo() {
        if (this.fQuickInfo == null) {
            this._setQuickInfo();
        }
        return this.fQuickInfo;
    }

    private void _setQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        if (this.getAnnot() != null && this.getAnnot().getFeatureAnnot() != null && this.getAnnot().getSampleAnnot_global() != null) {
            FeatureAnnot fa = this.getAnnot().getFeatureAnnot();
            SampleAnnot sa = this.getAnnot().getSampleAnnot_global();
            buf.append(" (ann: ");
            if (fa != null) {
                buf.append(fa.getNumFeatures());
            } else {
                buf.append("na");
            }
            buf.append(",");
            if (sa != null) {
                buf.append(sa.getNumSamples());
            } else {
                buf.append("na");
            }
            buf.append(",");
            if (this.getAnnot().getChip() != null) {
                buf.append(this.getAnnot().getChip().getName());
            } else {
                buf.append("chip na");
            }
            buf.append(")");
        }
        this.fQuickInfo = buf.toString();
    }

    private static List toList(String[] ss) {
        ArrayList<String> list = new ArrayList<String>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            list.add(ss[i]);
        }
        return list;
    }
}

