/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.utils.ImmutedException;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.stringmatrix.impl.DefaultDenseStringMatrix2D;
import org.ujmp.core.util.MathUtil;

public class StringMatrix {
    private final DefaultDenseStringMatrix2D matrix;
    private int fRowCnt;
    private int fColCnt;
    private boolean fImmuted;

    public void replace(String thisStr, String withThisStr) {
        if (!thisStr.equals("NaN")) {
            this.checkImmuted();
        }
        this.matrix.replace(Calculation.Ret.ORIG, (Object)thisStr, (Object)withThisStr);
    }

    public StringMatrix(int nrows, int ncols) {
        if (nrows < 0) {
            throw new NegativeArraySizeException(nrows + " < 0");
        }
        if (ncols < 0) {
            throw new NegativeArraySizeException(ncols + " < 0");
        }
        this.fRowCnt = nrows;
        this.fColCnt = ncols;
        this.matrix = (DefaultDenseStringMatrix2D)Matrix.Factory.zeros(ValueType.STRING, new long[]{nrows, ncols});
        this.matrix.fill(Calculation.Ret.ORIG, (Object)"");
    }

    private StringMatrix(StringMatrix matrix) {
        this.fRowCnt = matrix.fRowCnt;
        this.fColCnt = matrix.fColCnt;
        this.fImmuted = false;
        this.matrix = (DefaultDenseStringMatrix2D)matrix.matrix.copy();
    }

    public StringMatrix cloneDeep() {
        return new StringMatrix(this);
    }

    public int getNumRow() {
        return MathUtil.longToInt((long)this.matrix.getRowCount());
    }

    public int getNumCol() {
        return MathUtil.longToInt((long)this.matrix.getColumnCount());
    }

    public String getElement(int row, int column) {
        if (this.fRowCnt <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (this.fColCnt <= column) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " < 0");
        }
        return this.matrix.getString(row, column);
    }

    public int getElementPos(int row, int col) {
        if (row >= this.getNumRow()) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.getNumRow());
        }
        if (col >= this.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " > matrix's fColCnt:" + this.getNumCol());
        }
        return row * this.fColCnt + col;
    }

    public void setElement(int row, int column, int value) {
        this.setElement(row, column, Integer.toString(value));
    }

    public void setElement(int row, int column, float value) {
        this.setElement(row, column, Float.toString(value));
    }

    public void setElement(int row, int column, String value) {
        this.checkImmuted();
        if (this.fRowCnt <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (this.fColCnt <= column) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " < 0");
        }
        this.matrix.setString(value, row, column);
    }

    public void setElement(int row, int column, Number value) {
        if (value != null) {
            this.setElement(row, column, value.toString());
        }
    }

    public void setElement(int row, int column, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                buf.append('\u001c');
            }
            buf.append(values[i]);
        }
        this.setElement(row, column, buf.toString());
    }

    public String[] getColumn(int col) {
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " < 0");
        }
        String[] ret = new String[this.fRowCnt];
        for (int i = 0; i < this.fRowCnt; ++i) {
            ret[i] = this.matrix.getString(i, col);
        }
        return ret;
    }

    public String toString() {
        return this.matrix.toString();
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    public boolean equals(StringMatrix m1) {
        if (m1 == null) {
            return false;
        }
        if (m1.fRowCnt != this.fRowCnt) {
            return false;
        }
        if (m1.fColCnt != this.fColCnt) {
            return false;
        }
        for (int i = 0; i < this.fRowCnt; ++i) {
            for (int j = 0; j < this.fColCnt; ++j) {
            }
        }
        return true;
    }

    public boolean equals(Object o1) {
        return this.matrix.equals(o1);
    }

    public void setImmutable() {
        this.fImmuted = true;
    }

    private void checkImmuted() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }
}

