/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.RandomSeedGenerator;
import java.util.Random;
import org.apache.log4j.Logger;

public class RandomSeedGenerators {
    private static final Logger klog = Logger.getLogger(RandomSeedGenerators.class);

    public static RandomSeedGenerator lookup(Object obj) {
        Long seed;
        if (obj == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (obj instanceof Timestamp) {
            klog.debug((Object)"Creating a new timestamp based rnd seed");
            return new Timestamp();
        }
        if (obj instanceof RandomSeedGenerator) {
            return (RandomSeedGenerator)obj;
        }
        if (obj instanceof Long) {
            seed = (Long)obj;
        } else {
            String s = obj.toString();
            if (s.equalsIgnoreCase("timestamp")) {
                return new Timestamp();
            }
            seed = new Long(Long.parseLong(s));
        }
        klog.debug((Object)("Creating a new seed with long: " + seed));
        return new Custom(seed);
    }

    public static class Timestamp
    implements RandomSeedGenerator {
        private Random fRandom;
        private final long timestamp = System.currentTimeMillis();

        public Timestamp() {
            this.fRandom = new Random(this.timestamp);
        }

        public String toString() {
            return "timestamp";
        }

        @Override
        public Random getRandom() {
            return this.fRandom;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class Custom
    extends Standard {
        public Custom(long seed) {
            super(seed);
        }
    }

    public static class Standard
    implements RandomSeedGenerator {
        private long fSeed;
        private Random fRandom;

        private Standard(long seed) {
            this.fSeed = seed;
            this.fRandom = new Random(this.fSeed);
        }

        public Standard() {
            this(149L);
        }

        public String toString() {
            return "" + this.fSeed;
        }

        @Override
        public Random getRandom() {
            return this.fRandom;
        }
    }
}

