/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.LabelledVector;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LabelledVectorProcessors {
    protected static final transient Logger klog = Logger.getLogger(LabelledVectorProcessors.class);

    public static LabelledVectorProcessor[] createAllProcessors() {
        return new LabelledVectorProcessor[]{new None(), new NormalizeLinear(), new NormalizeToSumTwoSided(), new NormalizeToMaxTwoSided(), new NormalizeAreaTwoSided(), new NormalizeToMaxThenAreaTwoSided()};
    }

    public static LabelledVectorProcessor lookupProcessor(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (obj instanceof LabelledVectorProcessor) {
            return (LabelledVectorProcessor)obj;
        }
        LabelledVectorProcessor[] all = LabelledVectorProcessors.createAllProcessors();
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].getName().equalsIgnoreCase(obj.toString())) continue;
            return all[i];
        }
        throw new RuntimeException("Cannot lookupProcessor for: " + obj);
    }

    public static class NormalizeToMaxThenAreaTwoSided
    extends AbstractLabelledVectorProcessor {
        @Override
        public String getName() {
            return "norm_max_then_area_two_sided";
        }

        @Override
        public LabelledVector process(LabelledVector rl) {
            LabelledVector rln = new NormalizeToMaxTwoSided().process(rl);
            return new NormalizeAreaTwoSided().process(rln);
        }
    }

    public static class NormalizeAreaTwoSided
    extends AbstractLabelledVectorProcessor {
        @Override
        public String getName() {
            return "norm_area_two_sided";
        }

        @Override
        public LabelledVector process(LabelledVector rl) {
            double negFactor;
            double posFactor;
            double totalNeg;
            double totalPos = rl.getScoresV(false).sum(ScoreMode.POS_ONLY);
            if (totalPos > (totalNeg = Math.abs(rl.getScoresV(false).sum(ScoreMode.NEG_ONLY)))) {
                posFactor = 1.0;
                negFactor = totalPos / totalNeg;
            } else {
                posFactor = totalNeg / totalPos;
                negFactor = 1.0;
            }
            Vector area_norm = new Vector(rl.getSize());
            String[] labels = new String[rl.getSize()];
            for (int r = 0; r < rl.getSize(); ++r) {
                double score = rl.getScore(r);
                labels[r] = rl.getLabel(r);
                score = XMath.isPositive(score) ? (score *= posFactor) : (score *= negFactor);
                area_norm.setElement(r, score);
            }
            System.out.println("pos_sum: " + area_norm.sum(ScoreMode.POS_ONLY) + " neg_sum: " + area_norm.sum(ScoreMode.NEG_ONLY));
            return new LabelledVector(labels, area_norm);
        }
    }

    public static class NormalizeToMaxTwoSided
    extends AbstractLabelledVectorProcessor {
        @Override
        public String getName() {
            return "norm_to_max_two_sided";
        }

        @Override
        public LabelledVector process(LabelledVector rl) {
            float maxPos = rl.getScoresV(false).max();
            float maxNeg = Math.abs(rl.getScoresV(false).min());
            Vector max_two_sided_norm = new Vector(rl.getSize());
            String[] labels = new String[rl.getSize()];
            for (int r = 0; r < rl.getSize(); ++r) {
                float score = rl.getScore(r);
                labels[r] = rl.getLabel(r);
                score = XMath.isPositive(score) ? (score /= maxPos) : (score /= maxNeg);
                max_two_sided_norm.setElement(r, score);
            }
            return new LabelledVector(labels, max_two_sided_norm);
        }
    }

    public static class NormalizeLinear
    extends AbstractLabelledVectorProcessor {
        @Override
        public String getName() {
            return "norm_linear";
        }

        @Override
        public LabelledVector process(LabelledVector orig) {
            float stop_point;
            int pos_len = orig.getMetricWeightStruc().getTotalPosLength();
            int neg_len = orig.getMetricWeightStruc().getTotalNegLength();
            float stop_point_pos = stop_point = (float)XMath.min(pos_len, neg_len);
            float start_point_neg = (float)orig.getSize() - stop_point;
            ArrayList<String> names = new ArrayList<String>();
            TFloatArrayList scores = new TFloatArrayList();
            for (int r = 0; r < orig.getSize(); ++r) {
                float score = (float)r < stop_point_pos ? (stop_point - (float)r) / stop_point : ((float)r > start_point_neg ? -1.0f * (stop_point - (float)(orig.getSize() - 1 - r)) / stop_point : 0.0f);
                scores.add(score);
                names.add(orig.getLabel(r));
            }
            return new LabelledVector(orig.getName() + "_linearized", names, scores);
        }
    }

    public static class NormalizeToSumTwoSided
    extends AbstractLabelledVectorProcessor {
        @Override
        public String getName() {
            return "norm_to_sum_two_sided";
        }

        @Override
        public LabelledVector process(LabelledVector rl) {
            double totalPos = rl.getScoresV(false).sum(ScoreMode.POS_ONLY);
            double totalNeg = Math.abs(rl.getScoresV(false).sum(ScoreMode.NEG_ONLY));
            Vector two_sided_norm = new Vector(rl.getSize());
            String[] labels = new String[rl.getSize()];
            for (int r = 0; r < rl.getSize(); ++r) {
                double score = rl.getScore(r);
                labels[r] = rl.getLabel(r);
                score = XMath.isPositive(score) ? (score /= totalPos) : (score /= totalNeg);
                two_sided_norm.setElement(r, score);
            }
            return new LabelledVector(labels, two_sided_norm);
        }
    }

    public static class None
    extends AbstractLabelledVectorProcessor {
        @Override
        public String getName() {
            return "none";
        }

        @Override
        public LabelledVector process(LabelledVector rl) {
            return rl;
        }

        @Override
        public Vector process(Vector v) {
            return v;
        }

        @Override
        public void process(List dels) {
        }
    }

    static abstract class AbstractLabelledVectorProcessor
    implements LabelledVectorProcessor {
        protected AbstractLabelledVectorProcessor() {
        }

        public String toString() {
            return this.getName();
        }

        public Vector process(Vector v) {
            return this.process(new LabelledVector("foo", v)).getScoresV(false);
        }

        @Override
        public void process(List dels) {
            Vector v = this.process(new Vector(dels));
            for (int i = 0; i < dels.size(); ++i) {
                DoubleElement del = (DoubleElement)dels.get(i);
                del.fValue = v.getElement(i);
                dels.set(i, del);
            }
        }
    }
}

