/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Vector;
import java.util.List;

public class AddressedVector {
    private int[] fAddresses;
    private Vector fVector;

    private static int[] rangeAsElements(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Max: " + max + " less than min: " + min);
        }
        int[] ret = new int[max - min + 1];
        int curr = min;
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = curr++;
        }
        return ret;
    }

    public AddressedVector(Vector v, int[] addresses, boolean share) {
        if (v == null) {
            throw new IllegalArgumentException("Param v cannot be null");
        }
        if (addresses == null) {
            throw new IllegalArgumentException("Parameter addresses cannot be null");
        }
        if (share) {
            this.init(v, addresses);
        } else {
            Vector dupv = new Vector(v);
            int[] dadd = new int[addresses.length];
            System.arraycopy(addresses, 0, dadd, 0, addresses.length);
            this.init(dupv, dadd);
        }
    }

    public AddressedVector(Vector v, boolean share) {
        this(v, AddressedVector.rangeAsElements(0, AddressedVector._max(v)), share);
    }

    private static int _max(Vector v) {
        int max = v.getSize() - 1;
        if (v.getSize() == 0) {
            max = 0;
        }
        return max;
    }

    public AddressedVector(int numElements2Copy, AddressedVector iv) {
        Vector v = new Vector(numElements2Copy, iv.fVector);
        int[] addr = new int[numElements2Copy];
        System.arraycopy(iv.fAddresses, 0, addr, 0, numElements2Copy);
        this.init(v, addr);
    }

    public AddressedVector(List listWithDoubleElements) {
        if (listWithDoubleElements == null) {
            throw new IllegalArgumentException("Param listWithDoubleElements cannot be null");
        }
        Vector v = new Vector(DoubleElement.valueArray(listWithDoubleElements));
        int[] addr = DoubleElement.indexArray(listWithDoubleElements);
        this.init(v, addr);
    }

    private void init(Vector v, int[] addresses) {
        if (v == null) {
            throw new IllegalArgumentException("Parameter v cannot be null");
        }
        if (addresses == null) {
            throw new IllegalArgumentException("Parameter addresses cannot be null");
        }
        if (v.getSize() != addresses.length) {
            throw new MismatchedSizeException("Unequal lengths - Vector", v.getSize(), "Index addresses", addresses.length);
        }
        this.fVector = v;
        this.fAddresses = addresses;
        this.fVector.setImmutable();
    }

    public int getAddress(int vector_element_index) {
        return this.fAddresses[vector_element_index];
    }

    public float getScore(int vector_element_index) {
        return this.fVector.getElement(vector_element_index);
    }

    public Vector getScoresV(boolean clonedCopy) {
        return new Vector(this.fVector, clonedCopy);
    }

    public int getSize() {
        return this.fVector.getSize();
    }
}

