/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.io;

import com.enterprisedt.net.ftp.EventAdapter;
import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPException;
import edu.mit.broad.genome.io.FtpSingleUrlTransferCommand;
import edu.mit.broad.xbench.core.api.Application;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public class FtpProgressMonitor
extends ProgressMonitor
implements EventListener {
    private static final Logger klog = Logger.getLogger(FtpProgressMonitor.class);
    private final EventAdapter eventDelegate = new EventAdapter();
    private final FtpSingleUrlTransferCommand ftpCommand;
    private long size = 1L;

    public FtpProgressMonitor(FtpSingleUrlTransferCommand ftpCommand) {
        super(Application.getWindowManager().getRootFrame(), "Retrieving file " + ftpCommand.getFileName(), "Initializing connection...", 0, 100);
        this.ftpCommand = ftpCommand;
    }

    public void initSize(long size) {
        this.size = size;
    }

    public void bytesTransferred(String connId, String remoteFilename, long count) {
        this.eventDelegate.bytesTransferred(connId, remoteFilename, count);
        if (this.isCanceled()) {
            klog.info((Object)"Cancelling...");
            this.ftpCommand.getClient().cancelAllTransfers();
            try {
                this.ftpCommand.getClient().disconnect(true);
            }
            catch (IOException ie) {
                klog.error((Object)ie);
            }
            catch (FTPException fe) {
                klog.error((Object)fe);
            }
        } else {
            int progressPercent = Math.round(100L * count / this.size);
            this.setProgress(progressPercent);
            this.setNote(progressPercent + "% complete");
        }
    }

    public void commandSent(String connId, String cmd) {
        this.eventDelegate.commandSent(connId, cmd);
    }

    public void downloadCompleted(String connId, String remoteFilename) {
        this.eventDelegate.downloadCompleted(connId, remoteFilename);
    }

    public void downloadStarted(String connId, String remoteFilename) {
        this.eventDelegate.downloadStarted(connId, remoteFilename);
    }

    public void replyReceived(String connId, String reply) {
        this.eventDelegate.replyReceived(connId, reply);
    }

    public void uploadCompleted(String connId, String remoteFilename) {
        this.eventDelegate.uploadCompleted(connId, remoteFilename);
    }

    public void uploadStarted(String connId, String remoteFilename) {
        this.eventDelegate.uploadStarted(connId, remoteFilename);
    }
}

