/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.charts;

import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.models.XYDatasetMultiTmp;
import edu.mit.broad.genome.models.XYDatasetProxy2;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import org.genepattern.io.ImageUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class XChartUtils {
    private XChartUtils() {
    }

    public static JFreeChart scatterOneXManyY(String comboTitle, String[] ytitles, String xaxisTitle, String yaxisTitle, Vector xcommon, Vector[] yss) {
        XYDatasetMultiTmp data = new XYDatasetMultiTmp(ytitles, xcommon, yss);
        return ChartFactory.createScatterPlot((String)comboTitle, (String)xaxisTitle, (String)yaxisTitle, (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
    }

    public static XYPlot lineYHits(String xaxistitle, String yaxistitle, String seriesName, Vector y) {
        XYDatasetProxy2 data = new XYDatasetProxy2(y, seriesName);
        NumberAxis xAxis = new NumberAxis(xaxistitle);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(yaxistitle);
        yAxis.setTickMarksVisible(false);
        yAxis.setTickLabelsVisible(true);
        StandardXYItemRenderer rend = new StandardXYItemRenderer(10);
        return new XYPlot((XYDataset)data, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)rend);
    }

    public static JFreeChart createHistogram(String title, boolean showlegend, String categoryAxisLabel, String valueAxisLabel, Vector v, boolean onlyLines, int numBins, HistogramType htype) {
        return XChartUtils.createHistogram(title, showlegend, categoryAxisLabel, valueAxisLabel, new String[]{valueAxisLabel}, new Vector[]{v}, onlyLines, numBins, htype);
    }

    public static JFreeChart createHistogram(String title, boolean showlegend, String categoryAxisLabel, String valueAxisLabel, String[] vnames, Vector[] vss, boolean onlyLines, int numBins, HistogramType htype) {
        float min = Float.NaN;
        float max = Float.NaN;
        HistogramDataset hds = new HistogramDataset();
        boolean tooltips = true;
        boolean urls = true;
        for (int r = 0; r < vnames.length; ++r) {
            if (Float.isNaN(min)) {
                hds.addSeries((Comparable)((Object)vnames[r]), vss[r].toArrayDouble(), numBins);
                continue;
            }
            hds.addSeries((Comparable)((Object)vnames[r]), vss[r].toArrayDouble(), numBins, (double)min, (double)max);
        }
        hds.setType(htype);
        JFreeChart chart = onlyLines ? ChartFactory.createXYLineChart((String)title, (String)categoryAxisLabel, (String)valueAxisLabel, (XYDataset)hds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showlegend, (boolean)tooltips, (boolean)urls) : ChartFactory.createHistogram((String)title, (String)"fooX", (String)"fooY", (IntervalXYDataset)hds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        plot.setForegroundAlpha(0.75f);
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        return chart;
    }

    public static final void saveAsSVG(XChart xChart, File toFile, int width, int height, boolean gZip) throws IOException {
        ImageUtil.saveAsSVG(xChart.getFreeChart(), toFile, width, height, gZip);
    }
}

