/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.alg.TwoMer;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import gnu.trove.TFloatIntHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GeneSetStats {
    private final Logger log = Logger.getLogger(GeneSetStats.class);

    public static TObjectIntHashMap featureFreq(String[] feats) {
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (int i = 0; i < feats.length; ++i) {
            int curr = 0;
            if (map.containsKey((Object)feats[i])) {
                curr = map.get((Object)feats[i]);
            }
            map.put((Object)feats[i], ++curr);
        }
        return map;
    }

    public RedStruc calcRedundancy(GeneSet[] gsets, boolean do2mersalso) {
        RedStruc rs = new RedStruc();
        if (do2mersalso) {
            rs.allFoundTwoMers = new HashSet();
            for (int i = 0; i < gsets.length; ++i) {
                int n = gsets[i].getNumMembers();
                int num = n * (n - 1) / 2;
                Set s = this.hashTwoMers(gsets[i]);
                if (s.size() != num) {
                    this.log.warn((Object)("Bad: " + s.size() + " " + num));
                }
                rs.allFoundTwoMers.addAll(s);
                rs.totNumPairsPossible += num;
            }
        }
        BitSetDataset bsd = new BitSetDataset(new DefaultGeneSetMatrix("foo", gsets));
        Dataset ds = bsd.and_by_or();
        LabelledVector lv = this.getFeatureFrequency_lv(gsets);
        rs.featureFreq = lv.sort(SortMode.REAL, Order.DESCENDING);
        float sum = 0.0f;
        rs.jaccardDistrib = new TFloatIntHashMap();
        for (int r = 0; r < ds.getNumRow(); ++r) {
            for (int c = 0; c < ds.getNumCol(); ++c) {
                sum += ds.getElement(r, c);
                if (r >= c) continue;
                int curr = rs.jaccardDistrib.get(ds.getElement(r, c));
                rs.jaccardDistrib.put(ds.getElement(r, c), ++curr);
            }
        }
        rs.jaccardMean = sum / (float)(ds.getNumRow() * ds.getNumRow());
        return rs;
    }

    public Set hashTwoMers(GeneSet gset) {
        HashSet<TwoMer> set = new HashSet<TwoMer>();
        for (int i = 0; i < gset.getNumMembers(); ++i) {
            String a = gset.getMember(i);
            for (int j = 0; j < gset.getNumMembers(); ++j) {
                if (j == i) continue;
                set.add(new TwoMer(a, gset.getMember(j)));
            }
        }
        return set;
    }

    public TObjectIntHashMap getFeatureFrequency(GeneSetMatrix gm) {
        String[] feats = gm.getAllMemberNames();
        return GeneSetStats.featureFreq(feats);
    }

    public LabelledVector getFeatureFrequency_lv(GeneSet[] gsets) {
        return this.getFeatureFrequency_lv(new DefaultGeneSetMatrix("tmp", gsets));
    }

    public LabelledVector getFeatureFrequency_lv(GeneSetMatrix gm) {
        TObjectIntHashMap map = this.getFeatureFrequency(gm);
        String[] uniqFeats = gm.getAllMemberNamesOnlyOnce();
        Vector v = new Vector(uniqFeats.length);
        for (int i = 0; i < uniqFeats.length; ++i) {
            int cnt = map.get((Object)uniqFeats[i]);
            v.setElement(i, cnt);
        }
        return new LabelledVector(uniqFeats, v);
    }

    public static class RedStruc {
        public int totNumPairsPossible;
        public Set allFoundTwoMers;
        public float jaccardMean;
        public TFloatIntHashMap jaccardDistrib;
        public RankedList featureFreq;
    }
}

