/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.ScoredDatasetImpl;
import edu.mit.broad.genome.objects.Template;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DatasetMetrics {
    public ScoredDataset scoreDataset(Metric metric, SortMode sort, Order order, Map metricParams, LabelledVectorProcessor lvp, Dataset ds, Template template) {
        if (ds == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (sort == null) {
            throw new IllegalArgumentException("Param sort cannot be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Param order cannot be null");
        }
        int rows = ds.getNumRow();
        DoubleElement[] sorted = new DoubleElement[rows];
        for (int i = 0; i < rows; ++i) {
            DoubleElement del;
            double dist = metric.getScore(ds.getRow(i), template, metricParams);
            sorted[i] = del = new DoubleElement(i, dist);
        }
        Arrays.parallelSort(sorted, new DoubleElement.DoubleElementComparator(sort, order.isAscending()));
        List<DoubleElement> dels = Arrays.asList(sorted);
        lvp.process(dels);
        return new ScoredDatasetImpl(new AddressedVector(dels), ds);
    }
}

