/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ComparatorFactory {
    public static Comparator<PersistentObject> PERSISTENT_OBJECT_BY_NAME = new Comparator<PersistentObject>(){

        @Override
        public int compare(PersistentObject o1, PersistentObject o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    private ComparatorFactory() {
    }

    public static class ChipNameComparator
    implements Comparator<String> {
        private static String highestVersionId;
        private static DefaultArtifactVersion highestVersion;

        public static String getHighestVersionId() {
            return highestVersionId;
        }

        @Override
        public int compare(String s1, String s2) {
            String versionId1 = s1.substring(s1.lastIndexOf("v"), s1.lastIndexOf(".chip"));
            String versionId2 = s2.substring(s2.lastIndexOf("v"), s2.lastIndexOf(".chip"));
            DefaultArtifactVersion version1 = new DefaultArtifactVersion(versionId1);
            DefaultArtifactVersion version2 = new DefaultArtifactVersion(versionId2);
            if (highestVersion == null) {
                if (version1.compareTo((Object)version2) < 0) {
                    highestVersion = version2;
                    highestVersionId = versionId2;
                } else {
                    highestVersion = version1;
                    highestVersionId = versionId1;
                }
            } else if (highestVersion.compareTo((Object)version2) < 0) {
                highestVersion = version2;
                highestVersionId = versionId2;
            }
            if (!version1.equals((Object)version2)) {
                return version2.compareTo((Object)version1);
            }
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class ScoredDatasetScoreComparator
    implements Comparator<String> {
        final ScoredDataset fSds;

        public ScoredDatasetScoreComparator(ScoredDataset sds) {
            this.fSds = sds;
        }

        @Override
        public int compare(String pn1, String pn2) {
            int rank1 = this.fSds.getRank(pn1);
            int rank2 = this.fSds.getRank(pn2);
            if (rank1 == -1 || rank2 == -1) {
                throw new IllegalArgumentException("Specified label not in the sds: " + pn1 + " " + pn2);
            }
            return rank1 - rank2;
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class FileExtComparator
    implements Comparator {
        public int compare(Object pn1, Object pn2) {
            String ext1 = FilenameUtils.getExtension((String)pn1.toString());
            String ext2 = FilenameUtils.getExtension((String)pn2.toString());
            return ext1.compareTo(ext2);
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class PobComparator
    implements Comparator {
        public int compare(Object pn1, Object pn2) {
            PersistentObject pob1 = (PersistentObject)pn1;
            PersistentObject pob2 = (PersistentObject)pn2;
            return pob1.getName().compareTo(pob2.getName());
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class EnrichmentResultByNESComparator
    implements Comparator {
        Order fOrder;

        public EnrichmentResultByNESComparator(Order order) {
            this.fOrder = order;
        }

        public int compare(Object pn1, Object pn2) {
            if (pn1 == null && pn2 == null) {
                return 0;
            }
            if (pn1 == null) {
                return this.fOrder.isAscending() ? -1 : 1;
            }
            if (pn2 == null) {
                return this.fOrder.isAscending() ? 1 : -1;
            }
            EnrichmentResult result1 = (EnrichmentResult)pn1;
            EnrichmentResult result2 = (EnrichmentResult)pn2;
            float nes1 = result1.getScore().getNES();
            float nes2 = result2.getScore().getNES();
            if (Float.isNaN(nes1) && Float.isNaN(nes2)) {
                return 0;
            }
            if (Float.isNaN(nes1)) {
                return this.fOrder.isAscending() ? -1 : 1;
            }
            if (Float.isNaN(nes2)) {
                return this.fOrder.isAscending() ? 1 : -1;
            }
            if (this.fOrder.isAscending()) {
                if (nes1 < nes2) {
                    return -1;
                }
                if (nes1 > nes2) {
                    return 1;
                }
                return 0;
            }
            if (nes1 < nes2) {
                return 1;
            }
            if (nes1 > nes2) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }
}

